//  "BMP" Copyright (C) 2003-2007 BMP development
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_BOOKMARK_TYPES_HH
#define BMP_BOOKMARK_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <vector>
#include <string>
#include <glibmm/ustring.h>
#include "playbacksource.hh"

using namespace Glib;
using namespace Gtk;

namespace Bmp
{
  typedef std::string URL;

  struct Bookmark
  {
    std::string             m_title;
    URL                     m_url;
    int                     m_id;
    UIManager::ui_merge_id  m_merge_id; // XXX: This never gets serialized, it's just for keeping track of bookmarks at runtime

    Bookmark (std::string const& title, int id, URL const& url, UIManager::ui_merge_id merge_id) 
    : m_title     (title)
    , m_url       (url)
    , m_id        (id)
    , m_merge_id  (merge_id)
    {}

    Bookmark (std::string const& title, int id, URL const& url) 
    : m_title     (title)
    , m_url       (url)
    , m_id        (id)
    , m_merge_id  (0)
    {}

    Bookmark () {}
  };

  typedef std::vector <Bookmark> BookmarkV;
  typedef std::map    <URL, BookmarkV::size_type> MURLIdx;
}

#endif //!BMP_BOOKMARK_TYPES_HH
