//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm/ustring.h>

using namespace std;
using namespace Glib;

namespace
{
  enum ElementId
  {
    E_BOOKMARKS,
    E_BOOKMARK_LIST,
    E_BOOKMARK,
  };
}

#include "parser/libxml2-sax-base.hh"
using Bmp::XPath;

#include "bookmarks-libxml2-sax.hh"
#include "bookmark-types.hh"

using namespace Bmp;

namespace
{
  Element_tag elements[] =
  {
      { "bookmarks"     },
      { "bookmark-list" },
      { "bookmark"      },
  };
  
  struct BookmarksParserContext : public ParseContextBase
  {
    BookmarkV & m_bookmarks;
    Bookmark    m_bookmark;

    BookmarksParserContext (Bmp::BookmarkV & bookmarks)
      : ParseContextBase()
      , m_bookmarks (bookmarks)
    {}
  };

  typedef std::map < ustring, ustring > ElementAttributes; 

#define DEFAULT_REFS \
  BookmarksParserContext & context (static_cast<BookmarksParserContext&>(_context));  \
  Bmp::BookmarkV & bookmarks (context.m_bookmarks);                         \
  Bmp::Bookmark & bookmark (context.m_bookmark);  

  //////////////////////////////////////////////////////////////////////////////

  namespace Handlers
  {
    HANDLER(bookmark)
    {
      DEFAULT_REFS
      bookmark = Bookmark(); 

      bookmark.m_title = props["title"];
      bookmark.m_url = props["href"];
      bookmark.m_id = g_ascii_strtoull (props["id"].c_str(), NULL, 10);
    }
  }

  Handler_tag handlers[] = 
  {
    { XPath(elements[E_BOOKMARKS]) / XPath(elements[E_BOOKMARK_LIST]) / XPath(elements[E_BOOKMARK]), 
      &Handlers::bookmark },
  };
  //---------
  
  namespace HandlersEnd
  {
    HANDLER_END(bookmark)
    {
      DEFAULT_REFS
      bookmarks.push_back (bookmark);
    }
  }
  
  HandlerEnd_tag handlers_end[] =
  {
    { XPath(elements[E_BOOKMARKS]) / XPath(elements[E_BOOKMARK_LIST]) / XPath(elements[E_BOOKMARK]), 
        &HandlersEnd::bookmark },
  };
}

namespace Bmp
{
  namespace Bookmarks
  {
    int parse (Bmp::BookmarkV & bookmarks, std::string const& data)
    {
      BookmarksParserContext context (bookmarks);

      for (unsigned int n = 0; n < G_N_ELEMENTS(handlers); ++n)
       {
         context.mHandlers.insert (std::make_pair (handlers[n].elementId, handlers[n].handler));
       }
       
       // handler/end 
       for (unsigned int n = 0; n < G_N_ELEMENTS(handlers_end); ++n)
       {
         context.mHandlersEnd.insert (std::make_pair (handlers_end[n].elementId, handlers_end[n].handler));
       }
       
       // name <-> id map 
       for (unsigned int n = 0; n < G_N_ELEMENTS(elements); ++n)
       {
         context.mNameIdMap.insert (std::make_pair (elements[n], ElementId (n)));
       }

      return SaxParserBase::xml_base_parse(data, context);
    }
  }
}
