{-
    BNF Converter: Main file
    Copyright (C) 2004  Author:  Markus Forberg, Peter Gammie, Michael Pellauer, Aarne Ranta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}


module Main where

-- import Utils
-- import CF
import HaskellTop
import JavaTop
import CPPTop
import CTop
import System
import Char

title = unlines [
  "The BNF Converter, 2.1", 
  "(c) Markus Forsberg, Peter Gammie, Michael Pellauer, and Aarne Ranta 2002 - 2004.",
  "Free software under GNU General Public License (GPL).",
  "Bug reports to {markus,aarne}@cs.chalmers.se."
 ]
 
main :: IO ()
main = do
  xx <- getArgs
  if xx == []
    then printUsage
    else do
      let args = (map (filter (not . isSpace)) xx)
      let file = last args
      let make = elem "-m" args
      let c = elem "-c" args
      let cpp = elem "-cpp" args
      let java = elem "-java" args
      let haskell = elem "-haskell" args
      let alex1 = "-alex1" `elem` args
          alex2 = "-alex2" `elem` args
	  alex1or2 = alex1
      let name = takeWhile (/= '.') file
      if checkUsage False [c, cpp, java, haskell] then
       do
       if (isCF (reverse file)) then 
        do 
         putStrLn title
         if c then makeC make file
           else if cpp then makeCPP make file
             else if java then makeJava make file
               else makeAll make alex1or2 file
	 else endFileErr
       else endLanguageErr
 where isCF ('f':'c':'.':_) = True
       isCF _               = False
       endFileErr = do 
                      putStr title
                      putStrLn "Error: the input file must end with .cf"
		      exitFailure
       endLanguageErr = do 
                          putStr title
                          putStrLn "Error: only one language mode may be chosen"
			  exitFailure
       printUsage = do 
                      putStr title
		      putStrLn "Usage     : bnfc [-m] [-java|-c|-cpp|-haskell] file.cf"
		      putStrLn "Option(s) : {No option} write Compiler Front End" 
		      putStrLn "          : -m          write Compiler Front End and Makefile"
		      putStrLn "Languages :"
		      putStrLn "          : (Only one language mode may be selected.)"
		      putStrLn "          : -java      Output Java code for use with JLex and CUP"
		      putStrLn "          : -c         Output C code for use with FLex and Bison"
		      putStrLn "          : -cpp       Output C++ code for use with FLex and Bison"
		      putStrLn "          : -haskell   Output Haskell code for use with Alex and Happy (Default)"
		      exitFailure
--		      putStrLn "          : -gf         write GF files"


checkUsage _ [] = True
checkUsage True (True:xs) = False
checkUsage False (True:xs) = checkUsage True xs
checkUsage old (x:xs) = checkUsage old xs
