{-
    BNF Converter: Lexer
    Copyright (C) 2004  Author: BNF Converter

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}
module LexBNF where

import Alex
import ErrM

pTSpec p = PT p . TS    

ident  p = PT p . eitherResIdent TV 

string p = PT p . TL . unescapeInitTail 

char   p = PT p . TC    

int    p = PT p . TI    


data Tok =
   TS String     -- reserved words
 | TL String     -- string literals
 | TI String     -- integer literals
 | TV String     -- identifiers
 | TD String     -- double precision float literals
 | TC String     -- character literals

 deriving (Eq,Show)

data Token = 
   PT  Posn Tok
 | Err Posn
  deriving Show

tokenPos (PT (Pn _ l _) _ :_) = "line " ++ show l
tokenPos (Err (Pn _ l _) :_) = "line " ++ show l
tokenPos _ = "end of file"

prToken t = case t of
  PT _ (TS s) -> s
  PT _ (TI s) -> s
  PT _ (TV s) -> s
  PT _ (TD s) -> s
  PT _ (TC s) -> s
  _ -> show t

tokens:: String -> [Token]
tokens inp = scan tokens_scan inp

tokens_scan:: Scan Token
tokens_scan = load_scan (tokens_acts,stop_act) tokens_lx
        where
        stop_act p ""  = []
        stop_act p inp = [Err p]

eitherResIdent :: (String -> Tok) -> String -> Tok
eitherResIdent tv s = if isResWord s then (TS s) else (tv s) where
  isResWord s = isInTree s $
    B "lower" (B "entrypoints" (B "comment" (B "coercions" (B "char" N N) N) (B "digit" N N)) (B "layout" (B "internal" (B "eps" N N) N) (B "letter" N N))) (B "terminator" (B "separator" (B "rules" (B "nonempty" N N) N) (B "stop" N N)) (B "toplevel" (B "token" N N) (B "upper" N N)))

data BTree = N | B String BTree BTree deriving (Show)

isInTree :: String -> BTree -> Bool
isInTree x tree = case tree of
  N -> False
  B a left right
   | x < a  -> isInTree x left
   | x > a  -> isInTree x right
   | x == a -> True

unescapeInitTail :: String -> String
unescapeInitTail = unesc . tail where
  unesc s = case s of
    '\\':c:cs | elem c ['\"', '\\', '\''] -> c : unesc cs
    '\\':'n':cs  -> '\n' : unesc cs
    '\\':'t':cs  -> '\t' : unesc cs
    '"':[]    -> []
    c:cs      -> c : unesc cs
    _         -> []

tokens_acts = [("char",char),("ident",ident),("int",int),("pTSpec",pTSpec),("string",string)]

tokens_lx :: [(Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))]
tokens_lx = [lx__0_0,lx__1_0,lx__2_0,lx__3_0,lx__4_0,lx__5_0,lx__6_0,lx__7_0,lx__8_0,lx__9_0,lx__10_0,lx__11_0,lx__12_0,lx__13_0,lx__14_0,lx__15_0,lx__16_0,lx__17_0,lx__18_0,lx__19_0,lx__20_0,lx__21_0,lx__22_0]
lx__0_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__0_0 = (False, [], -1, (('\t', '\255'), [('\t', 10), ('\n', 10), ('\v', 10), ('\f', 10), ('\r', 10), (' ', 10), ('"', 15), ('\'', 18), ('(', 13), (')', 13), ('*', 13), ('+', 13), (',', 13), ('-', 1), ('.', 13), ('0', 22), ('1', 22), ('2', 22), ('3', 22), ('4', 22), ('5', 22), ('6', 22), ('7', 22), ('8', 22), ('9', 22), (':', 11), (';', 13), ('?', 13), ('A', 14), ('B', 14), ('C', 14), ('D', 14), ('E', 14), ('F', 14), ('G', 14), ('H', 14), ('I', 14), ('J', 14), ('K', 14), ('L', 14), ('M', 14), ('N', 14), ('O', 14), ('P', 14), ('Q', 14), ('R', 14), ('S', 14), ('T', 14), ('U', 14), ('V', 14), ('W', 14), ('X', 14), ('Y', 14), ('Z', 14), ('[', 13), (']', 13), ('_', 13), ('a', 14), ('b', 14), ('c', 14), ('d', 14), ('e', 14), ('f', 14), ('g', 14), ('h', 14), ('i', 14), ('j', 14), ('k', 14), ('l', 14), ('m', 14), ('n', 14), ('o', 14), ('p', 14), ('q', 14), ('r', 14), ('s', 14), ('t', 14), ('u', 14), ('v', 14), ('w', 14), ('x', 14), ('y', 14), ('z', 14), ('{', 4), ('|', 13), ('}', 13), ('\192', 14), ('\193', 14), ('\194', 14), ('\195', 14), ('\196', 14), ('\197', 14), ('\198', 14), ('\199', 14), ('\200', 14), ('\201', 14), ('\202', 14), ('\203', 14), ('\204', 14), ('\205', 14), ('\206', 14), ('\207', 14), ('\208', 14), ('\209', 14), ('\210', 14), ('\211', 14), ('\212', 14), ('\213', 14), ('\214', 14), ('\216', 14), ('\217', 14), ('\218', 14), ('\219', 14), ('\220', 14), ('\221', 14), ('\222', 14), ('\223', 14), ('\224', 14), ('\225', 14), ('\226', 14), ('\227', 14), ('\228', 14), ('\229', 14), ('\230', 14), ('\231', 14), ('\232', 14), ('\233', 14), ('\234', 14), ('\235', 14), ('\236', 14), ('\237', 14), ('\238', 14), ('\239', 14), ('\240', 14), ('\241', 14), ('\242', 14), ('\243', 14), ('\244', 14), ('\245', 14), ('\246', 14), ('\248', 14), ('\249', 14), ('\250', 14), ('\251', 14), ('\252', 14), ('\253', 14), ('\254', 14), ('\255', 14)]))
lx__1_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__1_0 = (True, [(3, "pTSpec", [], Nothing, Nothing)], -1, (('-', '-'), [('-', 2)]))
lx__2_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__2_0 = (False, [], 2, (('\n', '\n'), [('\n', 3)]))
lx__3_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__3_0 = (True, [(0, "", [], Nothing, Nothing)], -1, (('0', '0'), []))
lx__4_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__4_0 = (True, [(3, "pTSpec", [], Nothing, Nothing)], -1, (('-', '-'), [('-', 5)]))
lx__5_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__5_0 = (False, [], 5, (('-', '-'), [('-', 8)]))
lx__6_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__6_0 = (False, [], 5, (('-', '}'), [('-', 8), ('}', 7)]))
lx__7_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__7_0 = (True, [(1, "", [], Nothing, Nothing)], 5, (('-', '-'), [('-', 8)]))
lx__8_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__8_0 = (False, [], 5, (('-', '}'), [('-', 6), ('}', 9)]))
lx__9_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__9_0 = (True, [(1, "", [], Nothing, Nothing)], -1, (('0', '0'), []))
lx__10_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__10_0 = (True, [(2, "", [], Nothing, Nothing)], -1, (('\t', ' '), [('\t', 10), ('\n', 10), ('\v', 10), ('\f', 10), ('\r', 10), (' ', 10)]))
lx__11_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__11_0 = (True, [(3, "pTSpec", [], Nothing, Nothing)], -1, ((':', ':'), [(':', 12)]))
lx__12_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__12_0 = (False, [], -1, (('=', '='), [('=', 13)]))
lx__13_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__13_0 = (True, [(3, "pTSpec", [], Nothing, Nothing)], -1, (('0', '0'), []))
lx__14_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__14_0 = (True, [(4, "ident", [], Nothing, Nothing)], -1, (('\'', '\255'), [('\'', 14), ('0', 14), ('1', 14), ('2', 14), ('3', 14), ('4', 14), ('5', 14), ('6', 14), ('7', 14), ('8', 14), ('9', 14), ('A', 14), ('B', 14), ('C', 14), ('D', 14), ('E', 14), ('F', 14), ('G', 14), ('H', 14), ('I', 14), ('J', 14), ('K', 14), ('L', 14), ('M', 14), ('N', 14), ('O', 14), ('P', 14), ('Q', 14), ('R', 14), ('S', 14), ('T', 14), ('U', 14), ('V', 14), ('W', 14), ('X', 14), ('Y', 14), ('Z', 14), ('_', 14), ('a', 14), ('b', 14), ('c', 14), ('d', 14), ('e', 14), ('f', 14), ('g', 14), ('h', 14), ('i', 14), ('j', 14), ('k', 14), ('l', 14), ('m', 14), ('n', 14), ('o', 14), ('p', 14), ('q', 14), ('r', 14), ('s', 14), ('t', 14), ('u', 14), ('v', 14), ('w', 14), ('x', 14), ('y', 14), ('z', 14), ('\192', 14), ('\193', 14), ('\194', 14), ('\195', 14), ('\196', 14), ('\197', 14), ('\198', 14), ('\199', 14), ('\200', 14), ('\201', 14), ('\202', 14), ('\203', 14), ('\204', 14), ('\205', 14), ('\206', 14), ('\207', 14), ('\208', 14), ('\209', 14), ('\210', 14), ('\211', 14), ('\212', 14), ('\213', 14), ('\214', 14), ('\216', 14), ('\217', 14), ('\218', 14), ('\219', 14), ('\220', 14), ('\221', 14), ('\222', 14), ('\223', 14), ('\224', 14), ('\225', 14), ('\226', 14), ('\227', 14), ('\228', 14), ('\229', 14), ('\230', 14), ('\231', 14), ('\232', 14), ('\233', 14), ('\234', 14), ('\235', 14), ('\236', 14), ('\237', 14), ('\238', 14), ('\239', 14), ('\240', 14), ('\241', 14), ('\242', 14), ('\243', 14), ('\244', 14), ('\245', 14), ('\246', 14), ('\248', 14), ('\249', 14), ('\250', 14), ('\251', 14), ('\252', 14), ('\253', 14), ('\254', 14), ('\255', 14)]))
lx__15_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__15_0 = (False, [], 15, (('\n', '\\'), [('\n', -1), ('"', 17), ('\\', 16)]))
lx__16_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__16_0 = (False, [], -1, (('"', 't'), [('"', 15), ('\'', 15), ('\\', 15), ('n', 15), ('t', 15)]))
lx__17_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__17_0 = (True, [(5, "string", [], Nothing, Nothing)], -1, (('0', '0'), []))
lx__18_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__18_0 = (False, [], 20, (('\'', '\\'), [('\'', -1), ('\\', 19)]))
lx__19_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__19_0 = (False, [], -1, (('\'', 't'), [('\'', 20), ('\\', 20), ('n', 20), ('t', 20)]))
lx__20_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__20_0 = (False, [], -1, (('\'', '\''), [('\'', 21)]))
lx__21_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__21_0 = (True, [(6, "char", [], Nothing, Nothing)], -1, (('0', '0'), []))
lx__22_0 :: (Bool, [(Int,String,[Int],Maybe((Char,Char),[(Char,Bool)]),Maybe Int)], Int, ((Char,Char),[(Char,Int)]))
lx__22_0 = (True, [(7, "int", [], Nothing, Nothing)], -1, (('0', '9'), [('0', 22), ('1', 22), ('2', 22), ('3', 22), ('4', 22), ('5', 22), ('6', 22), ('7', 22), ('8', 22), ('9', 22)]))

