/***************************************************************************
 *            mkisofs-case.h
 *
 *  mar jan 24 16:41:02 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MKISOFS_CASE_H
#define MKISOFS_CASE_H

#include <glib.h>
#include <glib-object.h>

#include <nautilus-burn-drive.h>

#include "burn-process.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_MKISOFS_BASE         (bonfire_mkisofs_base_get_type ())
#define BONFIRE_MKISOFS_BASE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_MKISOFS_BASE, BonfireMkisofsBase))
#define BONFIRE_MKISOFS_BASE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_MKISOFS_BASE, BonfireMkisofsBaseClass))
#define BONFIRE_IS_MKISOFS_BASE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_MKISOFS_BASE))
#define BONFIRE_IS_MKISOFS_BASE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_MKISOFS_BASE))
#define BONFIRE_MKISOFS_BASE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_MKISOFS_BASE, BonfireMkisofsBaseClass))

typedef struct BonfireMkisofsBasePrivate BonfireMkisofsBasePrivate;

typedef struct {
	BonfireJob parent;
	BonfireMkisofsBasePrivate *priv;
} BonfireMkisofsBase;

typedef struct {
	BonfireJobClass parent_class;

	/* virtual methods */
	BonfireBurnResult	(*set_image_src)	(BonfireMkisofsBase *base,
							 const char *label,
							 const char *grafts_list,
							 const char *excluded_list,
							 gboolean use_utf8,
							 GError **error);
} BonfireMkisofsBaseClass;

GType bonfire_mkisofs_base_get_type ();

#endif /* MKISOFS_CASE_H */
