/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/***************************************************************************
 *            menu.h
 *
 *  Sat Jun 11 12:00:29 2005
 *  Copyright  2005  Philippe Rouquier	
 *  <bonfire-app@wanadoo.fr>
 ****************************************************************************/

#ifndef _MENU_H
#define _MENU_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <glib/gi18n-lib.h>

#include <gtk/gtkstock.h>
#include <gtk/gtkaction.h>
#include <gtk/gtktoggleaction.h>

#include "utils.h"
#include "bonfire-app.h"

void on_erase_cb (GtkAction *action, BonfireApp *app);
void on_exit_cb (GtkAction *action, BonfireApp *app);

void on_burn_cb (GtkAction *action, BonfireApp *app);
void on_disc_info_cb (GtkAction *action, BonfireApp *app);
void on_about_cb (GtkAction *action, BonfireApp *app);

static GtkActionEntry entries[] = {
	{"ProjectMenu", NULL, N_("_Project")},
	{"ViewMenu", NULL, N_("_View")},
	{"EditMenu", NULL, N_("_Edit")},
	{"DiscMenu", NULL, N_("_Disc")},
	{"HelpMenu", NULL, N_("_Help")},

	{"Erase", GTK_STOCK_CLEAR, N_("_Erase"), NULL,
	 N_("Erase a disc"), G_CALLBACK (on_erase_cb)},
	{"Exit", GTK_STOCK_QUIT, N_("E_xit"), NULL,
	 N_("Exit the program"), G_CALLBACK (on_exit_cb)},
	{"About", GTK_STOCK_ABOUT, N_("About"), NULL, N_("About"),
	 G_CALLBACK (on_about_cb)},

	{"DiscInfo", GTK_STOCK_CDROM, N_("_Disc Info"), NULL,
	 N_("Display information on blank discs currently inserted"),
	 G_CALLBACK (on_disc_info_cb)},
};


static const char *description = {
	"<ui>"
	    "<menubar name='menubar' >"
	    "<menu action='ProjectMenu'>"
	    "<placeholder name='ProjectPlaceholder'/>"
	    "<separator/>"
	    "<menuitem action='Exit'/>"
	    "</menu>"
	    "<menu action='EditMenu'>"
	    "<placeholder name='EditPlaceholder'/>"
	    "</menu>"
	    "<menu action='ViewMenu'>"
	    "<placeholder name='ViewPlaceholder'/>"
	    "</menu>"
	    "<menu action='DiscMenu'>"
	    "<placeholder name='DiscPlaceholder'/>"
	    "<menuitem action='Erase'/>"
	    "</menu>"
	    "<menu action='HelpMenu'>"
	    "<menuitem action='About'/>"
	    "</menu>"
	    "</menubar>"
	"</ui>"
};

#ifdef __cplusplus
}
#endif

#endif				/* _MENU_H */
