/***************************************************************************
*            mime_filter.h
*
*  dim mai 22 18:39:03 2005
*  Copyright  2005  Philippe Rouquier
*  bonfire-app@wanadoo.fr
****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MIME_FILTER_H
#define MIME_FILTER_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkfilefilter.h>

G_BEGIN_DECLS
#define BONFIRE_TYPE_MIME_FILTER         (bonfire_mime_filter_get_type ())
#define BONFIRE_MIME_FILTER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_MIME_FILTER, BonfireMimeFilter))
#define BONFIRE_MIME_FILTER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_MIME_FILTER, BonfireMimeFilterClass))
#define BONFIRE_IS_MIME_FILTER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_MIME_FILTER))
#define BONFIRE_IS_MIME_FILTER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_MIME_FILTER))
#define BONFIRE_MIME_FILTER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_MIME_FILTER, BonfireMimeFilterClass))
typedef struct BonfireMimeFilterPrivate BonfireMimeFilterPrivate;

typedef struct {
	GtkHBox parent;

	/* Public */
	GtkWidget *combo;

	/* Private */
	BonfireMimeFilterPrivate *priv;
} BonfireMimeFilter;


typedef struct {
	GtkHBoxClass parent_class;
	/* Signal Functions */
	void (*changed) (BonfireMimeFilter * filter);
} BonfireMimeFilterClass;

GType bonfire_mime_filter_get_type ();
GtkWidget *bonfire_mime_filter_new ();

void bonfire_mime_filter_add_filter (BonfireMimeFilter * filter,
				     GtkFileFilter * item);
void bonfire_mime_filter_add_mime (BonfireMimeFilter * filter,
				   const char *mime);
void bonfire_mime_filter_unref_mime (BonfireMimeFilter * filter,
				     char *mime);
gboolean bonfire_mime_filter_filter (BonfireMimeFilter * filter,
				     char *filename, char *uri,
				     char *display_name, char *mime_type);

#endif				/* MIME_FILTER_H */
