/***************************************************************************
 *            tray.h
 *
 *  ven avr 14 16:56:49 2006
 *  Copyright  2006  Rouquier Philippe
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TRAY_H
#define TRAY_H

#include <glib.h>
#include <glib-object.h>

#include "eggtrayicon.h"
#include "burn-basics.h"

G_BEGIN_DECLS

#define BONFIRE_TYPE_TRAYICON         (bonfire_tray_icon_get_type ())
#define BONFIRE_TRAYICON(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BONFIRE_TYPE_TRAYICON, BonfireTrayIcon))
#define BONFIRE_TRAYICON_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BONFIRE_TYPE_TRAYICON, BonfireTrayIconClass))
#define BONFIRE_IS_TRAYICON(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BONFIRE_TYPE_TRAYICON))
#define BONFIRE_IS_TRAYICON_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BONFIRE_TYPE_TRAYICON))
#define BONFIRE_TRAYICON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BONFIRE_TYPE_TRAYICON, BonfireTrayIconClass))

typedef struct BonfireTrayIconPrivate BonfireTrayIconPrivate;

typedef struct {
	EggTrayIcon parent;
	BonfireTrayIconPrivate *priv;
} BonfireTrayIcon;

typedef struct {
	EggTrayIconClass parent_class;

	void		(*show_dialog)		(BonfireTrayIcon *tray, gboolean show);
	void		(*close_after)		(BonfireTrayIcon *tray, gboolean close);
	void		(*cancel)		(BonfireTrayIcon *tray);

} BonfireTrayIconClass;

GType bonfire_tray_icon_get_type ();
GtkWidget *bonfire_tray_icon_new ();

void
bonfire_tray_icon_set_progress (BonfireTrayIcon *tray, gdouble fraction, long remaining);
void
bonfire_tray_icon_set_action (BonfireTrayIcon *tray, BonfireBurnAction action);
void
bonfire_tray_icon_set_show_dialog (BonfireTrayIcon *tray, gboolean show);
#endif /* TRAY_H */
