﻿#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by
// astgenerator.boo on 29/6/2005 15:54:04
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class PropertyImpl : TypeMember, INodeWithParameters, IExplicitMember
	{

		protected ParameterDeclarationCollection _parameters;
		protected Method _getter;
		protected Method _setter;
		protected TypeReference _type;
		protected ExplicitMemberInfo _explicitInfo;

		protected PropertyImpl()
		{
			InitializeFields();
		}
		
		protected PropertyImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		

		protected PropertyImpl(Method getter, Method setter, TypeReference type, ExplicitMemberInfo explicitInfo)
		{
			InitializeFields();
			Getter = getter;
			Setter = setter;
			Type = type;
			ExplicitInfo = explicitInfo;
		}
			
		protected PropertyImpl(LexicalInfo lexicalInfo, Method getter, Method setter, TypeReference type, ExplicitMemberInfo explicitInfo) : base(lexicalInfo)
		{
			InitializeFields();
			Getter = getter;
			Setter = setter;
			Type = type;
			ExplicitInfo = explicitInfo;
		}
			
		new public Property CloneNode()
		{
			return Clone() as Property;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.Property;
			}
		}

		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}

			if (_attributes != null)
			{
				Attribute item = existing as Attribute;
				if (null != item)
				{
					Attribute newItem = (Attribute)newNode;
					if (_attributes.Replace(item, newItem))
					{
						return true;
					}
				}
			}

			if (_parameters != null)
			{
				ParameterDeclaration item = existing as ParameterDeclaration;
				if (null != item)
				{
					ParameterDeclaration newItem = (ParameterDeclaration)newNode;
					if (_parameters.Replace(item, newItem))
					{
						return true;
					}
				}
			}

			if (_getter == existing)
			{
				this.Getter = (Method)newNode;
				return true;
			}

			if (_setter == existing)
			{
				this.Setter = (Method)newNode;
				return true;
			}

			if (_type == existing)
			{
				this.Type = (TypeReference)newNode;
				return true;
			}

			if (_explicitInfo == existing)
			{
				this.ExplicitInfo = (ExplicitMemberInfo)newNode;
				return true;
			}

			return false;
		}

		override public object Clone()
		{
			Property clone = FormatterServices.GetUninitializedObject(typeof(Property)) as Property;
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			clone._entity = _entity;
			clone._annotations = null != _annotations ? (Hashtable)_annotations.Clone() : null;
			

			clone._modifiers = _modifiers;

			clone._name = _name;

			if (null != _attributes)
			{
				clone._attributes = _attributes.Clone() as AttributeCollection;
				clone._attributes.InitializeParent(clone);
			}

			if (null != _parameters)
			{
				clone._parameters = _parameters.Clone() as ParameterDeclarationCollection;
				clone._parameters.InitializeParent(clone);
			}

			if (null != _getter)
			{
				clone._getter = _getter.Clone() as Method;
				clone._getter.InitializeParent(clone);
			}

			if (null != _setter)
			{
				clone._setter = _setter.Clone() as Method;
				clone._setter.InitializeParent(clone);
			}

			if (null != _type)
			{
				clone._type = _type.Clone() as TypeReference;
				clone._type.InitializeParent(clone);
			}

			if (null != _explicitInfo)
			{
				clone._explicitInfo = _explicitInfo.Clone() as ExplicitMemberInfo;
				clone._explicitInfo.InitializeParent(clone);
			}
			
			return clone;
		}
			
		override public void ClearTypeSystemBindings()
		{
			_annotations = null;
			_entity = null;
			

			if (null != _attributes)
			{
				_attributes.ClearTypeSystemBindings();
			}

			if (null != _parameters)
			{
				_parameters.ClearTypeSystemBindings();
			}

			if (null != _getter)
			{
				_getter.ClearTypeSystemBindings();
			}

			if (null != _setter)
			{
				_setter.ClearTypeSystemBindings();
			}

			if (null != _type)
			{
				_type.ClearTypeSystemBindings();
			}

			if (null != _explicitInfo)
			{
				_explicitInfo.ClearTypeSystemBindings();
			}

		}

		[System.Xml.Serialization.XmlElement]
		public ParameterDeclarationCollection Parameters
		{
			get
			{
				return _parameters;
			}
			

			set
			{
				if (_parameters != value)
				{
					_parameters = value;
					if (null != _parameters)
					{
						_parameters.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public Method Getter
		{
			get
			{
				return _getter;
			}
			

			set
			{
				if (_getter != value)
				{
					_getter = value;
					if (null != _getter)
					{
						_getter.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public Method Setter
		{
			get
			{
				return _setter;
			}
			

			set
			{
				if (_setter != value)
				{
					_setter = value;
					if (null != _setter)
					{
						_setter.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public TypeReference Type
		{
			get
			{
				return _type;
			}
			

			set
			{
				if (_type != value)
				{
					_type = value;
					if (null != _type)
					{
						_type.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public ExplicitMemberInfo ExplicitInfo
		{
			get
			{
				return _explicitInfo;
			}
			

			set
			{
				if (_explicitInfo != value)
				{
					_explicitInfo = value;
					if (null != _explicitInfo)
					{
						_explicitInfo.InitializeParent(this);

					}
				}
			}
			

		}
		

		private void InitializeFields()
		{
			_parameters = new ParameterDeclarationCollection(this);

		}
	}
}
