
namespace Boo.Lang.Parser.Tests
{
	using NUnit.Framework;
	
	[TestFixture]
	public class ParserRoundtripTestFixture : AbstractParserTestFixture
	{
		void RunCompilerTestCase(string fname)
		{
			RunParserTestCase(fname);
		}

		[Test]
		public void arrays_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/arrays-1.boo");
		}
		
		[Test]
		public void arrays_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/arrays-2.boo");
		}
		
		[Test]
		public void arrays_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/arrays-3.boo");
		}
		
		[Test]
		public void arrays_4()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/arrays-4.boo");
		}
		
		[Test]
		public void arrays_5()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/arrays-5.boo");
		}
		
		[Test]
		public void assignment_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/assignment-1.boo");
		}
		
		[Test]
		public void attributes_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/attributes-1.boo");
		}
		
		[Test]
		public void bool_literals_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/bool-literals-1.boo");
		}
		
		[Test]
		public void callables_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/callables-1.boo");
		}
		
		[Test]
		public void callables_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/callables-2.boo");
		}
		
		[Test]
		public void char_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/char-1.boo");
		}
		
		[Test]
		public void class_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/class-1.boo");
		}
		
		[Test]
		public void class_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/class-2.boo");
		}
		
		[Test]
		public void class_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/class-3.boo");
		}
		
		[Test]
		public void closures_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-1.boo");
		}
		
		[Test]
		public void closures_10()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-10.boo");
		}
		
		[Test]
		public void closures_11()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-11.boo");
		}
		
		[Test]
		public void closures_12()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-12.boo");
		}
		
		[Test]
		public void closures_13()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-13.boo");
		}
		
		[Test]
		public void closures_14()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-14.boo");
		}
		
		[Test]
		public void closures_15()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-15.boo");
		}
		
		[Test]
		public void closures_16()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-16.boo");
		}
		
		[Test]
		public void closures_17()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-17.boo");
		}
		
		[Test]
		public void closures_18()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-18.boo");
		}
		
		[Test]
		public void closures_19()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-19.boo");
		}
		
		[Test]
		public void closures_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-2.boo");
		}
		
		[Test]
		public void closures_20()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-20.boo");
		}
		
		[Test]
		public void closures_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-3.boo");
		}
		
		[Test]
		public void closures_4()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-4.boo");
		}
		
		[Test]
		public void closures_5()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-5.boo");
		}
		
		[Test]
		public void closures_6()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-6.boo");
		}
		
		[Test]
		public void closures_7()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-7.boo");
		}
		
		[Test]
		public void closures_8()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-8.boo");
		}
		
		[Test]
		public void closures_9()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/closures-9.boo");
		}
		
		[Test]
		public void comments_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/comments-1.boo");
		}
		
		[Test]
		public void comments_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/comments-2.boo");
		}
		
		[Test]
		public void comments_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/comments-3.boo");
		}
		
		[Test]
		public void comments_4()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/comments-4.boo");
		}
		
		[Test]
		public void declarations_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/declarations-1.boo");
		}
		
		[Test]
		public void double_literals_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/double-literals-1.boo");
		}
		
		[Test]
		public void elif_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/elif-1.boo");
		}
		
		[Test]
		public void enums_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/enums-1.boo");
		}
		
		[Test]
		public void events_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/events-1.boo");
		}
		
		[Test]
		public void expressions_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/expressions-1.boo");
		}
		
		[Test]
		public void expressions_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/expressions-2.boo");
		}
		
		[Test]
		public void expressions_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/expressions-3.boo");
		}
		
		[Test]
		public void expressions_4()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/expressions-4.boo");
		}
		
		[Test]
		public void expressions_5()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/expressions-5.boo");
		}
		
		[Test]
		public void fields_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/fields-1.boo");
		}
		
		[Test]
		public void fields_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/fields-2.boo");
		}
		
		[Test]
		public void fields_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/fields-3.boo");
		}
		
		[Test]
		public void fields_4()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/fields-4.boo");
		}
		
		[Test]
		public void fields_5()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/fields-5.boo");
		}
		
		[Test]
		public void generators_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/generators-1.boo");
		}
		
		[Test]
		public void generators_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/generators-2.boo");
		}
		
		[Test]
		public void generators_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/generators-3.boo");
		}
		
		[Test]
		public void getset_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/getset-1.boo");
		}
		
		[Test]
		public void goto_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/goto-1.boo");
		}
		
		[Test]
		public void goto_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/goto-2.boo");
		}
		
		[Test]
		public void hash_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/hash-1.boo");
		}
		
		[Test]
		public void iif_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/iif-1.boo");
		}
		
		[Test]
		public void import_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/import-1.boo");
		}
		
		[Test]
		public void import_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/import-2.boo");
		}
		
		[Test]
		public void in_not_in_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/in-not-in-1.boo");
		}
		
		[Test]
		public void inplace_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/inplace-1.boo");
		}
		
		[Test]
		public void interpolation_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/interpolation-1.boo");
		}
		
		[Test]
		public void interpolation_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/interpolation-2.boo");
		}
		
		[Test]
		public void invocation_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/invocation-1.boo");
		}
		
		[Test]
		public void isa_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/isa-1.boo");
		}
		
		[Test]
		public void line_continuation_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/line-continuation-1.boo");
		}
		
		[Test]
		public void list_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/list-1.boo");
		}
		
		[Test]
		public void macros_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/macros-1.boo");
		}
		
		[Test]
		public void macros_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/macros-2.boo");
		}
		
		[Test]
		public void macros_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/macros-3.boo");
		}
		
		[Test]
		public void module_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/module-1.boo");
		}
		
		[Test]
		public void module_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/module-2.boo");
		}
		
		[Test]
		public void module_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/module-3.boo");
		}
		
		[Test]
		public void named_arguments_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/named-arguments-1.boo");
		}
		
		[Test]
		public void named_arguments_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/named-arguments-2.boo");
		}
		
		[Test]
		public void not_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/not-1.boo");
		}
		
		[Test]
		public void not_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/not-2.boo");
		}
		
		[Test]
		public void null_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/null-1.boo");
		}
		
		[Test]
		public void regex_literals_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/regex-literals-1.boo");
		}
		
		[Test]
		public void regex_literals_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/regex-literals-2.boo");
		}
		
		[Test]
		public void return_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/return-1.boo");
		}
		
		[Test]
		public void return_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/return-2.boo");
		}
		
		[Test]
		public void self_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/self-1.boo");
		}
		
		[Test]
		public void semicolons_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/semicolons-1.boo");
		}
		
		[Test]
		public void slicing_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/slicing-1.boo");
		}
		
		[Test]
		public void slicing_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/slicing-2.boo");
		}
		
		[Test]
		public void string_literals_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/string-literals-1.boo");
		}
		
		[Test]
		public void struct_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/struct-1.boo");
		}
		
		[Test]
		public void timespan_literals_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/timespan-literals-1.boo");
		}
		
		[Test]
		public void try_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/try-1.boo");
		}
		
		[Test]
		public void try_2()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/try-2.boo");
		}
		
		[Test]
		public void try_3()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/try-3.boo");
		}
		
		[Test]
		public void unless_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/unless-1.boo");
		}
		
		[Test]
		public void varargs_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/varargs-1.boo");
		}
		
		[Test]
		public void xor_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/xor-1.boo");
		}
		
		[Test]
		public void yield_1()
		{
			RunCompilerTestCase(@"/home/rodrigob/dotnet/boo/tests/testcases/parser/roundtrip/yield-1.boo");
		}
		
	}
}
