#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class MethodInvocationExpressionImpl : Expression, INodeWithArguments
	{
		protected Expression _target;

		protected ExpressionCollection _arguments;

		protected ExpressionPairCollection _namedArguments;

		protected MethodInvocationExpressionImpl()
		{
			InitializeFields();
		}
		
		protected MethodInvocationExpressionImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		
		protected MethodInvocationExpressionImpl(Expression target)
		{
			InitializeFields();
			Target = target;
		}
			
		protected MethodInvocationExpressionImpl(LexicalInfo lexicalInfo, Expression target) : base(lexicalInfo)
		{
			InitializeFields();
			Target = target;
		}

		new public MethodInvocationExpression CloneNode()
		{
			return Clone() as MethodInvocationExpression;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.MethodInvocationExpression;
			}
		}
		
		override public bool Matches(Node node)
		{	
			MethodInvocationExpression other = node as MethodInvocationExpression;
			if (null == other) return false;
			if (!Node.Matches(_target, other._target)) return false;
			if (!Node.Matches(_arguments, other._arguments)) return false;
			if (!Node.Matches(_namedArguments, other._namedArguments)) return false;
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_target == existing)
			{
				this.Target = (Expression)newNode;
				return true;
			}
			if (_arguments != null)
			{
				Expression item = existing as Expression;
				if (null != item)
				{
					Expression newItem = (Expression)newNode;
					if (_arguments.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_namedArguments != null)
			{
				ExpressionPair item = existing as ExpressionPair;
				if (null != item)
				{
					ExpressionPair newItem = (ExpressionPair)newNode;
					if (_namedArguments.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			return false;
		}
		
		override public object Clone()
		{
			MethodInvocationExpression clone = (MethodInvocationExpression)FormatterServices.GetUninitializedObject(typeof(MethodInvocationExpression));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			//clone._entity = _entity;
			clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._expressionType = _expressionType;
			if (null != _target)
			{
				clone._target = _target.Clone() as Expression;
				clone._target.InitializeParent(clone);
			}
			if (null != _arguments)
			{
				clone._arguments = _arguments.Clone() as ExpressionCollection;
				clone._arguments.InitializeParent(clone);
			}
			if (null != _namedArguments)
			{
				clone._namedArguments = _namedArguments.Clone() as ExpressionPairCollection;
				clone._namedArguments.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			//_entity = null;
			_expressionType = null;
			if (null != _target)
			{
				_target.ClearTypeSystemBindings();
			}
			if (null != _arguments)
			{
				_arguments.ClearTypeSystemBindings();
			}
			if (null != _namedArguments)
			{
				_namedArguments.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public Expression Target
		{
			get
			{
				return _target;
			}

			set
			{
				if (_target != value)
				{
					_target = value;
					if (null != _target)
					{
						_target.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public ExpressionCollection Arguments
		{
			get
			{
				return _arguments;
			}

			set
			{
				if (_arguments != value)
				{
					_arguments = value;
					if (null != _arguments)
					{
						_arguments.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public ExpressionPairCollection NamedArguments
		{
			get
			{
				return _namedArguments;
			}

			set
			{
				if (_namedArguments != value)
				{
					_namedArguments = value;
					if (null != _namedArguments)
					{
						_namedArguments.InitializeParent(this);
					}
				}
			}

		}
		
		private void InitializeFields()
		{

			_arguments = new ExpressionCollection(this);

			_namedArguments = new ExpressionPairCollection(this);

		}
	}
}

