var gXBEL=null;
var gSelectedFolder="";
var gAcceptButton=null;
var gDirty=false;

function setcheckbox(aID,aDef)
{
  document.getElementById(aID).checked=gXBEL.settings.getBool(aID,aDef);
}

function getcheckbox(aID)
{
  try{
  gXBEL.settings.setBool(aID,document.getElementById(aID).checked);
  }catch(e){alert(aID);}
}


function initFolder(uri)
{
  initServices();
  initBMService();
  var exists=true;
  var res=RDF.GetResource(uri);
  if(! BMSVC.isBookmarkedResource(res)){
    res=RDF.GetResource("NC:BookmarksRoot");
    exists=false;
  }
  var nameArc=RDF.GetResource(gNC_NS+"Name");
  var target=BMDS.GetTarget(res,nameArc,true);
  var name="";
  if(target)
    name=target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  var textbox=document.getElementById("folder-textbox");
  textbox.value=name;

  gSelectedFolder=res.Value;
  dirtyHandler(textbox);

  return exists;
}

function flush()
{
  gXBEL.settings.host=document.getElementById('host').value;
  gXBEL.settings.user=document.getElementById('username').value;
  gXBEL.settings.password=document.getElementById('password').value;
  gXBEL.settings.path=document.getElementById('path').value;
  gXBEL.settings.dlurl=document.getElementById('dlurl').value;
  gXBEL.settings.tags=document.getElementById('addtag').value;
  gXBEL.settings.charset=document.getElementById('charset').value;
  var protocol=document.getElementById('protocol').selectedItem;
  gXBEL.settings.protocol=(protocol)? protocol.value:"ftp";
  gXBEL.settings.selectedFolder=gSelectedFolder;
  var checkboxs=document.getElementsByTagName("checkbox");
  for(var i=0; i<checkboxs.length;i++)
    getcheckbox(checkboxs[i].id);
}

function refresh()
{

  if(gDirty && confirm(gXBEL.settings.getString("applyconfirm")))
  {
    onApply();
    return;
  }

  document.getElementById('path').value=gXBEL.settings.path;
  document.getElementById('dlurl').value=gXBEL.settings.dlurl;
  document.getElementById('addtag').value=gXBEL.settings.tags;
  document.getElementById('charset').value=gXBEL.settings.charset;
  document.getElementById("protocol").selectedItem=document.getElementById(gXBEL.settings.protocol);
  document.getElementById('host').value=gXBEL.settings.host;
  document.getElementById('username').value=gXBEL.settings.user;
  document.getElementById('password').value=gXBEL.settings.password;
  document.getElementById('masked').value=gXBEL.settings.maskedDownloadURI;


  setcheckbox("autodownload",false);
  setcheckbox("autoupload",false);
  setcheckbox("dirtycheck",true);
  setcheckbox("merge",false);
  setcheckbox("publicid",true);
  setcheckbox("favicon",true);
  setcheckbox("livemark",true);
  setcheckbox("keyword",true);
  setcheckbox("webpanel",true);
  setcheckbox("session.enabled",false);

  var exists=initFolder(gXBEL.settings.selectedFolder);

  gDirty=false;
  gAcceptButton.setAttribute("disabled","true");

  var textboxs=document.getElementsByTagName("textbox");
  for(var i=0; i<textboxs.length; i++)
    textboxs[i].setAttribute("dirty","false");
  var checkboxs=document.getElementsByTagName("checkbox");
  for(var j=0; j<checkboxs.length; j++)
    checkboxs[j].setAttribute("dirty","false");
  document.getElementById("protocol").setAttribute("dirty","false");

  if(!exists)
    dirtyHandler(document.getElementById("folder-textbox"));
  updateSessions();

}

function updateSessions(){
  document.getElementById("undo-button")
          .setAttribute("disabled",gXBEL.settings.undoable? "false":"true");
  document.getElementById("redo-button")
          .setAttribute("disabled",gXBEL.settings.redoable? "false":"true");
}

function clearSession(){
  gXBEL.settings.undoCache="";
  gXBEL.settings.redoCache="";
  updateSessions();
}

function redo(){
  gXBEL.redo();
  updateSessions();
}

function undo(){
  gXBEL.undo();
  updateSessions();
}

function getExportFile()
{
  var fp = Components.classes["@mozilla.org/filepicker;1"]
      .createInstance(Components.interfaces.nsIFilePicker);
  fp.init(window, gXBEL.settings.title, fp.modeSave);
  fp.appendFilter("XML Document(*.xml)","*.xml;");
  fp.appendFilters(fp.filterAll);
  fp.defaultString="xbel.xml";
  return (fp.show() == fp.returnCancel)? null:fp.file;
}

function getImportFile()
{
  var fp = Components.classes["@mozilla.org/filepicker;1"]
      .createInstance(Components.interfaces.nsIFilePicker);
  fp.init(window, gXBEL.settings.title, fp.modeOpen);
  fp.appendFilter("XML Document(*.xml)","*.xml;");
  fp.appendFilters(fp.filterAll);
  return (fp.show() == fp.returnCancel)? null:fp.file;
}

/*  Event Handlers  */
function onOK()
{
  flush();
}

function onLoad()
{
  gXBEL=new BookmarksSynchronizerXBEL();
  gAcceptButton=document.getAnonymousElementByAttribute(document.documentElement, "dlgtype", "extra1");
  refresh();

  var textboxs=document.getElementsByTagName("textbox");
  for(var i=0; i<textboxs.length; i++)
    textboxs[i].addEventListener("input",function(event){dirtyHandler(event.target);},false);
  var checkboxs=document.getElementsByTagName("checkbox");
  for(var j=0; j<checkboxs.length; j++)
    checkboxs[j].addEventListener("command",function(event){dirtyHandler(event.target);},false);
  var radios=document.getElementsByTagName("radio");
  for(var k=0; k<radios.length; k++)
    radios[k].addEventListener("command",function(event){dirtyHandler(event.target.radioGroup);},false);


}

function onApply()
{
  if(!gDirty) return;
  gDirty=false;
  gAcceptButton.setAttribute("disabled","true");

  flush();

  var textboxs=document.getElementsByTagName("textbox");
  for(var i=0; i<textboxs.length; i++)
    textboxs[i].setAttribute("dirty","false");
  var checkboxs=document.getElementsByTagName("checkbox");
  for(var j=0; j<checkboxs.length; j++)
    checkboxs[j].setAttribute("dirty","false");
  document.getElementById("protocol").setAttribute("dirty","false");

  document.getElementById('masked').value=gXBEL.settings.maskedDownloadURI;
  updateSessions();
}


function dirtyHandler(aTarget)
{
  aTarget.setAttribute("dirty","true");
  if(!gAcceptButton || gDirty) return;
  gDirty=true;
  gAcceptButton.setAttribute("disabled","false");
}


/* commands */

function selectBMFolder()
{
  window.open("chrome://bookmarksftp/content/selectFolder.xul","_blank","chrome,resizable,modal");
}

function upload()
{
  refresh();
  window.open("chrome://bookmarksftp/content/upload.xul","_blank","chrome,resizable,titlebar=no");
}
function download()
{
  refresh();
  gXBEL.updateUndoCache();
  window.open("chrome://bookmarksftp/content/download.xul","_blank","chrome,resizable,titlebar=no");
  updateSessions();
}

function importXBEL()
{
  gXBEL.updateUndoCache();
  refresh();
  var file=getImportFile();
  if(!file) return;

  try{
    gXBEL.source=gXBEL.settings.read(file);
  }catch(e){
    if(e && e.toString().match(/^bmsync\:(.+)$/))
      e=gXBEL.settings.getString(RegExp.$1);
    alert(e);
  }
  updateSessions();
}

function exportXBEL()
{
  refresh();
  var file=getExportFile();
  if(!file) return;
  gXBEL.settings.write(file,gXBEL.source);
}
