//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Img3D/Type/InsideForm.h
//! @brief     Defines Img3D::BuilderUtils namespace
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_IMG3D_TYPE_INSIDEFORM_H
#define BORNAGAIN_IMG3D_TYPE_INSIDEFORM_H

#include <heinz/Vectors3D.h>

class IFormFactor;

namespace Img3D {

//! Returns true if position is inside form.
bool insideForm(const IFormFactor* ff, R3 position);

} // namespace Img3D

#endif // BORNAGAIN_IMG3D_TYPE_INSIDEFORM_H
