+++
title = "Windows"
weight = 50
+++

## Build under Windows

The following instructions have been tested under Windows 10 Pro.
Last full test from our side was for release 1.19.


### Prerequisites

#### Visual Studio

Download **Visual Studio Community Edition** from from the official website [visualstudio.microsoft.com](https://visualstudio.microsoft.com)
The current build instructions are tested with Visual Studio 2022.

#### Qt

Download Qt from from the official website [qt.io](https://www.qt.io/download-open-source)

> Make sure to choose the open source version of Qt and download the online installer.

Select the latest Qt version with long-time support (LTS) and open the sub tree.
Only the 'MSVC 2019 64-bit' component is needed.

Make a symbolic link to the directory corresponding to the current Qt version:
if Qt 6.y.z installed in `C:\Qt\6.y.z`, then in Windows `cmd` (with administrative rights) execute:

```
$ mklink /D "C:\Qt\current" "C:\Qt\6.y.z"
$ mklink /D "C:\Qt\msvc" "C:\Qt\6.y.z\msvc2019_64"
```

#### CMake

Download the **Windows x64 Installer** from the official website [cmake.org/download](https://cmake.org/download)

#### Python + Packages

Next up, download Python 3.9. For that, go to [python.org/downloads/](https://www.python.org/downloads), look for **Python 3.9.x** and download the **Windows installer (64-bit)**. Follow the setup and make sure to add Python to `PATH`.

Once Python is set up correctly, install `numpy`. Therefore open a PowerShell and type the command:

```
py -m pip install numpy
```

Analogously install `matplotlib` with

```
py -m pip install matplotlib
```

#### NSIS (for packaging only)

Download and install NSIS 3.03 from the [official website](https://nsis.sourceforge.io/Download).
Add NSIS to the system `PATH`; see below.

#### SWIG

If you want to re-build the Python-API with SWIG, download and install SWIG
from the official website
[swig.org/download.html](http://www.swig.org/download.html).
Installation instructions are at http://www.swig.org/Doc4.1/windows.html.

Unpack the ZIP file and add its folder to PATH (so e.g. `C:\swigwin-4.0.2`)

#### Libraries

Go to https://computing.mlz-garching.de/download/WinLibs

From there download:

- libcerf1.14.win64.zip (complex error function, Voigt function etc)
- libformfactor (TODO: will be provided when requested)
- libfftw3.win64.zip (fast Fourier transform)
- libtiff.win64.zip (Support for TIFF images)
- gsl_2.7.1_win64_shared.zip (GNU Scientific Library)
- boost_1_77_0.7z (C++ Library boost, including BZIP2 and ZLib)

Create the folders

`C:\opt\x64\include`\
`C:\opt\x64\lib`

and paste the corresponding content from the ZIP files in those two folders.

#### System Enviroment Variables

After those installations your `PATH` should contain

```
C:\Qt\6.y.z\msvc2019_64\bin
C:\Program Files\Python39\Scripts\
C:\Program Files\Python39\
C:\opt\x64\include
C:\opt\x64\lib
C:\Program Files\CMake\bin
C:\Program Files (x86)\NSIS
```

### Build

With all prerequisites completed, you should be able to build and test BornAgain in a PowerShell.
In there, execute

```
$OPTLIBS = "C:/opt/x64"
$FFTW3_INCLUDE_DIR = "$OPTLIBS/include"
$FFTW3_LIB = "$OPTLIBS/lib/libfftw3-3.lib"
$QTDIR = "C:/Qt/current/msvc2019_64"
$QTCMake_DIR = "$QTDIR/lib/cmake"
$BUILD_DIR = "build"

mkdir -Force "$BUILD_DIR"
cd "$BUILD_DIR"

cmake -G "Visual Studio 17 2022" -A x64 -T host=x64 -DLIB_MAN=OFF -DQTDIR="$QTDIR" -DQt6_DIR="$QTCMake_DIR/Qt6" -DQt6Test_DIR="$QTCMake_DIR/Qt6Test" -DFFTW3_INCLUDE_DIR="$FFTW3_INCLUDE_DIR" -DFFTW3_LIBRARY="$FFTW3_LIB" -DCMAKE_INCLUDE_PATH="$OPTLIBS/include" -DCMAKE_LIBRARY_PATH="$OPTLIBS/lib" -DCMAKE_CXX_COMPILER_LAUNCHER=ccache -DCMAKE_C_COMPILER="cl.exe" -DCMAKE_CXX_COMPILER="cl.exe" -B. ..

cmake --build . --config Release

ctest -C Release --parallel 8 --output-on-failure
```
<br>

<details> <summary> <b> Build with Ninja (Experimental) </b> </summary>

Compilation might be accelerated if Ninja is used as a build system.
Download the Ninja binary for Windows from [ninja-build.org](https://ninja-build.org). Add the binaries to a directory in your `PATH`; e.g. `C:\Program Files\ninja`.

To use Ninja as the build system, the compilation cannot be performed in a PowerShell but in the Visual Studio Shell **x64 Native Tools Command Prompt for VS 2019** which you can search for in the start menu.

Use the following commands to build BornAgain:
```
set OPTLIBS=C:/opt/x64
set FFTW3_INCLUDE_DIR=%OPTLIBS%/include
set FFTW3_LIB=%OPTLIBS%/lib/libfftw3-3.lib
set QTDIR=C:/Qt/current/msvc2019_64
set QTCMake_DIR=%QTDIR%/lib/cmake
set BUILD_DIR=buildnj

mkdir "%BUILD_DIR%"
cd "%BUILD_DIR%"

cmake --version

cmake -G "Ninja" -DCMAKE_BUILD_TYPE=Release -DQTDIR="%QTDIR%" -DQt6_DIR="%QTCMake_DIR%/Qt6" -DQt6Test_DIR="%QTCMake_DIR%/Qt6Test" -DFFTW3_INCLUDE_DIR="%FFTW3_INCLUDE_DIR%" -DFFTW3_LIBRARY="%FFTW3_LIB%" -DCMAKE_INCLUDE_PATH="%OPTLIBS%/include" -DCMAKE_LIBRARY_PATH="%OPTLIBS%/lib" -DLIB_MAN=OFF -DCMAKE_C_COMPILER="cl.exe" -DCMAKE_CXX_COMPILER="cl.exe" -B. ..

echo "## BUILD START:" %time%
cmake --build . --config Release --parallel 8

echo "## BUILD END:" %time%
ctest -C Release --parallel 8 --output-on-failure
```

</details>
