+++
title = "Spheroid"
+++

### Spheroid

A full spheroid, generated by rotating an ellipse around the vertical axis.

<img src="../3d/Spheroid.png" width="30%" >
<img src="/img/draw/ff/2d/Spheroid_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Spheroid_xz.svg" width="30%">

#### Constructor

```python
Spheroid(R, H)
```

Parameters:
- R, radius
- H, height

#### Usage

As for any other [Form factor](/py/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Spheroid" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor is computed as

$$ F(\mathbf{q})=4\pi R^2h \exp(iq_zh) \dfrac{\sin(s) - s \cos(s)\}{s^3} , $$
with the notation
$$ h:=H/2, \quad s := \sqrt{(Rq_x)^2 + (Rq_y)^2+ (hq_z)^2}. $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{2\pi}{3} R^2H. $$

#### Related shapes

More special:
- [Sphere](/py/sample/particle/ff/hard/fullsphere), if $H=2R.$

More general:
- [TruncatedSpheroid](/py/sample/particle/ff/hard/truncatedspheroid), if truncated from the top and/or the bottom.

#### Example

Scattering by uncorrelated, oriented spheroids for horizontal incidence. Rotation around $y$ axis:

<img src="/img/auto/ff/Spheroid.png">

Generated by {{% ref-ex "ff/Spheroid.py" %}}.

#### History

Replicates the "Full spheroid" in IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.36; [Renaud 2009](/lit/renaud2009), Eq. 227], except for wrong
factors of 2 in their volume formula and form factor implementation, and "Spheroid" in FitGISAXS [[Babonneau 2013](/lit/babonneau2013)]. Up to BornAgain
1.16, our form factor computation followed IsGISAXS in using numeric integration in
the $z$ coordinate.
In BornAgain, named "FullSpheroid" up to version 1.19.