/*************************************************
* GMP Wrapper Source File                        *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#include <botan/gmp_wrap.h>

#define GNU_MP_VERSION_CODE_FOR(a,b,c) ((a << 16) | (b << 8) | (c))

#define GNU_MP_VERSION_CODE \
   GNU_MP_VERSION_CODE_FOR(__GNU_MP_VERSION, __GNU_MP_VERSION_MINOR, \
                           __GNU_MP_VERSION_PATCHLEVEL)

#if GNU_MP_VERSION_CODE < GNU_MP_VERSION_CODE_FOR(4,1,0)
  #error Your GNU MP install is too old, upgrade to 4.1 or later
#endif

namespace Botan {

/*************************************************
* GNU_MPZ Constructor                            *
*************************************************/
GNU_MPZ::GNU_MPZ(const BigInt& in)
   {
   mpz_init(value);
   if(in != 0)
      mpz_import(value, in.sig_words(), -1, sizeof(word), 0, 0, in.data());
   }

/*************************************************
* GNU_MPZ Constructor                            *
*************************************************/
GNU_MPZ::GNU_MPZ(const byte in[], u32bit length)
   {
   mpz_init(value);
   mpz_import(value, length, 1, 1, 0, 0, in);
   }

/*************************************************
* GNU_MPZ Copy Constructor                       *
*************************************************/
GNU_MPZ::GNU_MPZ(const GNU_MPZ& other)
   {
   mpz_init_set(value, other.value);
   }

/*************************************************
* GNU_MPZ Destructor                             *
*************************************************/
GNU_MPZ::~GNU_MPZ()
   {
   mpz_clear(value);
   }

/*************************************************
* GNU_MPZ Assignment Operator                    *
*************************************************/
GNU_MPZ& GNU_MPZ::operator=(const GNU_MPZ& other)
   {
   mpz_set(value, other.value);
   return (*this);
   }

/*************************************************
* Export the mpz_t as a bytestring               *
*************************************************/
void GNU_MPZ::encode(byte out[], u32bit length) const
   {
   size_t dummy = 0;
   mpz_export(out + (length - bytes()), &dummy, 1, 1, 0, 0, value);
   }

/*************************************************
* Return the number of significant bytes         *
*************************************************/
u32bit GNU_MPZ::bytes() const
   {
   return ((mpz_sizeinbase(value, 2) + 7) / 8);
   }

/*************************************************
* GMP to BigInt Conversions                      *
*************************************************/
BigInt GNU_MPZ::to_bigint() const
   {
   BigInt out(BigInt::Positive, (bytes() + sizeof(word) - 1) / sizeof(word));
   size_t dummy = 0;
   mpz_export(out.get_reg(), &dummy, -1, sizeof(word), 0, 0, value);
   return out;
   }

}
