/*************************************************
* Program List for Unix_EntropySource            *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#include <botan/unix_cmd.h>

namespace Botan {

/*************************************************
* Default Commands for Entropy Gathering         *
*************************************************/
const Unix_Program DEFAULT_SOURCES[] = {
   Unix_Program("vmstat",                    1),
   Unix_Program("vmstat -s",                 1),
   Unix_Program("pfstat",                    1),
   Unix_Program("netstat -in",               1),

   Unix_Program("iostat",                    2),
   Unix_Program("mpstat",                    2),
   Unix_Program("nfsstat",                   2),
   Unix_Program("portstat",                  2),
   Unix_Program("arp -a -n",                 2),
   Unix_Program("ifconfig -a",               2),
   Unix_Program("pstat -T",                  2),
   Unix_Program("pstat -s",                  2),
   Unix_Program("uname -a",                  2),
   Unix_Program("uptime",                    2),
   Unix_Program("ipcs -a",                   2),
   Unix_Program("procinfo -a",               2),

   Unix_Program("sysinfo",                   3),
   Unix_Program("listarea",                  3),
   Unix_Program("listdev",                   3),

   Unix_Program("who",                       3),
   Unix_Program("finger",                    3),
   Unix_Program("netstat -s",                3),
   Unix_Program("netstat -an",               3),
   Unix_Program("ps -A",                     3),
   Unix_Program("mailstats",                 3),
   Unix_Program("rpcinfo -p localhost",      3),

   Unix_Program("dmesg",                     4),
   Unix_Program("ls -alni /tmp",             4),
   Unix_Program("ls -alni /proc",            4),
   Unix_Program("df -l",                     4),
   Unix_Program("last -5",                   4),
   Unix_Program("pstat -f",                  4),

   Unix_Program("ps aux",                    5),
   Unix_Program("ps -elf",                   5),

   Unix_Program("sar -A",                    6),
   Unix_Program("lsof",                      6),

   Unix_Program("",                          0)
};

}
