/*************************************************
* S-Box Tables for GOST                          *
* (C) 1999-2006 The Botan Project                *
*************************************************/

#include <botan/gost.h>

namespace Botan {

const u32bit GOST::SBOX1[256] = {
   0x00000270, 0x00000258, 0x00000220, 0x00000260, 0x00000230, 0x00000268,
   0x00000278, 0x00000250, 0x00000210, 0x00000218, 0x00000240, 0x00000208,
   0x00000200, 0x00000238, 0x00000228, 0x00000248, 0x00000570, 0x00000558,
   0x00000520, 0x00000560, 0x00000530, 0x00000568, 0x00000578, 0x00000550,
   0x00000510, 0x00000518, 0x00000540, 0x00000508, 0x00000500, 0x00000538,
   0x00000528, 0x00000548, 0x000004F0, 0x000004D8, 0x000004A0, 0x000004E0,
   0x000004B0, 0x000004E8, 0x000004F8, 0x000004D0, 0x00000490, 0x00000498,
   0x000004C0, 0x00000488, 0x00000480, 0x000004B8, 0x000004A8, 0x000004C8,
   0x00000170, 0x00000158, 0x00000120, 0x00000160, 0x00000130, 0x00000168,
   0x00000178, 0x00000150, 0x00000110, 0x00000118, 0x00000140, 0x00000108,
   0x00000100, 0x00000138, 0x00000128, 0x00000148, 0x000006F0, 0x000006D8,
   0x000006A0, 0x000006E0, 0x000006B0, 0x000006E8, 0x000006F8, 0x000006D0,
   0x00000690, 0x00000698, 0x000006C0, 0x00000688, 0x00000680, 0x000006B8,
   0x000006A8, 0x000006C8, 0x00000470, 0x00000458, 0x00000420, 0x00000460,
   0x00000430, 0x00000468, 0x00000478, 0x00000450, 0x00000410, 0x00000418,
   0x00000440, 0x00000408, 0x00000400, 0x00000438, 0x00000428, 0x00000448,
   0x00000070, 0x00000058, 0x00000020, 0x00000060, 0x00000030, 0x00000068,
   0x00000078, 0x00000050, 0x00000010, 0x00000018, 0x00000040, 0x00000008,
   0x00000000, 0x00000038, 0x00000028, 0x00000048, 0x00000770, 0x00000758,
   0x00000720, 0x00000760, 0x00000730, 0x00000768, 0x00000778, 0x00000750,
   0x00000710, 0x00000718, 0x00000740, 0x00000708, 0x00000700, 0x00000738,
   0x00000728, 0x00000748, 0x00000370, 0x00000358, 0x00000320, 0x00000360,
   0x00000330, 0x00000368, 0x00000378, 0x00000350, 0x00000310, 0x00000318,
   0x00000340, 0x00000308, 0x00000300, 0x00000338, 0x00000328, 0x00000348,
   0x000005F0, 0x000005D8, 0x000005A0, 0x000005E0, 0x000005B0, 0x000005E8,
   0x000005F8, 0x000005D0, 0x00000590, 0x00000598, 0x000005C0, 0x00000588,
   0x00000580, 0x000005B8, 0x000005A8, 0x000005C8, 0x000000F0, 0x000000D8,
   0x000000A0, 0x000000E0, 0x000000B0, 0x000000E8, 0x000000F8, 0x000000D0,
   0x00000090, 0x00000098, 0x000000C0, 0x00000088, 0x00000080, 0x000000B8,
   0x000000A8, 0x000000C8, 0x00000670, 0x00000658, 0x00000620, 0x00000660,
   0x00000630, 0x00000668, 0x00000678, 0x00000650, 0x00000610, 0x00000618,
   0x00000640, 0x00000608, 0x00000600, 0x00000638, 0x00000628, 0x00000648,
   0x000003F0, 0x000003D8, 0x000003A0, 0x000003E0, 0x000003B0, 0x000003E8,
   0x000003F8, 0x000003D0, 0x00000390, 0x00000398, 0x000003C0, 0x00000388,
   0x00000380, 0x000003B8, 0x000003A8, 0x000003C8, 0x000007F0, 0x000007D8,
   0x000007A0, 0x000007E0, 0x000007B0, 0x000007E8, 0x000007F8, 0x000007D0,
   0x00000790, 0x00000798, 0x000007C0, 0x00000788, 0x00000780, 0x000007B8,
   0x000007A8, 0x000007C8, 0x000002F0, 0x000002D8, 0x000002A0, 0x000002E0,
   0x000002B0, 0x000002E8, 0x000002F8, 0x000002D0, 0x00000290, 0x00000298,
   0x000002C0, 0x00000288, 0x00000280, 0x000002B8, 0x000002A8, 0x000002C8,
   0x000001F0, 0x000001D8, 0x000001A0, 0x000001E0, 0x000001B0, 0x000001E8,
   0x000001F8, 0x000001D0, 0x00000190, 0x00000198, 0x000001C0, 0x00000188,
   0x00000180, 0x000001B8, 0x000001A8, 0x000001C8 };

const u32bit GOST::SBOX2[256] = {
   0xB8000002, 0xE8000002, 0xD0000002, 0x88000002, 0x80000002, 0xC0000002,
   0xC8000002, 0xF8000002, 0xF0000002, 0xA0000002, 0xB0000002, 0xE0000002,
   0xD8000002, 0x90000002, 0xA8000002, 0x98000002, 0x38000004, 0x68000004,
   0x50000004, 0x08000004, 0x00000004, 0x40000004, 0x48000004, 0x78000004,
   0x70000004, 0x20000004, 0x30000004, 0x60000004, 0x58000004, 0x10000004,
   0x28000004, 0x18000004, 0xB8000000, 0xE8000000, 0xD0000000, 0x88000000,
   0x80000000, 0xC0000000, 0xC8000000, 0xF8000000, 0xF0000000, 0xA0000000,
   0xB0000000, 0xE0000000, 0xD8000000, 0x90000000, 0xA8000000, 0x98000000,
   0xB8000006, 0xE8000006, 0xD0000006, 0x88000006, 0x80000006, 0xC0000006,
   0xC8000006, 0xF8000006, 0xF0000006, 0xA0000006, 0xB0000006, 0xE0000006,
   0xD8000006, 0x90000006, 0xA8000006, 0x98000006, 0x38000005, 0x68000005,
   0x50000005, 0x08000005, 0x00000005, 0x40000005, 0x48000005, 0x78000005,
   0x70000005, 0x20000005, 0x30000005, 0x60000005, 0x58000005, 0x10000005,
   0x28000005, 0x18000005, 0xB8000001, 0xE8000001, 0xD0000001, 0x88000001,
   0x80000001, 0xC0000001, 0xC8000001, 0xF8000001, 0xF0000001, 0xA0000001,
   0xB0000001, 0xE0000001, 0xD8000001, 0x90000001, 0xA8000001, 0x98000001,
   0x38000002, 0x68000002, 0x50000002, 0x08000002, 0x00000002, 0x40000002,
   0x48000002, 0x78000002, 0x70000002, 0x20000002, 0x30000002, 0x60000002,
   0x58000002, 0x10000002, 0x28000002, 0x18000002, 0x38000001, 0x68000001,
   0x50000001, 0x08000001, 0x00000001, 0x40000001, 0x48000001, 0x78000001,
   0x70000001, 0x20000001, 0x30000001, 0x60000001, 0x58000001, 0x10000001,
   0x28000001, 0x18000001, 0x38000007, 0x68000007, 0x50000007, 0x08000007,
   0x00000007, 0x40000007, 0x48000007, 0x78000007, 0x70000007, 0x20000007,
   0x30000007, 0x60000007, 0x58000007, 0x10000007, 0x28000007, 0x18000007,
   0xB8000007, 0xE8000007, 0xD0000007, 0x88000007, 0x80000007, 0xC0000007,
   0xC8000007, 0xF8000007, 0xF0000007, 0xA0000007, 0xB0000007, 0xE0000007,
   0xD8000007, 0x90000007, 0xA8000007, 0x98000007, 0x38000006, 0x68000006,
   0x50000006, 0x08000006, 0x00000006, 0x40000006, 0x48000006, 0x78000006,
   0x70000006, 0x20000006, 0x30000006, 0x60000006, 0x58000006, 0x10000006,
   0x28000006, 0x18000006, 0xB8000003, 0xE8000003, 0xD0000003, 0x88000003,
   0x80000003, 0xC0000003, 0xC8000003, 0xF8000003, 0xF0000003, 0xA0000003,
   0xB0000003, 0xE0000003, 0xD8000003, 0x90000003, 0xA8000003, 0x98000003,
   0x38000003, 0x68000003, 0x50000003, 0x08000003, 0x00000003, 0x40000003,
   0x48000003, 0x78000003, 0x70000003, 0x20000003, 0x30000003, 0x60000003,
   0x58000003, 0x10000003, 0x28000003, 0x18000003, 0x38000000, 0x68000000,
   0x50000000, 0x08000000, 0x00000000, 0x40000000, 0x48000000, 0x78000000,
   0x70000000, 0x20000000, 0x30000000, 0x60000000, 0x58000000, 0x10000000,
   0x28000000, 0x18000000, 0xB8000004, 0xE8000004, 0xD0000004, 0x88000004,
   0x80000004, 0xC0000004, 0xC8000004, 0xF8000004, 0xF0000004, 0xA0000004,
   0xB0000004, 0xE0000004, 0xD8000004, 0x90000004, 0xA8000004, 0x98000004,
   0xB8000005, 0xE8000005, 0xD0000005, 0x88000005, 0x80000005, 0xC0000005,
   0xC8000005, 0xF8000005, 0xF0000005, 0xA0000005, 0xB0000005, 0xE0000005,
   0xD8000005, 0x90000005, 0xA8000005, 0x98000005 };

const u32bit GOST::SBOX3[256] = {
   0x03200000, 0x03580000, 0x03500000, 0x03000000, 0x03380000, 0x03100000,
   0x03080000, 0x03680000, 0x03180000, 0x03300000, 0x03400000, 0x03280000,
   0x03480000, 0x03600000, 0x03780000, 0x03700000, 0x06200000, 0x06580000,
   0x06500000, 0x06000000, 0x06380000, 0x06100000, 0x06080000, 0x06680000,
   0x06180000, 0x06300000, 0x06400000, 0x06280000, 0x06480000, 0x06600000,
   0x06780000, 0x06700000, 0x03A00000, 0x03D80000, 0x03D00000, 0x03800000,
   0x03B80000, 0x03900000, 0x03880000, 0x03E80000, 0x03980000, 0x03B00000,
   0x03C00000, 0x03A80000, 0x03C80000, 0x03E00000, 0x03F80000, 0x03F00000,
   0x00A00000, 0x00D80000, 0x00D00000, 0x00800000, 0x00B80000, 0x00900000,
   0x00880000, 0x00E80000, 0x00980000, 0x00B00000, 0x00C00000, 0x00A80000,
   0x00C80000, 0x00E00000, 0x00F80000, 0x00F00000, 0x02A00000, 0x02D80000,
   0x02D00000, 0x02800000, 0x02B80000, 0x02900000, 0x02880000, 0x02E80000,
   0x02980000, 0x02B00000, 0x02C00000, 0x02A80000, 0x02C80000, 0x02E00000,
   0x02F80000, 0x02F00000, 0x07A00000, 0x07D80000, 0x07D00000, 0x07800000,
   0x07B80000, 0x07900000, 0x07880000, 0x07E80000, 0x07980000, 0x07B00000,
   0x07C00000, 0x07A80000, 0x07C80000, 0x07E00000, 0x07F80000, 0x07F00000,
   0x06A00000, 0x06D80000, 0x06D00000, 0x06800000, 0x06B80000, 0x06900000,
   0x06880000, 0x06E80000, 0x06980000, 0x06B00000, 0x06C00000, 0x06A80000,
   0x06C80000, 0x06E00000, 0x06F80000, 0x06F00000, 0x04200000, 0x04580000,
   0x04500000, 0x04000000, 0x04380000, 0x04100000, 0x04080000, 0x04680000,
   0x04180000, 0x04300000, 0x04400000, 0x04280000, 0x04480000, 0x04600000,
   0x04780000, 0x04700000, 0x02200000, 0x02580000, 0x02500000, 0x02000000,
   0x02380000, 0x02100000, 0x02080000, 0x02680000, 0x02180000, 0x02300000,
   0x02400000, 0x02280000, 0x02480000, 0x02600000, 0x02780000, 0x02700000,
   0x05200000, 0x05580000, 0x05500000, 0x05000000, 0x05380000, 0x05100000,
   0x05080000, 0x05680000, 0x05180000, 0x05300000, 0x05400000, 0x05280000,
   0x05480000, 0x05600000, 0x05780000, 0x05700000, 0x04A00000, 0x04D80000,
   0x04D00000, 0x04800000, 0x04B80000, 0x04900000, 0x04880000, 0x04E80000,
   0x04980000, 0x04B00000, 0x04C00000, 0x04A80000, 0x04C80000, 0x04E00000,
   0x04F80000, 0x04F00000, 0x07200000, 0x07580000, 0x07500000, 0x07000000,
   0x07380000, 0x07100000, 0x07080000, 0x07680000, 0x07180000, 0x07300000,
   0x07400000, 0x07280000, 0x07480000, 0x07600000, 0x07780000, 0x07700000,
   0x00200000, 0x00580000, 0x00500000, 0x00000000, 0x00380000, 0x00100000,
   0x00080000, 0x00680000, 0x00180000, 0x00300000, 0x00400000, 0x00280000,
   0x00480000, 0x00600000, 0x00780000, 0x00700000, 0x01A00000, 0x01D80000,
   0x01D00000, 0x01800000, 0x01B80000, 0x01900000, 0x01880000, 0x01E80000,
   0x01980000, 0x01B00000, 0x01C00000, 0x01A80000, 0x01C80000, 0x01E00000,
   0x01F80000, 0x01F00000, 0x05A00000, 0x05D80000, 0x05D00000, 0x05800000,
   0x05B80000, 0x05900000, 0x05880000, 0x05E80000, 0x05980000, 0x05B00000,
   0x05C00000, 0x05A80000, 0x05C80000, 0x05E00000, 0x05F80000, 0x05F00000,
   0x01200000, 0x01580000, 0x01500000, 0x01000000, 0x01380000, 0x01100000,
   0x01080000, 0x01680000, 0x01180000, 0x01300000, 0x01400000, 0x01280000,
   0x01480000, 0x01600000, 0x01780000, 0x01700000 };

const u32bit GOST::SBOX4[256] = {
   0x00068800, 0x0006F800, 0x0006E800, 0x00068000, 0x0006A800, 0x0006B800,
   0x0006D000, 0x0006A000, 0x0006C800, 0x00069000, 0x00069800, 0x0006F000,
   0x0006B000, 0x0006D800, 0x0006C000, 0x0006E000, 0x00058800, 0x0005F800,
   0x0005E800, 0x00058000, 0x0005A800, 0x0005B800, 0x0005D000, 0x0005A000,
   0x0005C800, 0x00059000, 0x00059800, 0x0005F000, 0x0005B000, 0x0005D800,
   0x0005C000, 0x0005E000, 0x00020800, 0x00027800, 0x00026800, 0x00020000,
   0x00022800, 0x00023800, 0x00025000, 0x00022000, 0x00024800, 0x00021000,
   0x00021800, 0x00027000, 0x00023000, 0x00025800, 0x00024000, 0x00026000,
   0x00008800, 0x0000F800, 0x0000E800, 0x00008000, 0x0000A800, 0x0000B800,
   0x0000D000, 0x0000A000, 0x0000C800, 0x00009000, 0x00009800, 0x0000F000,
   0x0000B000, 0x0000D800, 0x0000C000, 0x0000E000, 0x00018800, 0x0001F800,
   0x0001E800, 0x00018000, 0x0001A800, 0x0001B800, 0x0001D000, 0x0001A000,
   0x0001C800, 0x00019000, 0x00019800, 0x0001F000, 0x0001B000, 0x0001D800,
   0x0001C000, 0x0001E000, 0x00078800, 0x0007F800, 0x0007E800, 0x00078000,
   0x0007A800, 0x0007B800, 0x0007D000, 0x0007A000, 0x0007C800, 0x00079000,
   0x00079800, 0x0007F000, 0x0007B000, 0x0007D800, 0x0007C000, 0x0007E000,
   0x00028800, 0x0002F800, 0x0002E800, 0x00028000, 0x0002A800, 0x0002B800,
   0x0002D000, 0x0002A000, 0x0002C800, 0x00029000, 0x00029800, 0x0002F000,
   0x0002B000, 0x0002D800, 0x0002C000, 0x0002E000, 0x00048800, 0x0004F800,
   0x0004E800, 0x00048000, 0x0004A800, 0x0004B800, 0x0004D000, 0x0004A000,
   0x0004C800, 0x00049000, 0x00049800, 0x0004F000, 0x0004B000, 0x0004D800,
   0x0004C000, 0x0004E000, 0x00000800, 0x00007800, 0x00006800, 0x00000000,
   0x00002800, 0x00003800, 0x00005000, 0x00002000, 0x00004800, 0x00001000,
   0x00001800, 0x00007000, 0x00003000, 0x00005800, 0x00004000, 0x00006000,
   0x00050800, 0x00057800, 0x00056800, 0x00050000, 0x00052800, 0x00053800,
   0x00055000, 0x00052000, 0x00054800, 0x00051000, 0x00051800, 0x00057000,
   0x00053000, 0x00055800, 0x00054000, 0x00056000, 0x00070800, 0x00077800,
   0x00076800, 0x00070000, 0x00072800, 0x00073800, 0x00075000, 0x00072000,
   0x00074800, 0x00071000, 0x00071800, 0x00077000, 0x00073000, 0x00075800,
   0x00074000, 0x00076000, 0x00038800, 0x0003F800, 0x0003E800, 0x00038000,
   0x0003A800, 0x0003B800, 0x0003D000, 0x0003A000, 0x0003C800, 0x00039000,
   0x00039800, 0x0003F000, 0x0003B000, 0x0003D800, 0x0003C000, 0x0003E000,
   0x00030800, 0x00037800, 0x00036800, 0x00030000, 0x00032800, 0x00033800,
   0x00035000, 0x00032000, 0x00034800, 0x00031000, 0x00031800, 0x00037000,
   0x00033000, 0x00035800, 0x00034000, 0x00036000, 0x00040800, 0x00047800,
   0x00046800, 0x00040000, 0x00042800, 0x00043800, 0x00045000, 0x00042000,
   0x00044800, 0x00041000, 0x00041800, 0x00047000, 0x00043000, 0x00045800,
   0x00044000, 0x00046000, 0x00010800, 0x00017800, 0x00016800, 0x00010000,
   0x00012800, 0x00013800, 0x00015000, 0x00012000, 0x00014800, 0x00011000,
   0x00011800, 0x00017000, 0x00013000, 0x00015800, 0x00014000, 0x00016000,
   0x00060800, 0x00067800, 0x00066800, 0x00060000, 0x00062800, 0x00063800,
   0x00065000, 0x00062000, 0x00064800, 0x00061000, 0x00061800, 0x00067000,
   0x00063000, 0x00065800, 0x00064000, 0x00066000 };

}
