// *************************************************************************
//
// Copyright (C) 2004-2006 Bruno PAGES  All rights reserved.
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifndef UMLBASEPACKAGE_H
#define UMLBASEPACKAGE_H

/* !!!!!!!!!! Do not modify this file !!!!!!!!!! */

#include "UmlItem.h"

class UmlPackage;
class UmlDiagram;

class UmlBasePackage : public UmlItem {
  private:
    UmlDiagram * _assoc_diagram;
#ifdef WITHCPP
    QCString _cpp_src_dir;
    QCString _cpp_h_dir;
    QCString _cpp_namespace;
#endif
#ifdef WITHJAVA
    QCString _java_dir;
    QCString _java_package;
#endif
#ifdef WITHIDL
    QCString _idl_dir;
    QCString _idl_module;
#endif
  
    virtual void read_uml_();
#ifdef WITHCPP
    virtual void read_cpp_();
#endif
#ifdef WITHJAVA
    virtual void read_java_();
#endif
#ifdef WITHIDL
    virtual void read_idl_();
#endif
    
  public:
    // the constructor, do not call it yourself !!!!!!!!!!
    UmlBasePackage(void * id, const QCString & n);
  
    // returns a new package named 'name' created under 'parent', or
    // the null pointer in case it cannot be created (the name is
    // already used or invalid, 'parent' cannot contain it etc ...)
    static UmlPackage * create(UmlPackage * parent, const char * name);
    
    // returns the kind of the item
    virtual anItemKind kind();
    
    // returns the optional associated diagram
    UmlDiagram * associatedDiagram();
    
    // sets the associated diagram, arg may be 0
    bool set_AssociatedDiagram(UmlDiagram *);
    
#ifdef WITHCPP
    // returns the path where the C++ source files are generated by the
    // c++ generator.
    const QCString & cppSrcDir();
    
    // to set the path where the C++ source files are generated by the
    // C++ generator, may be relative even the 'root' path is not
    // (already) an absolute path. Returns FALSE on error
    bool set_CppSrcDir(const QCString &);
    
    // returns the path where the C++ header files are generated by the
    // C++ generator.
    const QCString & cppHDir();
    
    // to set the path where the C++ header files are generated by the
    // C++ generator, may be relative even the 'root' path is not
    // (already) an absolute path. Returns FALSE on error
    bool set_CppHDir(const QCString &);
    
    // returns the namespace name associed to the package
    const QCString & cppNamespace();
    
    // to set the namespace name associed to the package.
    // Returns FALSE on error
    bool set_CppNamespace(const QCString &);
    
    // returns the sub package having the c++ namespace 'n'
    // (including 'this' itself), else 0
    UmlPackage * findNamespace(const QCString & n) const;
#endif
    
#ifdef WITHJAVA
    // returns the path where the JAVA files are generated by the
    // JAVA generator.
    const QCString & javaDir();
    
    // to set the path where the JAVA files are generated by the
    // JAVA generator, may be relative even the 'root' path is not
    // (already) an absolute path. Returns FALSE on error
    bool set_JavaDir(const QCString &);
    
    // returns the java package name associed to the package
    const QCString & javaPackage();
    
    // to set the java package name associed to the package.
    // Returns FALSE on error
    bool set_JavaPackage(const QCString &);
    
    // returns the sub package having the java package 'n'
    // (including 'this' itself), else 0
    UmlPackage * findPackage(const QCString & n) const;
#endif
    
#ifdef WITHIDL
    // returns the path where the IDL files are generated by the
    // IDL generator.
    const QCString & idlDir();
    
    // to set the path where the IDL files are generated by the
    // IDL generator, may be relative even the 'root' path is not
    // (already) an absolute path. Returns FALSE on error
    bool set_IdlDir(const QCString &);
    
    // returns the module name associed to the package
    const QCString & idlModule();
    
    // to set the module name associed to the package.
    // Returns FALSE on error
    bool set_IdlModule(const QCString &);
    
    // returns the sub package having the IDL module 'n'
    // (including 'this' itself), else 0
    UmlPackage * findModule(const QCString & n) const;
#endif
    
    // Returns the project
    static UmlPackage * getProject();
    
    // to unload the object to free memory, it will be reloaded automatically
    // if needed. Recursively done for the sub items if 'rec' is TRUE. 
    // if 'del' is true the sub items are deleted, you will have to call
    // Children() to re-access to them
    virtual void unload(bool rec = FALSE, bool del = FALSE);
};

#endif
