#ifndef _DUMP_H_
#define _DUMP_H_

#include <element.h>

#include <addon.h>
#include <table.h>
#include <part.h>
#include <track.h>

/**
 * The Dump class shall serve as a very simple addon: It iterates through the musical context (song, track, part or selection)
 * and dumps the parameters to the standard output, (call Brahms from the shell to demonstrate).
 * Addons are located inside the brahms/addons/ directory. Each addon is kept in a separate directory.
 *
 * To write your own addon make a copy of brahms/addons/Dump and modify it. You will see, it's very simple.
 * In order to use an addon called MyAddon, call Brahms with the -a option:
 *
 * Brahms -a myAddon
 *
 * (the parameter starts lower case, while the class name starts upper case!)
 * Now, take a look at the implementation dump.h and dump.cpp
 */
class Dump : public Addon
{
 private:

 public:
  /** The constructor is given a parameter specifying the target of the operation
   * implement this typically for a Song, Track, Part and NULL, where NULL indicates that
   * the globally defined table * selectioN is used as a target
   */
  Dump(Element*);
  ~Dump();

  /** implement this method to operate on selections */
  virtual void selection(Table*);

  /** implement this method to operate on parts */
  virtual void part(Part*);

  /** implement this method to operate on tracks */
  virtual void track(Track*);

  /** implement this method to operate on songs */
  virtual void song(Song*);
  
  /** implement these methods, if your operation is to be undone */
  void undo();
  void redo();



};

#endif
