#ifndef _MASTEREVENT_H_
#define _MASTEREVENT_H_

#include "event.h"

/**
 * This event contains information on tempo and meter. It is used for tempo and meter changes within a part.
 * If the tempo is set to a value other than zero, the event is treated as a tempo change, otherwise it is
 * treated as a meter change.
 **/
class MasterEvent : public Event
{
 private:
  int _tempo;
  int _meter0;
  int _meter1;

 public:
  /**
   * Default Constructor
   **/
  MasterEvent();

  /**
   * Copy Constructor
   **/
  MasterEvent(const MasterEvent&);

  /**
   * Constructor defining a new tempo at a position pos
   **/
  MasterEvent(Position pos, int tempo);

  /**
   * Constructor defining a new meter (met0/met1) at a position pos
   **/
  MasterEvent(Position pos, int met0, int met1);

  /**
   * Constructor defining both, a new tempo and a new meter
   **/
  MasterEvent(Position pos, int tempo, int met0, int met1);

  /**
   * Returns the tempo.
   **/
  int tempo() const { return _tempo; }

  /**
   * Returns the numerator of the meter
   **/
  int meter0() const { return _meter0; }

  /**
   * Returns the denominator of the meter
   **/
  int meter1() const { return _meter1; }

  /**
   * Sets the tempo value to val
   **/
  void setTempo(int cal);

  /**
   * Sets the value of the numerator to met0
   **/
  void setMeter0(int met0);

  /**
   * Sets the value of the denominator to met1
   **/
  void setMeter1(int met1);

  /**
   * Implementation of the print method
   **/
  virtual ostream & print(int,ostream&) const;

  /**
   * Implementation of the flush method
   **/
  virtual void flush(const char*) const;

  /**
   * Implementation of the copy method
   **/
  virtual Element * copy() const;

  /**
   * Implementation of the load method
   **/
  static Element * load(char*,ifstream*&,Element*);
};


#endif
