#ifndef _NEWSELECTION_CPP_
#define _NEWSELECTION_CPP_

#include <iostream.h>

#include "newSelection.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;

NewSelection::NewSelection(Reference * ref) : _ref(ref), _oldTable(0) {
  _type = NEWSELECTION;
  _description = "new selection";
  _to_be_undone = false;
  _oldTable = selectioN;
  selectioN = new Table();
  selectioN->add(_ref); // no loop: the references following _ref will still be following _ref, after this operation
  _delete = _oldTable;
}


NewSelection::NewSelection(const NewSelection& el) : Operation(el) {
  _type = NEWSELECTION;
  _ref = el._ref;
  _oldTable = el._oldTable;
  _delete = el._delete;
}

NewSelection::~NewSelection() {
  if (_oldTable!=0) {
    ((Compound*)_oldTable)->scratch();
    delete _oldTable;
  }
}

void NewSelection::undo() {
  Table * tmp = selectioN;
  selectioN = _oldTable;
  _oldTable = tmp;
  _delete = _oldTable;
}

void NewSelection::redo() {
  Table * tmp = _oldTable;
  _oldTable = selectioN;
  selectioN = tmp;
  _delete = _oldTable;
}



// ---------------
// virtuals:
//

ostream & NewSelection::print(int dep, ostream & s) const {
  s << spc(dep) << "<NEWSELECTION ref=\"" << _ref->ctype() << "\" />" << endl;
  return s;
}

void NewSelection::flush(const char * c) const {
  cout << c << "NEWSELECTION" << endl;
}

Element * NewSelection::copy() const {
  return new NewSelection(*this);
}




#endif
