#ifndef _REMOVEFROMSELECTION_H_
#define _REMOVEFROMSELECTION_H_

#include "operation.h"

class Element;
class Compound;
class Reference;

/** This operation removes an element to a compound. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class RemoveFromSelection : public Operation
{
 private:
  Reference * _ref;

 public:
  RemoveFromSelection(Reference * ref);
  RemoveFromSelection(const RemoveFromSelection&);
  ~RemoveFromSelection();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
