#ifndef _SPLITNOTE_H_
#define _SPLITNOTE_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Note;
class Part;
class Table;

/** This operation splits a note into two
 */
class SplitNote : public Operation
{
 private:
  Note *  _note;
  Part *  _part;
  Note *  _next;
  Note * _delete;
  int    _grid;
 public:
  SplitNote(Note * nt, Part * pt, int grid);
  SplitNote(const SplitNote&);
  ~SplitNote();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
