#ifndef _SYMBOL_CPP_
#define _SYMBOL_CPP_

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "symbol.h"
#include "note.h"
#include "loader.h"
#include "table.h"
#include "str.h"

Symbol::Symbol() : _text(0), _displacement(0), _symbol(-1) {
  _type = SYMBOL;
}

Symbol::Symbol(Position p, int symbol) : Event(p,0), _text(0), _displacement(0), _symbol(symbol) {
  _type = SYMBOL;
}

Symbol::Symbol(Position p, int symbol, int displ) : Event(p,0), _text(0), _displacement(displ), _symbol(symbol) {
  _type = SYMBOL;
}

Symbol::Symbol(Position p, int symbol, int displ, int parameter) : Event(p,parameter), _text(0), _displacement(displ), _symbol(symbol) {
  _type = SYMBOL;
}

Symbol::Symbol(Position p, char * text) : Event(p,0), _text(text), _displacement(0), _symbol(AS_TEXT) {
  _type = SYMBOL;
}

Symbol::Symbol(Position p, char * text, int displ) : Event(p,0), _text(text), _displacement(displ), _symbol(AS_TEXT) {
  _type = SYMBOL;
}

Symbol::Symbol(const Symbol& m) : Event(m) {
  _type = SYMBOL;
  _symbol = m._symbol;
  _displacement = m._displacement;
  _text = m._text;
}

void Symbol::setSymbol(int s) {
  _symbol = s;
}

void Symbol::setDisplacement(int d) {
  _displacement = d;
}

void Symbol::setText(char * t) {
  _text = strdup(t);
}

void Symbol::setParameter(int p) {
  setDuration(p);
}


ostream & Symbol::print(int dep, ostream & s) const {
  s << spc(dep) << "<SYMBOL pos=\"" << internalStart().ticks() << "\" displacement=\"" << _displacement << "\" symbol=\"" << _symbol << "\" ";
  if (_text!=0) s << "text=\"" << _text << "\" ";
  if (duration()!=0) s << "parameter=\"" << duration() << "\" ";
  s << "/>" << endl;
  return s;
}

void Symbol::flush(const char * c) const {
  cout << c << "SYMBOL" << endl;
}

Element * Symbol::copy() const {
  return new Symbol(*this);
}

Element * Symbol::load(char * aline, ifstream *& inPtr, Element * parent) {
  Symbol * symbol = new Symbol();
  Table * attr = Loader::getAttributes("SYMBOL",aline);
  if (attr!=0) {
    int pos = 0;
    int sym = 0;
    int dis = 0;
    int parm = 0;

    if (attr->getEntry("pos")) pos = atoi(((String*) attr->getEntry("pos"))->getValue());
    if (attr->getEntry("displacement")) dis = atoi(((String*) attr->getEntry("displacement"))->getValue());
    if (attr->getEntry("symbol")) sym = atoi(((String*) attr->getEntry("symbol"))->getValue());
    if (attr->getEntry("parameter")) parm = atoi(((String*) attr->getEntry("parameter"))->getValue());

    symbol->setInternalStart(pos);
    symbol->setDisplacement(dis);
    symbol->setSymbol(sym);
    symbol->setParameter(parm);

    attr->scratch();
    delete attr;
  }
  return symbol;
}





#endif
