#ifndef _KDEEVENTCONTENT_CPP_
#define _KDEEVENTCONTENT_CPP_

#include <stdio.h>
#include <iostream.h>

#include "kdeEventContent.h"
#include "kdeEventEditor.h"

#include <qpainter.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qpoint.h>
#include <qmessagebox.h>
#include <qdragobject.h>
#include <qmime.h>
#include <qstrlist.h>
#include <qstringlist.h>
#include <qapplication.h>
#include <qheader.h>

#include "part.h"
#include "song.h"
#include "event.h"
#include "note.h"
#include "position.h"




static const char* note_closed_xpm[]={
    "16 16 9 1",
    "g c #808080",
    "b c #c0c000",
    "e c #c0c0c0",
    "# c #000000",
    "c c #ffff00",
    ". c None",
    "a c #585858",
    "f c #a0a0a4",
    "d c #ffffff",
    "..###...........",
    ".#abc##.........",
    ".#daabc#####....",
    ".#ddeaabbccc#...",
    ".#dedeeabbbba...",
    ".#edeeeeaaaab#..",
    ".#deeeeeeefe#ba.",
    ".#eeeeeeefef#ba.",
    ".#eeeeeefeff#ba.",
    ".#eeeeefefff#ba.",
    ".##geefeffff#ba.",
    "...##gefffff#ba.",
    ".....##fffff#ba.",
    ".......##fff#b##",
    ".........##f#b##",
    "...........####."};

static const char* note_open_xpm[]={
    "16 16 11 1",
    "# c #000000",
    "g c #c0c0c0",
    "e c #303030",
    "a c #ffa858",
    "b c #808080",
    "d c #a0a0a4",
    "f c #585858",
    "c c #ffdca8",
    "h c #dcdcdc",
    "i c #ffffff",
    ". c None",
    "....###.........",
    "....#ab##.......",
    "....#acab####...",
    "###.#acccccca#..",
    "#ddefaaaccccca#.",
    "#bdddbaaaacccab#",
    ".eddddbbaaaacab#",
    ".#bddggdbbaaaab#",
    "..edgdggggbbaab#",
    "..#bgggghghdaab#",
    "...ebhggghicfab#",
    "....#edhhiiidab#",
    "......#egiiicfb#",
    "........#egiibb#",
    "..........#egib#",
    "............#ee#"};



static const char * symbol_xpm[]={
    "16 16 7 1",
    "# c #000000",
    "b c #ffffff",
    "e c #000000",
    "d c #404000",
    "c c #c0c000",
    "a c #ffffc0",
    ". c None",
    "................",
    ".........#......",
    "........#a##....",
    ".....#b#bbba##..",
    "....#babbbabbb#.",
    "...#babbababbba#",
    "..#baabbcbbbbba#",
    ".#abaabcbbbabba#",
    "#abaaacbcbbbbb#.",
    "#ccdccbcbbcbb#..",
    ".##ccbcbbcab#...",
    "..#aaaacaba#....",
    "...##aaaaa#.....",
    ".....##aa#......",
    ".......##.......",
    "................"};

QPixmap *noteClosed = 0;
QPixmap *noteOpen = 0;
QPixmap *symbol = 0;







// ***********************
// **                   **
// **     NoteItem      **
// **                   **
// ***********************





NoteItem::NoteItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7, QString a8 )
    : QListViewItem( parent, a1, a2, a3, a4, a5, a6, a7, a8), pix( 0 )
{
  val[0] = a1;
  val[1] = a2;
  val[2] = a3;
  val[3] = a4;
  val[4] = a5;
  val[5] = a6;
  val[6] = a7;
  val[7] = a8;
  p = 0;
  setPixmap(noteClosed);
}

void NoteItem::setPixmap( QPixmap *px )
{
    pix = px;
    setup();
    widthChanged( 0 );
    invalidateHeight();
    repaint();
}

const QPixmap *NoteItem::pixmap( int i ) const
{
    if ( i )
        return 0;
    return pix;
}

void NoteItem::setOpen( bool o )
{
    if ( o )
        setPixmap( noteOpen );
    else
        setPixmap( noteClosed );

    if ( o && !childCount() ) {
        QString s( fullName() );
	/* QDir thisDir( s );
        if ( !thisDir.isReadable() ) {
            readable = FALSE;
            setExpandable( FALSE );
            return;
      */
    }

    /*        listView()->setUpdatesEnabled( FALSE );
        const QFileInfoList * files = thisDir.entryInfoList();
        if ( files ) {
            QFileInfoListIterator it( *files );
            QFileInfo * fi;
            while( (fi=it.current()) != 0 ) {
                ++it;
                if ( fi->fileName() == "." || fi->fileName() == ".." )
                    ; // nothing
                else if ( fi->isSymLink() && !showDirsOnly ) {
                    FileItem *item = new FileItem( this, fi->fileName(),
                                                     "Symbolic Link" );
                    item->setPixmap( fileNormal );
                }
                else if ( fi->isDir() )
                    (void)new NoteItem( this, fi->fileName() );
                else if ( !showDirsOnly ) {
                    FileItem *item
                        = new FileItem( this, fi->fileName(),
                                             fi->isFile()?"File":"Special" );
                    item->setPixmap( fileNormal );
                }
            }
        }
        listView()->setUpdatesEnabled( TRUE );
	}*/
    QListViewItem::setOpen( o );
}

void NoteItem::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}

QString NoteItem::fullName()
{
    QString s;
    if ( p ) {
        s = p->fullName();
        s.append( "x" );
    } else {
        s = "moin";
    }
    return s;
}

QString NoteItem::text( int column ) const
{
  // cout << column << val[column] << endl;
  return val[column];
  /*
    if ( column == 0 )
        return "NoteItem";
    else
        return "Unreadable NoteItem";
  */
}




// ***********************
// **                   **
// **    SymbolItem     **
// **                   **
// ***********************


SymbolItem::SymbolItem( QListView * parent )
    : QListViewItem( parent ), pix( 0 )
{
  setPixmap(symbol);
}

SymbolItem::SymbolItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 )
    : QListViewItem( parent, a1, a2, a3, a4, a5, a6, a7), pix( 0 )
{
  val[0] = a1;
  val[1] = a2;
  val[2] = a3;
  val[3] = a4;
  val[4] = a5;
  val[5] = a6;
  val[6] = a7;
  setPixmap(symbol);
}

void SymbolItem::setPixmap( QPixmap *px )
{
    pix = px;
    setup();
    widthChanged( 0 );
    invalidateHeight();
    repaint();
}

const QPixmap *SymbolItem::pixmap( int i ) const
{
    if ( i )
        return 0;
    return pix;
}





// ***********************
// **                   **
// **   MidiEventItem   **
// **                   **
// ***********************



MidiEventItem::MidiEventItem( QListView * parent )
    : QListViewItem( parent ), pix( 0 )
{
  setPixmap(symbol);
}

MidiEventItem::MidiEventItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 )
    : QListViewItem( parent, a1, a2, a3, a4, a5, a6, a7), pix( 0 )
{
  val[0] = a1;
  val[1] = a2;
  val[2] = a3;
  val[3] = a4;
  val[4] = a5;
  val[5] = a6;
  val[6] = a7;
  setPixmap(symbol);
}

void MidiEventItem::setPixmap( QPixmap *px )
{
    pix = px;
    setup();
    widthChanged( 0 );
    invalidateHeight();
    repaint();
}

const QPixmap *MidiEventItem::pixmap( int i ) const
{
    if ( i )
        return 0;
    return pix;
}




// ***********************
// **                   **
// **  MasterEventItem  **
// **                   **
// ***********************


MasterEventItem::MasterEventItem( QListView * parent )
    : QListViewItem( parent ), pix( 0 )
{
  setPixmap(symbol);
}

MasterEventItem::MasterEventItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 )
    : QListViewItem( parent, a1, a2, a3, a4, a5, a6, a7), pix( 0 )
{
  val[0] = a1;
  val[1] = a2;
  val[2] = a3;
  val[3] = a4;
  val[4] = a5;
  val[5] = a6;
  val[6] = a7;
  setPixmap(symbol);
}

void MasterEventItem::setPixmap( QPixmap *px )
{
    pix = px;
    setup();
    widthChanged( 0 );
    invalidateHeight();
    repaint();
}

const QPixmap *MasterEventItem::pixmap( int i ) const
{
    if ( i )
        return 0;
    return pix;
}




// ***********************
// **                   **
// **   OrnamentItem    **
// **                   **
// ***********************


OrnamentItem::OrnamentItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 )
    : QListViewItem( parent, a1, a2, a3, a4, a5, a6, a7), pix( 0 )
{
  val[0] = a1;
  val[1] = a2;
  val[2] = a3;
  val[3] = a4;
  val[4] = a5;
  val[5] = a6;
  val[6] = a7;
  setPixmap(symbol);
}

OrnamentItem::OrnamentItem( QListView * parent )
    : QListViewItem( parent ), pix( 0 )
{
  setPixmap(symbol);
}

void OrnamentItem::setPixmap( QPixmap *px )
{
    pix = px;
    setup();
    widthChanged( 0 );
    invalidateHeight();
    repaint();
}

const QPixmap *OrnamentItem::pixmap( int i ) const
{
    if ( i )
        return 0;
    return pix;
}



// #################################################################################



extern Song * sonG;

const char * title[] = { "position", "event", "A (frq)", "B (vel)", "C (len)", "D (enh)", "E (chn)" };


KdeEventContent::KdeEventContent( KdeEventEditor * e, Part * pt, QWidget * parent ) : QListView(parent), _editor(e), _part(pt) {
  // _editor->setItemHeight(itemHeight());
  // setFont(QFont("courier"));
  autoopen_timer = new QTimer( this );
  noteClosed = new QPixmap( note_closed_xpm );
  noteOpen = new QPixmap( note_open_xpm );
  symbol = new QPixmap( symbol_xpm );

  connect( this, SIGNAL( doubleClicked( QListViewItem * ) ), this, SLOT( slotNoteSelected( QListViewItem * ) ) );
  connect( this, SIGNAL( returnPressed( QListViewItem * ) ), this, SLOT( slotNoteSelected( QListViewItem * ) ) );

  setAcceptDrops( TRUE );
  viewport()->setAcceptDrops( TRUE );

  connect( autoopen_timer, SIGNAL( timeout() ), this, SLOT( openNote() ) );

  connect( verticalScrollBar(), SIGNAL( valueChanged(int) ), SLOT( ok(int) ) );
}

void KdeEventContent::ok(int) {
  _editor->frame()->repaint();
}






void KdeEventContent::slotNoteSelected( QListViewItem *i )
{
  if (i!=0) {
    NoteItem *dir = (NoteItem*)i;
    emit noteSelected( dir->fullName() );
    _editor->frame()->repaint();
  }
}

void KdeEventContent::openNote()
{
    autoopen_timer->stop();
    if ( dropItem && !dropItem->isOpen() ) {
        dropItem->setOpen( TRUE );
        dropItem->repaint();
    }
    _editor->frame()->repaint();
}

static const int autoopenTime = 750;



void KdeEventContent::contentsDragEnterEvent( QDragEnterEvent *e )
{
    if ( !QUriDrag::canDecode(e) ) {
        e->ignore();
        return;
    }

    oldCurrent = currentItem();

    QListViewItem *i = itemAt( contentsToViewport(e->pos()) );
    if ( i ) {
        dropItem = i;
        autoopen_timer->start( autoopenTime );
    }
}

void KdeEventContent::contentsDragMoveEvent( QDragMoveEvent *e )
{
    if ( !QUriDrag::canDecode(e) ) {
        e->ignore();
        return;
    }

    QPoint vp = contentsToViewport( ( (QDragMoveEvent*)e )->pos() );
    QListViewItem *i = itemAt( vp );
    if ( i ) {
        setSelected( i, TRUE );
        e->accept();
        if ( i != dropItem ) {
            autoopen_timer->stop();
            dropItem = i;
            autoopen_timer->start( autoopenTime );
        }
        switch ( e->action() ) {
        case QDropEvent::Copy:
            break;
        case QDropEvent::Move:
            e->acceptAction();
            break;
        case QDropEvent::Link:
            e->acceptAction();
            break;
        default:
            ;
        }
    } else {
        e->ignore();
        autoopen_timer->stop();
        dropItem = 0;
    }
}

void KdeEventContent::contentsDragLeaveEvent( QDragLeaveEvent * )
{
    autoopen_timer->stop();
    dropItem = 0;

    setCurrentItem( oldCurrent );
    setSelected( oldCurrent, TRUE );
}

void KdeEventContent::contentsDropEvent( QDropEvent *e )
{
    autoopen_timer->stop();

    if ( !QUriDrag::canDecode(e) ) {
        e->ignore();
        return;
    }

    QListViewItem *item = itemAt( contentsToViewport(e->pos()) );
    if ( item ) {

        QStrList lst;

        QUriDrag::decode( e, lst );

        QString str;

        switch ( e->action() ) {
            case QDropEvent::Copy:
            str = "Copy";
            break;
            case QDropEvent::Move:
            str = "Move";
            e->acceptAction();
            break;
            case QDropEvent::Link:
            str = "Link";
            e->acceptAction();
            break;
            default:
            str = "Unknown";
        }

        str += "\n\n";

        e->accept();

        for ( uint i = 0; i < lst.count(); ++i ) {
            QString filename = lst.at( i );
            str += filename + "\n";
        }
        // str += QString( "\nTo\n\n   %1" ) .arg( fullPath(item) );

        QMessageBox::information( this, "Drop target", str, "Not implemented" );
    } else
        e->ignore();

}

/*
QString KdeEventContent::fullPath(QListViewItem* item)
{
    QString fullpath = item->text(0);
    while ( (item=item->parent()) ) {
        if ( item->parent() )
            fullpath = item->text(0) + "/" + fullpath;
        else
            fullpath = item->text(0) + fullpath;
    }
    return fullpath;
}
*/

void KdeEventContent::contentsMousePressEvent( QMouseEvent* e )
{
    QListView::contentsMousePressEvent(e);
    QPoint p( contentsToViewport( e->pos() ) );
    QListViewItem *i = itemAt( p );
    if ( i ) {
        // if the user clicked into the root decoration of the item, don't try to start a drag!
        if ( p.x() > header()->cellPos( header()->mapToActual( 0 ) ) +
             treeStepSize() * ( i->depth() + ( rootIsDecorated() ? 1 : 0) ) + itemMargin() ||
             p.x() < header()->cellPos( header()->mapToActual( 0 ) ) ) {
            presspos = e->pos();
            mousePressed = TRUE;
        }
    }
}

void KdeEventContent::contentsMouseMoveEvent( QMouseEvent* e )
{
    if ( mousePressed && ( presspos - e->pos() ).manhattanLength() > QApplication::startDragDistance() ) {
        mousePressed = FALSE;
        QListViewItem *item = itemAt( contentsToViewport(presspos) );
        if ( item ) {
	  /*
            QString source = fullPath(item);
            if ( QFile::exists(source) ) {
                QUriDrag* ud = new QUriDrag(viewport());
                ud->setUnicodeUris( source );
                if ( ud->drag() )
                    QMessageBox::information( this, "Drag source",
                                              QString("Delete ")+source, "Not implemented" );
					      }*/
        }
    }
}

void KdeEventContent::contentsMouseReleaseEvent( QMouseEvent * )
{
    mousePressed = FALSE;
}

void KdeEventContent::setNote( const QString &s )
{
    QListViewItemIterator it( this );
    ++it;
    for ( ; it.current(); ++it ) {
        it.current()->setOpen( FALSE );
    }

    QStringList lst( QStringList::split( "/", s ) );
    QListViewItem *item = firstChild();
    QStringList::Iterator it2 = lst.begin();
    for ( ; it2 != lst.end(); ++it2 ) {
        while ( item ) {
            if ( item->text( 0 ) == *it2 ) {
                item->setOpen( TRUE );
                break;
            }
            item = item->itemBelow();
        }
    }

    if ( item )
        setCurrentItem( item );
}


#endif
#include "kdeEventContent.moc"
