#ifndef _KDEFACTORY_H_
#define _KDEFACTORY_H_

#include "config.h"

#include "arts/dispatcher.h"
#include "arts/qiomanager.h"

#include "prFactory.h"
#include "kdeScorePainter.h"

class KApplication;

class KdeFactory : public PrFactory
{
  friend class KdeScorePainter;

  Arts::QIOManager * qiomanager;
  Arts::Dispatcher * dispatcher;
  KApplication * brahms;

 public:
  KdeFactory() {};
  virtual ~KdeFactory();

  virtual PresentationType isA() const { return KDE; }
  virtual PrMainEditor * createMainEditor(int,char**);
  virtual PrTrack * createScoreTrack(Track*);
  virtual PrTrack * createDrumTrack(Track*);
  virtual PrTrack * createMasterTrack(Track*);
  virtual PrTrack * createAudioTrack(Track*);
  virtual PrTrack * createCommentTrack(Track*);
  virtual PrPart  * createPart(Part*);
  virtual PrScorePainter * getScorePainter();
};

#endif
