/*  This file is part of the Brahms project
    Copyright (C) 2001 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: klineeditaction.h,v 1.1 2001/07/23 08:16:59 mkretz Exp $ */

#ifndef KLINEEDITACTION_H
#define KLINEEDITACTION_H

#include <qguardedptr.h>
#include <qfont.h>

#include <kaction.h>

class KLineEdit;
class QObject;

class KLineEditAction : public KAction
{
	Q_OBJECT
public:
	KLineEditAction( const QString& text, QObject* parent, const char* name );
	virtual ~KLineEditAction();

	virtual int plug( QWidget *w, int index = -1 );
	 
	virtual void unplug( QWidget *w );

	QGuardedPtr<KLineEdit> lined() { return m_lined; }

	void setFont( const QFont & );
	void setText( const QString & );

signals:
	void plugged();
	void returnPressed();

private:
	QGuardedPtr<KLineEdit> m_lined;
	QFont m_font;
	bool m_fontset;
	QString m_text;
};

#endif //KLINEEDITACTION_H

// vim:tw=4:sw=4
