#ifndef _TOGBUTTON_CPP_
#define _TOGBUTTON_CPP_

#include <qpixmap.h>
#include <iostream.h>

#include "kdeTrack.h"
#include "togButton.h"


TogButton::TogButton( QPixmap * pic1, QPixmap * pic2, QWidget * parent, const char * name )
  : QLabel( parent, name ), _state(false), _track((KdeTrack*)parent), _high(pic1), _low(pic2)
{
  if (_low==0) _low = new QPixmap();
  setAlignment(AlignCenter);
  setPixmap( *_low );
}

void TogButton::mousePressEvent( QMouseEvent * mouse ) {
  if (mouse->button()==LeftButton) {
    if (_state) _state = false;
    else _state = true;
    /*
    if (_track->gToggle(_index)==TRUE) {
      // Off
      setPixmap( *_low );
      _track->sToggle(_index,FALSE);
    } else {
      // On
      setPixmap( *_high );
      setAlignment(AlignCenter);
      _track->sToggle(_index,TRUE);
      }*/
    _track->updateCore();
    _track->update();
  }
}


bool TogButton::state() { return _state; }

void TogButton::setState(bool s) {
  _state = s;
  if (s) setPixmap( *_high );
  else setPixmap( *_low );
}


#endif
#include "togButton.moc"
