#ifndef _TOGBUTTON_H_
#define _TOGBUTTON_H_

#include <qlabel.h>

class KdeTrack;
class QPixmap;

/**
 * This class defines a toggel button, as it is used three times in each track
 * @author Jan Wuerthner
 * @version 0.95
 */
class TogButton : public QLabel
{
  Q_OBJECT

private:
  bool _state;
  KdeTrack * _track;
  QPixmap * _high;
  QPixmap * _low;

public:
  TogButton( QPixmap * pic1, QPixmap * pic2, QWidget * parent=0, const char * name=0);

  bool state();
  void setState(bool);

public slots:
  void mousePressEvent ( QMouseEvent * );
};


#endif
