/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/***************************************************************************
 *            burn-basics.h
 *
 *  Sat Feb 11 16:49:00 2006
 *  Copyright  2006  philippe
 *  <brasero-app@wanadoo.fr>
 ****************************************************************************/
#ifndef _BURN_BASICS_H
#define _BURN_BASICS_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <glib.h>

#include <nautilus-burn-drive.h>

#define CDR_SPEED 153600
#define DVD_SPEED 1385000

GQuark brasero_burn_quark (void);
#define BRASERO_BURN_ERROR brasero_burn_quark()

typedef enum {
	BRASERO_BURN_ERROR_NONE,
	BRASERO_BURN_ERROR_GENERAL,

	BRASERO_BURN_ERROR_TMP_DIR,
	BRASERO_BURN_ERROR_FILE_EXIST,
	BRASERO_BURN_ERROR_INVALID_FILE,
	BRASERO_BURN_ERROR_INCOMPATIBLE_FORMAT,
	BRASERO_BURN_ERROR_JOLIET_TREE,

	BRASERO_BURN_ERROR_SCSI_IOCTL,
	BRASERO_BURN_ERROR_SLOW_DMA,
	BRASERO_BURN_ERROR_PERMISSION,
	BRASERO_BURN_ERROR_BUSY_DRIVE,

	BRASERO_BURN_ERROR_DISC_SPACE,

	BRASERO_BURN_ERROR_MEDIA_SPACE,
	BRASERO_BURN_ERROR_RELOAD_MEDIA,
	BRASERO_BURN_ERROR_MEDIA_BLANK,
	BRASERO_BURN_ERROR_MEDIA_BUSY,
	BRASERO_BURN_ERROR_MEDIA_NONE,
	BRASERO_BURN_ERROR_MEDIA_NOT_REWRITABLE,
	BRASERO_BURN_ERROR_MEDIA_NOT_WRITABLE,
	BRASERO_BURN_ERROR_DVD_NOT_SUPPORTED,
	BRASERO_BURN_ERROR_CD_NOT_SUPPORTED,
} BraseroBurnError;

typedef enum {
	BRASERO_BURN_OK,
	BRASERO_BURN_ERR,
	BRASERO_BURN_RETRY,
	BRASERO_BURN_CANCEL,
	BRASERO_BURN_RUNNING,
	BRASERO_BURN_DANGEROUS,
	BRASERO_BURN_NOT_READY,
	BRASERO_BURN_NOT_RUNNING,
	BRASERO_BURN_NEED_RELOAD,
	BRASERO_BURN_NOT_SUPPORTED,
} BraseroBurnResult;

typedef enum {
	BRASERO_BURN_ACTION_NONE		= 0,
	BRASERO_BURN_ACTION_GETTING_SIZE,
	BRASERO_BURN_ACTION_CREATING_IMAGE,
	BRASERO_BURN_ACTION_DRIVE_COPY,
	BRASERO_BURN_ACTION_FILE_COPY,
	BRASERO_BURN_ACTION_ANALYSING,
	BRASERO_BURN_ACTION_TRANSCODING,
	BRASERO_BURN_ACTION_PREPARING,
	BRASERO_BURN_ACTION_WRITING,
	BRASERO_BURN_ACTION_WRITING_CD_TEXT,
	BRASERO_BURN_ACTION_FIXATING,
	BRASERO_BURN_ACTION_BLANKING,
	BRASERO_BURN_ACTION_FINISHED,
	BRASERO_BURN_ACTION_LAST
} BraseroBurnAction;

typedef enum {
	BRASERO_MEDIA_NONE			= 0,
	BRASERO_MEDIA_TYPE_DVD			= 1,
	BRASERO_MEDIA_TYPE_CD			= 1 << 1,
	BRASERO_MEDIA_BLANK			= 1 << 2,
	BRASERO_MEDIA_WITH_DATA			= 1 << 3,
	BRASERO_MEDIA_REWRITABLE		= 1 << 4,
	BRASERO_MEDIA_WRITABLE			= 1 << 5,
} BraseroMediaType;

const char *
brasero_burn_action_to_string (BraseroBurnAction action);

typedef enum {
	BRASERO_TRACK_SOURCE_DEFAULT,
	BRASERO_TRACK_SOURCE_UNKNOWN,
	BRASERO_TRACK_SOURCE_SONG,		/* imager */
	BRASERO_TRACK_SOURCE_INF,		/* recorder */
	BRASERO_TRACK_SOURCE_AUDIO,		/* recorder */
	BRASERO_TRACK_SOURCE_DATA,		/* imager */
	BRASERO_TRACK_SOURCE_DISC,		/* imager */
	BRASERO_TRACK_SOURCE_CUE,		/* recorder */
	BRASERO_TRACK_SOURCE_ISO,		/* recorder */
	BRASERO_TRACK_SOURCE_RAW,		/* recorder */
	BRASERO_TRACK_SOURCE_IMAGER,		/* used internally for on the fly burning */
	BRASERO_TRACK_SOURCE_GRAFTS,		/* used internally mostly + must be local files */
	BRASERO_TRACK_SOURCE_ISO_JOLIET,	/* used internally mostly */
} BraseroTrackSourceType;

typedef struct _BraseroImager BraseroImager;

struct _BraseroTrackSource {
	BraseroTrackSourceType type;

	union {
		struct {
			gchar *label;
			GSList *grafts;		/* BraseroGraftPt *graft */
			GSList *excluded;		/* list of uris (char*) that are to be always excluded */

			gint use_joliet:1;
		} data;
		struct {
			gchar *label;
			gchar *grafts_path;
			gchar *excluded_path;

			gint use_joliet:1;
		} grafts;
		struct {
			gchar *album;
			GSList *files;			/* BraseroSongFile *file */
		} songs;
		struct {
			GSList *files;
		} audio;
		struct {
			GSList *files;			/* char *path_to_inf */
		} inf;
		struct {
			NautilusBurnDrive *disc;
			BraseroTrackSourceType target;
		} drive;
		struct {
			gchar *image;
			gchar *toc;
		} cue;
		struct {
			gchar *image;
		} iso;
		struct {
			gchar *image;
			gchar *toc;
		} raw;
		struct {
			BraseroImager *obj;
		} imager;
			
	} contents;
};
typedef struct _BraseroTrackSource BraseroTrackSource;

gchar *
brasero_track_source_get_iso_localpath (BraseroTrackSource *track);
gchar *
brasero_track_source_get_raw_localpath (BraseroTrackSource *track);
gchar *
brasero_track_source_get_cue_localpath (BraseroTrackSource *track);

void
brasero_track_source_free (BraseroTrackSource *source);
BraseroTrackSource *
brasero_track_source_copy (const BraseroTrackSource *source);

struct _BraseroGraftPt {
	char *uri;
	char *path;
	GSList *excluded; /* list of uris (char *) that are to be excluded only for this path */
};
typedef struct _BraseroGraftPt BraseroGraftPt;

void
brasero_graft_point_free (BraseroGraftPt *graft);
BraseroGraftPt *
brasero_graft_point_copy (BraseroGraftPt *graft);

struct _BraseroSongFile {
	char *title;
	char *artist;
	char *composer;
	int isrc;
	char *uri;

	gboolean gap;
};
typedef struct _BraseroSongFile BraseroSongFile;

#ifdef __cplusplus
}
#endif

#endif /* _BURN-BASICS_H */
 
