/*****************************************************************************
 *
 *  Copyright (C) 2003 Cdric Brgardis <cedric.bregardis@free.fr>
 *
 *  This file is part of BRIQUOLO
 *
 *  BRIQUOLO is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  BRIQUOLO is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with BRIQUOLO; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#include "I18n.h"
#include <iostream>
#include "Constante.h"

#ifdef WIN32
  #include <windows.h>
  #include <winnt.h>
  #include <winnls.h>
#endif


static string stIdCountry;

void DefinirLanguage()
{
#ifdef WIN32
  char buf[4];
  buf[3]=0;
  GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_SABBREVLANGNAME, buf, 3);
  if (strncmp(buf, "FR", 2)==0)
  {
    gettext_putenv("LANGUAGE=fr");
    bindtextdomain(Constante::GetNomPackage().c_str(), Constante::GetLocaleDir().c_str());
    textdomain (Constante::GetNomPackage().c_str());
  }
  if (strncmp(buf, "NL", 2)==0)
  {
    gettext_putenv("LANGUAGE=nl");
    bindtextdomain(Constante::GetNomPackage().c_str(), Constante::GetLocaleDir().c_str());
    textdomain (Constante::GetNomPackage().c_str());
  }


#else
  char * ch = setlocale (LC_MESSAGES, "");
  if (ch==NULL || setlocale (LC_CTYPE, "")==NULL)
  {
    cout<<"locale inconnue"<<endl;
  }

  if (ch != NULL)
  {
    stIdCountry = ch;
  }
  bindtextdomain(Constante::GetNomPackage().c_str(), Constante::GetLocaleDir().c_str());
  textdomain (Constante::GetNomPackage().c_str());
  bind_textdomain_codeset(Constante::GetNomPackage().c_str(), "UTF-8");

#endif
}

string GetIdCountry()
{
  return stIdCountry.substr(0,2);
}

