
/*
 *  Diverse Bristol midi routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

//#define DEBUG

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include <sys/poll.h>

#include "bristolmidi.h"

int midiMode;

//bristolMidiMsg msg;

static fd_set Input_fds, Output_fds;
static struct timeval waittime;

extern bristolMidiMain bmidi;

/*
 * This needs to go into a separate midi management interface.
 */
midiCheck()
{
	int mread, i, max = 0;
	unsigned char mbuf[16];

	struct pollfd pollit;

#ifdef DEBUG
	printf("midiCheck()\n");
#endif

	/*
	 * This should go into select() over any opened devices.
	 */
	while (!(bmidi.flags & BRISTOL_MIDI_TERMINATE))
	{
		FD_ZERO(&Input_fds);
		for (i = 0; i < BRISTOL_MIDI_DEVCOUNT; i++)
			if (bmidi.dev[i].fd > 0)
			{
				/*
				 * We will poll for the control socket, and select for the
				 * rest.
				 */
				FD_SET(bmidi.dev[i].fd, &Input_fds);
				if (bmidi.dev[i].fd > max)
					max = bmidi.dev[i].fd;
			}

		/*
		 * We could wait forever, but use 5 seconds for now.
		 */
		waittime.tv_sec = 5;
		waittime.tv_usec = 0;

		if (select(max + 1, &Input_fds, NULL, NULL, &waittime) > 0)
			for (i = 0; i < BRISTOL_MIDI_DEVCOUNT; i++)
			{
				if ((bmidi.dev[i].fd > 0) &&
					(FD_ISSET(bmidi.dev[i].fd, &Input_fds)))
				{
					if (bmidi.dev[i].flags & BRISTOL_ACCEPT_SOCKET)
						acceptConnection(i);
					else
						bristolMidiDevRead(i, &bmidi.dev[i].msg);
				}
			}
	}
}

