/***************************************************************************
*	Brutal Chess Pre-Alpha Build
*	- gnuchessplayer.cpp
*
*	Authors: Maxwell Lazaroff, Michael Cook, and Joe Flint
*	Date Created : November 5th, 2005
*	Last Modified: November 5th, 2005
*
*	- description - Implements GNUChess implementation into a brutal chess
*   chess player.
***************************************************************************/

#ifndef WIN32

#include "gnuchessplayer.h"

void 
GNUChessPlayer::runGNUChess() 
{
	pipe( to );
	pipe( from );

	if( fork() == 0 ) {
		// Child Process
		nice( 20 );
		dup2( to[0], 0 );
		dup2( from[1], 1 );
		close( to[0] );
		close( to[1] );
		close( from[0] );
		execvp( "gnuchess", NULL );
		cerr << "Couldn't run gnuchess" << endl;
	}
	write( to[1], "xboard\n", 7 );
	init = true;
}

BoardMove 
GNUChessPlayer::decide_move( const Board & board, bool & player )
{
	if( !init )
		runGNUChess();
	string output;
	char c;
	while( output.substr( 0, 11 ) != "My move is:" ) {
		output = "";
		while( read( from[0], &c, 1 ) ) {
			if( c == '\n' )
				break;
			output += c;
		}
	}
	output = output.substr( 12, 4 );

	BoardMove move;
	move.setStart( output[0], output[1] - '0' );
	move.setEnd( output[2], output[3] - '0' );

	return move;
	
}

void GNUChessPlayer::opponent_move( const BoardMove & move, bool white )
{
	if( !init )
		runGNUChess();
	string movestr = "";
	movestr += move.getStartFile();
	movestr += '0'+move.getStartRank();
	movestr += move.getEndFile();
	movestr += '0'+move.getEndRank();
	movestr += '\n';

	write( to[1], movestr.c_str(), 5 );
}
#endif

// End of file gnuchessplayer.cpp