/*
 * (c) Copyright 2001 - 2004 -- Anders Torger
 *
 * This program is open source. For license terms, see the LICENSE file.
 *
 */
static void
RAW2REAL_NAME(real_t *realbuf,
              void *rawbuf,
              int bytes,
              int shift,
              bool_t isfloat,
              int spacing,
              bool_t swap,
              int n_samples)
{
    int32_t sample;
    int n, i;

    if (isfloat) {
	if (shift != 0) {
	    fprintf(stderr, "Shift must be zero for floating point formats.\n");
	    bf_exit(BF_EXIT_OTHER);
	}
#if REALSIZE == 4
        switch (bytes) {
        case 4:
            if (swap) {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    ((uint32_t *)realbuf)[n] =
                        SWAP32(((uint32_t *)rawbuf)[i]);
                }
            } else {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    realbuf[n] = ((real_t *)rawbuf)[i];
                }
            }
            break;
        case 8:
            if (swap) {
                uint64_t u64;
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    u64 = SWAP64(((uint64_t *)rawbuf)[i]);
                    realbuf[n] = (float)*((double *)((void *)&u64));
                }
            } else {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    realbuf[n] = (real_t)(((double *)rawbuf)[i]);
                }
            }
            break;
        default:
            goto raw2real_invalid_byte_size;
        }
#elif REALSIZE == 8
        switch (bytes) {
        case 4:
            if (swap) {
                uint32_t u32;
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    u32 = SWAP32(((uint32_t *)rawbuf)[i]);
                    realbuf[n] = (real_t)*((float *)((void *)&u32));
                }
            } else {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    realbuf[n] = (real_t)(((float *)rawbuf)[i]);
                }
            }
            break;
        case 8:
            if (swap) {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    ((uint64_t *)realbuf)[n] =
                        SWAP64(((uint64_t *)rawbuf)[i]);
                }
            } else {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    realbuf[n] = ((real_t *)rawbuf)[i];
                }
            }
            break;
        default:
            goto raw2real_invalid_byte_size;
        }
#else
 #error invalid REALSIZE
#endif        
        return;
    }

    sample = 0;
    switch (bytes) {
    case 1:
	for (n = i = 0; n < n_samples; n++, i += spacing) {
	    realbuf[n] = (real_t)((int8_t *)rawbuf)[i];
	}
	break;
    case 2:
	if (shift == 0) {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = (int16_t)SWAP16(((uint16_t *)rawbuf)[i]);
		    realbuf[n] = (real_t)sample;
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    realbuf[n] = (real_t)((int16_t *)rawbuf)[i];
		}
	    }
	} else {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = (int16_t)SWAP16(((uint16_t *)rawbuf)[i]) >> shift;
		    realbuf[n] = (real_t)sample;
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    realbuf[n] = (real_t)(((int16_t *)rawbuf)[i] >> shift);
		}
	    }
	}
	break;
    case 3:
	spacing = spacing * 3 - 3;
        shift += 8;
#ifdef __BIG_ENDIAN__
        if (swap) {
            for (n = i = 0; n < n_samples; n++, i += spacing) {
                ((uint8_t *)&sample)[2] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[1] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[0] = ((uint8_t *)rawbuf)[i++];
                realbuf[n] = (real_t)(sample >> shift);
            }
        } else {
            for (n = i = 0; n < n_samples; n++, i += spacing) {
                ((uint8_t *)&sample)[0] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[1] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[2] = ((uint8_t *)rawbuf)[i++];
                realbuf[n] = (real_t)(sample >> shift);
            }
	}
#endif        
#ifdef __LITTLE_ENDIAN__
        if (swap) {
            for (n = i = 0; n < n_samples; n++, i += spacing) {
                ((uint8_t *)&sample)[3] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[2] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[1] = ((uint8_t *)rawbuf)[i++];
                realbuf[n] = (real_t)(sample >> shift);
            }
        } else {
            for (n = i = 0; n < n_samples; n++, i += spacing) {
                ((uint8_t *)&sample)[1] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[2] = ((uint8_t *)rawbuf)[i++];
                ((uint8_t *)&sample)[3] = ((uint8_t *)rawbuf)[i++];
                realbuf[n] = (real_t)(sample >> shift);
            }
        }
#endif
	break;
    case 4:
	if (shift == 0) {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = (int32_t)SWAP32(((uint32_t *)rawbuf)[i]);
		    realbuf[n] = (real_t)sample;
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    realbuf[n] = (real_t)((int32_t *)rawbuf)[i];
		}
	    }
	} else {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = (int32_t)SWAP32(((uint32_t *)rawbuf)[i]) >> shift;
		    realbuf[n] = (real_t)sample;
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    realbuf[n] = (real_t)(((int32_t *)rawbuf)[i] >> shift);
		}
	    }
	}
	break;
    default:
    raw2real_invalid_byte_size:
	fprintf(stderr, "Sample byte size %d is not suppported.\n", bytes);
	bf_exit(BF_EXIT_OTHER);
	break;
    }    
}
