/*
 * (c) Copyright 2001 - 2004 -- Anders Torger
 *
 * This program is open source. For license terms, see the LICENSE file.
 *
 */

#define REAL_OVERFLOW_UPDATE                                                   \
    if (realbuf[n] < 0.0) {                                                    \
        if (realbuf[n] < rmin) {                                               \
            overflow->n_overflows++;                                           \
        }                                                                      \
        if (realbuf[n] < -overflow->largest) {                                 \
            overflow->largest = -realbuf[n];                                   \
        }                                                                      \
    } else {                                                                   \
        if (realbuf[n] > rmax) {                                               \
            overflow->n_overflows++;                                           \
        }                                                                      \
        if (realbuf[n] > overflow->largest) {                                  \
            overflow->largest = realbuf[n];                                    \
        }                                                                      \
    }

static void
REAL2RAW_NAME(void *rawbuf,
	      real_t *realbuf,
	      int bits,
	      int bytes,
	      int shift,
	      bool_t isfloat,
	      int spacing,
	      bool_t swap,
	      int n_samples,
	      struct bfoverflow *overflow REAL2RAW_EXTRA_PARAMS)
{
    int32_t sample, imin, imax;
    real_t rmin, rmax;
    int n, i;

    /*
     * It is assumed that sbytes only can have the values possible from the
     * supported sample formats specified in bfmod.h
     */
    
    if (isfloat) {
        rmin = -overflow->max;
        rmax = overflow->max;
	if (shift != 0) {
	    fprintf(stderr, "Shift must be zero for floating point formats.\n");
	    bf_exit(BF_EXIT_OTHER);
	}
#if REALSIZE == 4
        switch (bytes) {
        case 4:
            if (swap) {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    ((uint32_t *)rawbuf)[i] =
                        SWAP32(((uint32_t *)((void *)realbuf))[n]);
                }
            } else {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    ((real_t *)rawbuf)[i] = realbuf[n];
                }
            }
            break;
        case 8:
            if (swap) {
                double d;
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    d = (double)realbuf[n];
                    ((uint64_t *)rawbuf)[i] =
                        SWAP64(*(uint64_t *)((void *)&d));
                }
            } else {
                double d;
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    d = (double)realbuf[n];
                    ((uint64_t *)rawbuf)[i] = *(uint64_t *)((void *)&d);
                }
            }
            break;
        default:
            goto real2raw_invalid_byte_size;
        }
#elif REALSIZE == 8
        switch (bytes) {
        case 4:
            if (swap) {
                float f;
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    f = (float)realbuf[n];
                    ((uint32_t *)rawbuf)[i] =
                        SWAP32(*(uint32_t *)((void *)&f));
                }
            } else {
                float f;
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    f = (float)realbuf[n];
                    ((uint32_t *)rawbuf)[i] = *(uint32_t *)((void *)&f);
                }
            }
            break;
        case 8:
            if (swap) {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    ((uint64_t *)rawbuf)[i] =
                        SWAP64(((uint64_t *)((void *)realbuf))[n]);
                }
            } else {
                for (n = i = 0; n < n_samples; n++, i += spacing) {
                    REAL_OVERFLOW_UPDATE;
                    ((real_t *)rawbuf)[i] = realbuf[n];
                }
            }
            break;
        default:
            goto real2raw_invalid_byte_size;
        }
#else
 #error invalid REALSIZE
#endif        
	return;
    }
    
    imin = -(1 << (bits - 1));
    imax = (1 << (bits - 1)) - 1;
    rmin = (real_t)imin;
    rmax = (real_t)imax;
    switch (bytes) {
    case 1:
	for (n = i = 0; n < n_samples; n++, i += spacing) {
	    sample = REAL2INT_CALL;
	    ((int8_t *)rawbuf)[i] = (int8_t)sample;
	}
	break;
    case 2:
	if (shift == 0) {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint16_t *)rawbuf)[i] = SWAP16(sample);
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint16_t *)rawbuf)[i] = sample;
		}
	    }
	} else {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint16_t *)rawbuf)[i] = SWAP16(sample);
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint16_t *)rawbuf)[i] = sample;
		}
	    }
	}
	break;
    case 3:
	spacing = spacing * 3 - 3;
#ifdef __BIG_ENDIAN__
	if (shift == 0) {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[3];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[3];
		}
	    }
	} else {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[3];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[3];
		}
	    }
	}
#endif        
#ifdef __LITTLE_ENDIAN__
	if (shift == 0) {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[0];
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[0];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		}
	    }
	} else {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[0];
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[0];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[1];
		    ((uint8_t *)rawbuf)[i++] = ((uint8_t *)&sample)[2];
		}
	    }
	}
#endif
	break;
    case 4:	
	if (shift == 0) {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint32_t *)rawbuf)[i] = SWAP32(sample);
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL;
		    ((uint32_t *)rawbuf)[i] = sample;
		}
	    }
	} else {
	    if (swap) {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint32_t *)rawbuf)[i] = SWAP32(sample);
		}
	    } else {
		for (n = i = 0; n < n_samples; n++, i += spacing) {
		    sample = REAL2INT_CALL << shift;
		    ((uint32_t *)rawbuf)[i] = sample;
		}
	    }
	}
	break;
    default:
    real2raw_invalid_byte_size:
	fprintf(stderr, "Sample byte size %d is not suppported.\n", bytes);
	bf_exit(BF_EXIT_OTHER);
	break;
    }        
}

#undef REAL_OVERFLOW_UPDATE
