/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_CANOVERWRITE_H
#define INCLUDED_CANOVERWRITE_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_CANOVERWRITE_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QCOLOR_H
#include <qcolor.h>
#define INCLUDED_QCOLOR_H
#endif // INCLUDED_QCOLOR_H

#ifndef INCLUDED_QCHECKBOX_H
#include <qcheckbox.h>
#define INCLUDED_QCHECKBOX_H
#endif // INCLUDED_QCHECKBOX_H

#ifndef INCLUDED_INFOFIELD_H
#include "InfoField.h"
#endif // INCLUDED_INFOFIELD_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QPushButton;

/*------- class declaration:
-------------------------------------------------------------------*/
class CanOverwrite : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	CanOverwrite( QWidget* const in_parent, const QString& in_fname );
private:
	CanOverwrite( const CanOverwrite& );
	CanOverwrite& operator=( const CanOverwrite& );

// ******* MEMBERS *******
public:
	enum {
		CANCEL = -1,
		SKIP = 1,
		OVER,
		UPDATE,
		RENAME
	};
private:
	static const QString Caption;
	static const int     Margin;
	static const QColor  MsgColor;
	static const QString MsgText;
	static const QString BtnSkipLabel;
	static const QString BtnOverLabel;
	static const QString BtnUpdateLabel;
	static const QString BtnRenameLabel;
	static const QString CbDontAskLabel;
	
	InfoField*   d_info_field;
	QCheckBox*   d_ask_checkbox;
	QPushButton* d_rename_button;
	QPushButton* d_skip_button;
	QPushButton* d_over_button;
	QPushButton* d_update_button;
	QPushButton* d_cancel_button;
	
// ******* METHODS *******
public:
	bool ask_again() const { return ( FALSE == d_ask_checkbox->isChecked() ); }
private:
	void polish();
private slots:
	void rename();
	void skip();
	void over();
	void update();
	void cancel();
};

#endif // INCLUDED_CANOVERWRITE_H
