/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_VIEWER_H
#define INCLUDED_VIEWER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QHBoxLayout;
class QTextEdit;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class ViewTableItem;
class SystemCall;

/*------- class declaration:
-------------------------------------------------------------------*/
class Viewer : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Viewer( QWidget* const in_parent, const ViewTableItem* const in_item );
	~Viewer();
private:
	Viewer( const Viewer& );
	Viewer& operator=( const Viewer& );
	
// ******* members *******
private:
	enum {
		CHECK = 0,
		DISPLAY,
	};
	static const QString Caption;
	static const QString TextSign;
	static const QString TarSign;
	static const QString GzipSign;
	static const QString Bzip2Sign;
	
	QVBoxLayout*  const  d_main_layout;
	QHBoxLayout*  const  d_btn_layout;
	QTextEdit*    const  d_browser;
	QPushButton*  const  d_btn_return;
	QPushButton*  const  d_btn_break;
	const QString        d_path;
	int                  d_what;
	SystemCall*          d_syscall;
	
// ******* methods *******
private:
	void polish             ();
private slots:
	void stdout_line        ( const QString& );
	void stderr_line        ( const QString& );
	void finished           ( int );
};

#endif // INCLUDED_VIEWER_H
