/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "MainWindow.h"
#include "Config.h"
#include "Limits.h"
#include <qapplication.h>

//********************************************************************
// main
//********************************************************************
int main( int argc, char** argv )
{
	Config* config = Config::instance();
	Limits* limits = Limits::instance();

	QApplication app( argc, argv );
	MainWindow window;
	app.setMainWidget( &window );
	window.show();
	const int retval = app.exec();
	
	delete config;
	delete limits;
	return retval;
}
// end of main
