/* manager.c generated by valac 0.32.1, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <libpeas/peas.h>


#define BUDGIE_TYPE_DESKTOP_MANAGER (budgie_desktop_manager_get_type ())
#define BUDGIE_DESKTOP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DESKTOP_MANAGER, BudgieDesktopManager))
#define BUDGIE_DESKTOP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_DESKTOP_MANAGER, BudgieDesktopManagerClass))
#define BUDGIE_IS_DESKTOP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DESKTOP_MANAGER))
#define BUDGIE_IS_DESKTOP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_DESKTOP_MANAGER))
#define BUDGIE_DESKTOP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_DESKTOP_MANAGER, BudgieDesktopManagerClass))

typedef struct _BudgieDesktopManager BudgieDesktopManager;
typedef struct _BudgieDesktopManagerClass BudgieDesktopManagerClass;
typedef struct _BudgieDesktopManagerPrivate BudgieDesktopManagerPrivate;

#define BUDGIE_TYPE_TOPLEVEL (budgie_toplevel_get_type ())
#define BUDGIE_TOPLEVEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TOPLEVEL, BudgieToplevel))
#define BUDGIE_TOPLEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TOPLEVEL, BudgieToplevelClass))
#define BUDGIE_IS_TOPLEVEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TOPLEVEL))
#define BUDGIE_IS_TOPLEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TOPLEVEL))
#define BUDGIE_TOPLEVEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TOPLEVEL, BudgieToplevelClass))

typedef struct _BudgieToplevel BudgieToplevel;
typedef struct _BudgieToplevelClass BudgieToplevelClass;

#define BUDGIE_TYPE_PANEL_POSITION (budgie_panel_position_get_type ())

typedef enum  {
	BUDGIE_PANEL_POSITION_NONE = 1 << 0,
	BUDGIE_PANEL_POSITION_BOTTOM = 1 << 1,
	BUDGIE_PANEL_POSITION_TOP = 1 << 2,
	BUDGIE_PANEL_POSITION_LEFT = 1 << 3,
	BUDGIE_PANEL_POSITION_RIGHT = 1 << 4
} BudgiePanelPosition;

struct _BudgieDesktopManager {
	GObject parent_instance;
	BudgieDesktopManagerPrivate * priv;
};

struct _BudgieDesktopManagerClass {
	GObjectClass parent_class;
	GList* (*get_panels) (BudgieDesktopManager* self);
	guint (*slots_available) (BudgieDesktopManager* self);
	guint (*slots_used) (BudgieDesktopManager* self);
	void (*set_placement) (BudgieDesktopManager* self, const gchar* uuid, BudgiePanelPosition position);
	void (*set_size) (BudgieDesktopManager* self, const gchar* uuid, gint size);
	void (*create_new_panel) (BudgieDesktopManager* self);
	void (*delete_panel) (BudgieDesktopManager* self, const gchar* uuid);
	GList* (*get_panel_plugins) (BudgieDesktopManager* self);
};


static gpointer budgie_desktop_manager_parent_class = NULL;

GType budgie_desktop_manager_get_type (void) G_GNUC_CONST;
GType budgie_toplevel_get_type (void) G_GNUC_CONST;
GType budgie_panel_position_get_type (void) G_GNUC_CONST;
enum  {
	BUDGIE_DESKTOP_MANAGER_DUMMY_PROPERTY
};
GList* budgie_desktop_manager_get_panels (BudgieDesktopManager* self);
static GList* budgie_desktop_manager_real_get_panels (BudgieDesktopManager* self);
guint budgie_desktop_manager_slots_available (BudgieDesktopManager* self);
static guint budgie_desktop_manager_real_slots_available (BudgieDesktopManager* self);
guint budgie_desktop_manager_slots_used (BudgieDesktopManager* self);
static guint budgie_desktop_manager_real_slots_used (BudgieDesktopManager* self);
void budgie_desktop_manager_set_placement (BudgieDesktopManager* self, const gchar* uuid, BudgiePanelPosition position);
static void budgie_desktop_manager_real_set_placement (BudgieDesktopManager* self, const gchar* uuid, BudgiePanelPosition position);
void budgie_desktop_manager_set_size (BudgieDesktopManager* self, const gchar* uuid, gint size);
static void budgie_desktop_manager_real_set_size (BudgieDesktopManager* self, const gchar* uuid, gint size);
void budgie_desktop_manager_create_new_panel (BudgieDesktopManager* self);
static void budgie_desktop_manager_real_create_new_panel (BudgieDesktopManager* self);
void budgie_desktop_manager_delete_panel (BudgieDesktopManager* self, const gchar* uuid);
static void budgie_desktop_manager_real_delete_panel (BudgieDesktopManager* self, const gchar* uuid);
GList* budgie_desktop_manager_get_panel_plugins (BudgieDesktopManager* self);
static GList* budgie_desktop_manager_real_get_panel_plugins (BudgieDesktopManager* self);
BudgieDesktopManager* budgie_desktop_manager_construct (GType object_type);


static GList* budgie_desktop_manager_real_get_panels (BudgieDesktopManager* self) {
	GList* result = NULL;
	result = NULL;
	return result;
}


GList* budgie_desktop_manager_get_panels (BudgieDesktopManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->get_panels (self);
}


static guint budgie_desktop_manager_real_slots_available (BudgieDesktopManager* self) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_slots_available'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint budgie_desktop_manager_slots_available (BudgieDesktopManager* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->slots_available (self);
}


static guint budgie_desktop_manager_real_slots_used (BudgieDesktopManager* self) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_slots_used'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint budgie_desktop_manager_slots_used (BudgieDesktopManager* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->slots_used (self);
}


static void budgie_desktop_manager_real_set_placement (BudgieDesktopManager* self, const gchar* uuid, BudgiePanelPosition position) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_set_placement'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_desktop_manager_set_placement (BudgieDesktopManager* self, const gchar* uuid, BudgiePanelPosition position) {
	g_return_if_fail (self != NULL);
	BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->set_placement (self, uuid, position);
}


static void budgie_desktop_manager_real_set_size (BudgieDesktopManager* self, const gchar* uuid, gint size) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_set_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_desktop_manager_set_size (BudgieDesktopManager* self, const gchar* uuid, gint size) {
	g_return_if_fail (self != NULL);
	BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->set_size (self, uuid, size);
}


static void budgie_desktop_manager_real_create_new_panel (BudgieDesktopManager* self) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_create_new_panel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_desktop_manager_create_new_panel (BudgieDesktopManager* self) {
	g_return_if_fail (self != NULL);
	BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->create_new_panel (self);
}


static void budgie_desktop_manager_real_delete_panel (BudgieDesktopManager* self, const gchar* uuid) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_delete_panel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_desktop_manager_delete_panel (BudgieDesktopManager* self, const gchar* uuid) {
	g_return_if_fail (self != NULL);
	BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->delete_panel (self, uuid);
}


static GList* budgie_desktop_manager_real_get_panel_plugins (BudgieDesktopManager* self) {
	g_critical ("Type `%s' does not implement abstract method `budgie_desktop_manager_get_panel_plugins'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GList* budgie_desktop_manager_get_panel_plugins (BudgieDesktopManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BUDGIE_DESKTOP_MANAGER_GET_CLASS (self)->get_panel_plugins (self);
}


BudgieDesktopManager* budgie_desktop_manager_construct (GType object_type) {
	BudgieDesktopManager * self = NULL;
	self = (BudgieDesktopManager*) g_object_new (object_type, NULL);
	return self;
}


static void budgie_desktop_manager_class_init (BudgieDesktopManagerClass * klass) {
	budgie_desktop_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgieDesktopManagerClass *) klass)->get_panels = budgie_desktop_manager_real_get_panels;
	((BudgieDesktopManagerClass *) klass)->slots_available = budgie_desktop_manager_real_slots_available;
	((BudgieDesktopManagerClass *) klass)->slots_used = budgie_desktop_manager_real_slots_used;
	((BudgieDesktopManagerClass *) klass)->set_placement = budgie_desktop_manager_real_set_placement;
	((BudgieDesktopManagerClass *) klass)->set_size = budgie_desktop_manager_real_set_size;
	((BudgieDesktopManagerClass *) klass)->create_new_panel = budgie_desktop_manager_real_create_new_panel;
	((BudgieDesktopManagerClass *) klass)->delete_panel = budgie_desktop_manager_real_delete_panel;
	((BudgieDesktopManagerClass *) klass)->get_panel_plugins = budgie_desktop_manager_real_get_panel_plugins;
	g_signal_new ("panels_changed", BUDGIE_TYPE_DESKTOP_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void budgie_desktop_manager_instance_init (BudgieDesktopManager * self) {
}


GType budgie_desktop_manager_get_type (void) {
	static volatile gsize budgie_desktop_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_desktop_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieDesktopManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_desktop_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieDesktopManager), 0, (GInstanceInitFunc) budgie_desktop_manager_instance_init, NULL };
		GType budgie_desktop_manager_type_id;
		budgie_desktop_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieDesktopManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&budgie_desktop_manager_type_id__volatile, budgie_desktop_manager_type_id);
	}
	return budgie_desktop_manager_type_id__volatile;
}



