/* polkitdialog.c generated by valac 0.32.1, the Vala compiler
 * generated from polkitdialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <polkitagent/polkitagent.h>
#include <polkit/polkit.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <pwd.h>
#include <sys/types.h>
#include <grp.h>
#include <BudgieSession.h>
#include <theme.h>
#include <unistd.h>
#include <stdio.h>


#define BUDGIE_TYPE_AGENT_DIALOG (budgie_agent_dialog_get_type ())
#define BUDGIE_AGENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog))
#define BUDGIE_AGENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialogClass))
#define BUDGIE_IS_AGENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AGENT_DIALOG))
#define BUDGIE_IS_AGENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AGENT_DIALOG))
#define BUDGIE_AGENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialogClass))

typedef struct _BudgieAgentDialog BudgieAgentDialog;
typedef struct _BudgieAgentDialogClass BudgieAgentDialogClass;
typedef struct _BudgieAgentDialogPrivate BudgieAgentDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_AGENT (budgie_agent_get_type ())
#define BUDGIE_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AGENT, BudgieAgent))
#define BUDGIE_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AGENT, BudgieAgentClass))
#define BUDGIE_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AGENT))
#define BUDGIE_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AGENT))
#define BUDGIE_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AGENT, BudgieAgentClass))

typedef struct _BudgieAgent BudgieAgent;
typedef struct _BudgieAgentClass BudgieAgentClass;
typedef struct _BudgieAgentPrivate BudgieAgentPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _BudgieAgentInitiateAuthenticationData BudgieAgentInitiateAuthenticationData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgieAgentRegisterWithSessionData BudgieAgentRegisterWithSessionData;

struct _BudgieAgentDialog {
	GtkWindow parent_instance;
	BudgieAgentDialogPrivate * priv;
	PolkitAgentSession* pk_session;
};

struct _BudgieAgentDialogClass {
	GtkWindowClass parent_class;
};

struct _BudgieAgentDialogPrivate {
	GtkEntry* entry_auth;
	GtkLabel* label_message;
	GtkImage* image_icon;
	GtkComboBox* combobox_idents;
	GtkLabel* label_prompt;
	GtkLabel* label_error;
	PolkitIdentity* pk_identity;
	gchar* _action_id;
	gchar* _icon;
	GCancellable* _cancellable;
	gchar* _cookie;
	gulong error_id;
	gulong request_id;
	gulong info_id;
	gulong complete_id;
};

struct _BudgieAgent {
	PolkitAgentListener parent_instance;
	BudgieAgentPrivate * priv;
};

struct _BudgieAgentClass {
	PolkitAgentListenerClass parent_class;
};

struct _BudgieAgentPrivate {
	LibSessionSessionClient* sclient;
	gchar* current_theme_uri;
	GSettings* settings;
	GtkCssProvider* css_provider;
};

struct _Block1Data {
	int _ref_count_;
	BudgieAgent* self;
	gpointer _async_data_;
};

struct _BudgieAgentInitiateAuthenticationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieAgent* self;
	gchar* action_id;
	gchar* message;
	gchar* icon_name;
	PolkitDetails* details;
	gchar* cookie;
	GList* identities;
	GCancellable* cancellable;
	gboolean result;
	Block1Data* _data1_;
	BudgieAgentDialog* dialog;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	BudgieAgentDialog* _tmp4_;
	BudgieAgentDialog* _tmp5_;
	GList* _tmp6_;
	BudgieAgentDialog* _tmp7_;
	BudgieAgentDialog* _tmp8_;
	GList* _tmp9_;
	BudgieAgentDialog* _tmp10_;
	BudgieAgentDialog* _tmp11_;
};

struct _BudgieAgentRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieAgent* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	GError* e;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	GError * _inner_error_;
};


static gpointer budgie_agent_dialog_parent_class = NULL;
static gpointer budgie_agent_parent_class = NULL;

GType budgie_agent_dialog_get_type (void) G_GNUC_CONST;
#define BUDGIE_AGENT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialogPrivate))
enum  {
	BUDGIE_AGENT_DIALOG_DUMMY_PROPERTY,
	BUDGIE_AGENT_DIALOG_ACTION_ID,
	BUDGIE_AGENT_DIALOG_MESSAGE,
	BUDGIE_AGENT_DIALOG_AUTH_DATA,
	BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME,
	BUDGIE_AGENT_DIALOG_CANCELLABLE,
	BUDGIE_AGENT_DIALOG_COOKIE
};
BudgieAgentDialog* budgie_agent_dialog_new (const gchar* action_id, const gchar* message, const gchar* icon_name, const gchar* cookie, GCancellable* cancellable);
BudgieAgentDialog* budgie_agent_dialog_construct (GType object_type, const gchar* action_id, const gchar* message, const gchar* icon_name, const gchar* cookie, GCancellable* cancellable);
static void budgie_agent_dialog_on_ident_changed (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_ident_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static gboolean budgie_agent_dialog_on_key_release (BudgieAgentDialog* self, GdkEventKey* key);
static gboolean _budgie_agent_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void budgie_agent_dialog_on_agent_cancelled (BudgieAgentDialog* self);
static void budgie_agent_dialog_on_entry_auth_activate (BudgieAgentDialog* self);
static void budgie_agent_dialog_on_agent_authenticate (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_entry_auth_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void budgie_agent_dialog_real_show (GtkWidget* base);
static void budgie_agent_dialog_on_pk_session_completed (BudgieAgentDialog* self, gboolean authorized);
GCancellable* budgie_agent_dialog_get_cancellable (BudgieAgentDialog* self);
static void budgie_agent_dialog_deselect_session (BudgieAgentDialog* self);
void budgie_agent_dialog_set_auth_data (BudgieAgentDialog* self, const gchar* value);
static void budgie_agent_dialog_select_session (BudgieAgentDialog* self);
static void budgie_agent_dialog_on_pk_request (BudgieAgentDialog* self, const gchar* request, gboolean echo_on);
static void budgie_agent_dialog_on_pk_error (BudgieAgentDialog* self, const gchar* text);
static void budgie_agent_dialog_on_pk_info (BudgieAgentDialog* self, const gchar* text);
const gchar* budgie_agent_dialog_get_cookie (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_pk_session_completed_polkit_agent_session_completed (PolkitAgentSession* _sender, gboolean gained_authorization, gpointer self);
static void _budgie_agent_dialog_on_pk_request_polkit_agent_session_request (PolkitAgentSession* _sender, const gchar* request, gboolean echo_on, gpointer self);
static void _budgie_agent_dialog_on_pk_error_polkit_agent_session_show_error (PolkitAgentSession* _sender, const gchar* text, gpointer self);
static void _budgie_agent_dialog_on_pk_info_polkit_agent_session_show_info (PolkitAgentSession* _sender, const gchar* text, gpointer self);
void budgie_agent_dialog_set_from_idents (BudgieAgentDialog* self, GList* idents);
gchar* budgie_agent_dialog_get_auth_data (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_agent_authenticate_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _budgie_agent_dialog_on_agent_cancelled_gtk_button_clicked (GtkButton* _sender, gpointer self);
const gchar* budgie_agent_dialog_get_action_id (BudgieAgentDialog* self);
void budgie_agent_dialog_set_action_id (BudgieAgentDialog* self, const gchar* value);
gchar* budgie_agent_dialog_get_message (BudgieAgentDialog* self);
void budgie_agent_dialog_set_message (BudgieAgentDialog* self, const gchar* value);
const gchar* budgie_agent_dialog_get_auth_icon_name (BudgieAgentDialog* self);
void budgie_agent_dialog_set_auth_icon_name (BudgieAgentDialog* self, const gchar* value);
void budgie_agent_dialog_set_cancellable (BudgieAgentDialog* self, GCancellable* value);
void budgie_agent_dialog_set_cookie (BudgieAgentDialog* self, const gchar* value);
static void budgie_agent_dialog_finalize (GObject* obj);
static void _vala_budgie_agent_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_agent_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType budgie_agent_get_type (void) G_GNUC_CONST;
#define BUDGIE_AGENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_AGENT, BudgieAgentPrivate))
enum  {
	BUDGIE_AGENT_DUMMY_PROPERTY
};
static void budgie_agent_real_initiate_authentication_data_free (gpointer _data);
static void budgie_agent_real_initiate_authentication (PolkitAgentListener* base, const gchar* action_id, const gchar* message, const gchar* icon_name, PolkitDetails* details, const gchar* cookie, GList* identities, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean budgie_agent_real_initiate_authentication_co (BudgieAgentInitiateAuthenticationData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__budgie_agent_dialog_done (BudgieAgentDialog* _sender, gpointer self);
BudgieAgent* budgie_agent_new (void);
BudgieAgent* budgie_agent_construct (GType object_type);
static void budgie_agent_on_settings_changed (BudgieAgent* self, const gchar* key);
static void _budgie_agent_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void budgie_agent_on_theme_changed (BudgieAgent* self);
static void _budgie_agent_on_theme_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void budgie_agent_register_with_session (BudgieAgent* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean budgie_agent_register_with_session_finish (BudgieAgent* self, GAsyncResult* _res_);
static void __lambda8_ (BudgieAgent* self, GObject* o, GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void budgie_agent_register_with_session_data_free (gpointer _data);
static gboolean budgie_agent_register_with_session_co (BudgieAgentRegisterWithSessionData* _data_);
static void budgie_agent_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda5_ (BudgieAgent* self);
static void budgie_agent_end_session (BudgieAgent* self, gboolean quit);
static void ___lambda5__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self);
static void __lambda6_ (BudgieAgent* self);
static void ___lambda6__lib_session_session_client_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self);
static void __lambda7_ (BudgieAgent* self);
static void ___lambda7__lib_session_session_client_stop (LibSessionSessionClient* _sender, gpointer self);
static void budgie_agent_set_css_from_uri (BudgieAgent* self, const gchar* uri);
static void budgie_agent_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _budgie_agent_dialog_on_ident_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	budgie_agent_dialog_on_ident_changed ((BudgieAgentDialog*) self);
}


static gboolean _budgie_agent_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = budgie_agent_dialog_on_key_release ((BudgieAgentDialog*) self, event);
	return result;
}


BudgieAgentDialog* budgie_agent_dialog_construct (GType object_type, const gchar* action_id, const gchar* message, const gchar* icon_name, const gchar* cookie, GCancellable* cancellable) {
	BudgieAgentDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkSettings* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	GtkComboBox* _tmp9_ = NULL;
	GtkCellRendererText* render = NULL;
	GtkCellRendererText* _tmp10_ = NULL;
	GtkComboBox* _tmp11_ = NULL;
	GtkComboBox* _tmp12_ = NULL;
	GtkComboBox* _tmp13_ = NULL;
	g_return_val_if_fail (action_id != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (cookie != NULL, NULL);
	_tmp0_ = action_id;
	_tmp1_ = message;
	_tmp2_ = icon_name;
	_tmp3_ = cookie;
	_tmp4_ = cancellable;
	self = (BudgieAgentDialog*) g_object_new (object_type, "action-id", _tmp0_, "message", _tmp1_, "auth-icon-name", _tmp2_, "cookie", _tmp3_, "cancellable", _tmp4_, NULL);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	_tmp5_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp5_);
	header = _tmp5_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_remove_class (_tmp6_, "titlebar");
	_tmp7_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_value_init (&_tmp8_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp8_, TRUE);
	g_object_set_property ((GObject*) _tmp7_, "gtk-application-prefer-dark-theme", &_tmp8_);
	G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
	_tmp9_ = self->priv->combobox_idents;
	g_signal_connect_object (_tmp9_, "changed", (GCallback) _budgie_agent_dialog_on_ident_changed_gtk_combo_box_changed, self, 0);
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp10_);
	render = _tmp10_;
	_tmp11_ = self->priv->combobox_idents;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) render, TRUE);
	_tmp12_ = self->priv->combobox_idents;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) render, "text", 0);
	_tmp13_ = self->priv->combobox_idents;
	gtk_combo_box_set_id_column (_tmp13_, 0);
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER_ALWAYS, NULL);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _budgie_agent_dialog_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (render);
	_g_object_unref0 (header);
	return self;
}


BudgieAgentDialog* budgie_agent_dialog_new (const gchar* action_id, const gchar* message, const gchar* icon_name, const gchar* cookie, GCancellable* cancellable) {
	return budgie_agent_dialog_construct (BUDGIE_TYPE_AGENT_DIALOG, action_id, message, icon_name, cookie, cancellable);
}


static gboolean budgie_agent_dialog_on_key_release (BudgieAgentDialog* self, GdkEventKey* key) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = key;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_Escape)) {
		budgie_agent_dialog_on_agent_cancelled (self);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static void budgie_agent_dialog_on_entry_auth_activate (BudgieAgentDialog* self) {
	g_return_if_fail (self != NULL);
	budgie_agent_dialog_on_agent_authenticate (self);
}


static void _budgie_agent_dialog_on_entry_auth_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	budgie_agent_dialog_on_entry_auth_activate ((BudgieAgentDialog*) self);
}


static void budgie_agent_dialog_real_show (GtkWidget* base) {
	BudgieAgentDialog * self;
	GdkWindow* win = NULL;
	GdkWindow* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkWindow* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	self = (BudgieAgentDialog*) base;
	GTK_WIDGET_CLASS (budgie_agent_dialog_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	win = NULL;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	win = _tmp0_;
	_tmp1_ = win;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = win;
	gdk_window_focus (_tmp2_, (guint32) GDK_CURRENT_TIME);
	_tmp3_ = self->priv->entry_auth;
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void budgie_agent_dialog_on_pk_session_completed (BudgieAgentDialog* self, gboolean authorized) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	_tmp1_ = authorized;
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->_cancellable;
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		PolkitAgentSession* session = NULL;
		PolkitAgentSession* _tmp6_ = NULL;
		PolkitAgentSession* _tmp7_ = NULL;
		GtkEntry* _tmp8_ = NULL;
		PolkitAgentSession* _tmp9_ = NULL;
		PolkitAgentSession* _tmp10_ = NULL;
		_tmp4_ = self->priv->label_error;
		_tmp5_ = _ ("Authentication failed");
		gtk_label_set_text (_tmp4_, _tmp5_);
		_tmp6_ = self->pk_session;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		session = _tmp7_;
		budgie_agent_dialog_deselect_session (self);
		budgie_agent_dialog_set_auth_data (self, "");
		_tmp8_ = self->priv->entry_auth;
		gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
		_tmp9_ = session;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (self->pk_session);
		self->pk_session = _tmp10_;
		budgie_agent_dialog_select_session (self);
		_g_object_unref0 (session);
		return;
	}
	g_signal_emit_by_name (self, "done");
}


static void budgie_agent_dialog_on_pk_request (BudgieAgentDialog* self, const gchar* request, gboolean echo_on) {
	GtkEntry* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->entry_auth;
	_tmp1_ = echo_on;
	gtk_entry_set_visibility (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->label_prompt;
	_tmp3_ = request;
	gtk_label_set_text (_tmp2_, _tmp3_);
}


static void budgie_agent_dialog_on_pk_error (BudgieAgentDialog* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	g_warning ("polkitdialog.vala:155: PkError: %s", _tmp0_);
}


static void budgie_agent_dialog_on_pk_info (BudgieAgentDialog* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	g_message ("polkitdialog.vala:160: PKInfo: %s", _tmp0_);
}


static void budgie_agent_dialog_deselect_session (BudgieAgentDialog* self) {
	PolkitAgentSession* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ != NULL) {
		PolkitAgentSession* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
		PolkitAgentSession* _tmp3_ = NULL;
		gulong _tmp4_ = 0UL;
		PolkitAgentSession* _tmp5_ = NULL;
		gulong _tmp6_ = 0UL;
		PolkitAgentSession* _tmp7_ = NULL;
		gulong _tmp8_ = 0UL;
		_tmp1_ = self->pk_session;
		_tmp2_ = self->priv->error_id;
		g_signal_handler_disconnect (_tmp1_, _tmp2_);
		_tmp3_ = self->pk_session;
		_tmp4_ = self->priv->complete_id;
		g_signal_handler_disconnect (_tmp3_, _tmp4_);
		_tmp5_ = self->pk_session;
		_tmp6_ = self->priv->request_id;
		g_signal_handler_disconnect (_tmp5_, _tmp6_);
		_tmp7_ = self->pk_session;
		_tmp8_ = self->priv->info_id;
		g_signal_handler_disconnect (_tmp7_, _tmp8_);
	}
	_g_object_unref0 (self->pk_session);
	self->pk_session = NULL;
}


static void _budgie_agent_dialog_on_pk_session_completed_polkit_agent_session_completed (PolkitAgentSession* _sender, gboolean gained_authorization, gpointer self) {
	budgie_agent_dialog_on_pk_session_completed ((BudgieAgentDialog*) self, gained_authorization);
}


static void _budgie_agent_dialog_on_pk_request_polkit_agent_session_request (PolkitAgentSession* _sender, const gchar* request, gboolean echo_on, gpointer self) {
	budgie_agent_dialog_on_pk_request ((BudgieAgentDialog*) self, request, echo_on);
}


static void _budgie_agent_dialog_on_pk_error_polkit_agent_session_show_error (PolkitAgentSession* _sender, const gchar* text, gpointer self) {
	budgie_agent_dialog_on_pk_error ((BudgieAgentDialog*) self, text);
}


static void _budgie_agent_dialog_on_pk_info_polkit_agent_session_show_info (PolkitAgentSession* _sender, const gchar* text, gpointer self) {
	budgie_agent_dialog_on_pk_info ((BudgieAgentDialog*) self, text);
}


static void budgie_agent_dialog_select_session (BudgieAgentDialog* self) {
	PolkitAgentSession* _tmp0_ = NULL;
	PolkitIdentity* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PolkitAgentSession* _tmp3_ = NULL;
	PolkitAgentSession* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	PolkitAgentSession* _tmp6_ = NULL;
	gulong _tmp7_ = 0UL;
	PolkitAgentSession* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	PolkitAgentSession* _tmp10_ = NULL;
	gulong _tmp11_ = 0UL;
	PolkitAgentSession* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ != NULL) {
		budgie_agent_dialog_deselect_session (self);
	}
	_tmp1_ = self->priv->pk_identity;
	_tmp2_ = self->priv->_cookie;
	_tmp3_ = polkit_agent_session_new (_tmp1_, _tmp2_);
	_g_object_unref0 (self->pk_session);
	self->pk_session = _tmp3_;
	_tmp4_ = self->pk_session;
	_tmp5_ = g_signal_connect_object (_tmp4_, "completed", (GCallback) _budgie_agent_dialog_on_pk_session_completed_polkit_agent_session_completed, self, 0);
	self->priv->complete_id = _tmp5_;
	_tmp6_ = self->pk_session;
	_tmp7_ = g_signal_connect_object (_tmp6_, "request", (GCallback) _budgie_agent_dialog_on_pk_request_polkit_agent_session_request, self, 0);
	self->priv->request_id = _tmp7_;
	_tmp8_ = self->pk_session;
	_tmp9_ = g_signal_connect_object (_tmp8_, "show-error", (GCallback) _budgie_agent_dialog_on_pk_error_polkit_agent_session_show_error, self, 0);
	self->priv->error_id = _tmp9_;
	_tmp10_ = self->pk_session;
	_tmp11_ = g_signal_connect_object (_tmp10_, "show-info", (GCallback) _budgie_agent_dialog_on_pk_info_polkit_agent_session_show_info, self, 0);
	self->priv->info_id = _tmp11_;
	_tmp12_ = self->pk_session;
	polkit_agent_session_initiate (_tmp12_);
}


static void budgie_agent_dialog_on_ident_changed (BudgieAgentDialog* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->combobox_idents;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		budgie_agent_dialog_deselect_session (self);
		return;
	}
	_tmp3_ = self->priv->combobox_idents;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	model = _tmp5_;
	_tmp6_ = model;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (model);
		return;
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, 1, &self->priv->pk_identity, -1, -1);
	budgie_agent_dialog_select_session (self);
	_g_object_unref0 (model);
}


void budgie_agent_dialog_set_from_idents (BudgieAgentDialog* self, GList* idents) {
	GtkListBoxRow* active_row = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter iter = {0};
	gint length = 0;
	GList* _tmp1_ = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	g_return_if_fail (self != NULL);
	active_row = NULL;
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, polkit_identity_get_type (), -1);
	model = _tmp0_;
	length = 0;
	_tmp1_ = idents;
	{
		GList* ident_collection = NULL;
		GList* ident_it = NULL;
		ident_collection = _tmp1_;
		for (ident_it = ident_collection; ident_it != NULL; ident_it = ident_it->next) {
			PolkitIdentity* ident = NULL;
			ident = (PolkitIdentity*) ident_it->data;
			{
				gchar* name = NULL;
				PolkitIdentity* _tmp2_ = NULL;
				GtkListStore* _tmp19_ = NULL;
				GtkTreeIter _tmp20_ = {0};
				GtkListStore* _tmp21_ = NULL;
				GtkTreeIter _tmp22_ = {0};
				const gchar* _tmp23_ = NULL;
				PolkitIdentity* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				name = NULL;
				_tmp2_ = ident;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, polkit_unix_user_get_type ())) {
					struct passwd* pwd = NULL;
					PolkitIdentity* _tmp3_ = NULL;
					gint _tmp4_ = 0;
					struct passwd* _tmp5_ = NULL;
					struct passwd* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					_tmp3_ = ident;
					_tmp4_ = polkit_unix_user_get_uid (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, polkit_unix_user_get_type ()) ? ((PolkitUnixUser*) _tmp3_) : NULL);
					_tmp5_ = getpwuid ((uid_t) _tmp4_);
					pwd = _tmp5_;
					_tmp6_ = pwd;
					_tmp7_ = _tmp6_->pw_name;
					_tmp8_ = g_strdup_printf ("%s", _tmp7_);
					_g_free0 (name);
					name = _tmp8_;
				} else {
					PolkitIdentity* _tmp9_ = NULL;
					_tmp9_ = ident;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, polkit_unix_group_get_type ())) {
						struct group* gwd = NULL;
						PolkitIdentity* _tmp10_ = NULL;
						gint _tmp11_ = 0;
						struct group* _tmp12_ = NULL;
						const gchar* _tmp13_ = NULL;
						struct group* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						_tmp10_ = ident;
						_tmp11_ = polkit_unix_group_get_gid (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, polkit_unix_group_get_type ()) ? ((PolkitUnixGroup*) _tmp10_) : NULL);
						_tmp12_ = getgrgid ((gid_t) _tmp11_);
						gwd = _tmp12_;
						_tmp13_ = _ ("Group:");
						_tmp14_ = gwd;
						_tmp15_ = _tmp14_->gr_name;
						_tmp16_ = g_strdup_printf ("%s: %s", _tmp13_, _tmp15_);
						_g_free0 (name);
						name = _tmp16_;
					} else {
						PolkitIdentity* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						_tmp17_ = ident;
						_tmp18_ = polkit_identity_to_string (_tmp17_);
						_g_free0 (name);
						name = _tmp18_;
					}
				}
				_tmp19_ = model;
				gtk_list_store_append (_tmp19_, &_tmp20_);
				iter = _tmp20_;
				_tmp21_ = model;
				_tmp22_ = iter;
				_tmp23_ = name;
				_tmp24_ = ident;
				gtk_list_store_set (_tmp21_, &_tmp22_, 0, _tmp23_, 1, _tmp24_, -1);
				_tmp25_ = length;
				length = _tmp25_ + 1;
				_g_free0 (name);
			}
		}
	}
	_tmp26_ = self->priv->combobox_idents;
	_tmp27_ = model;
	gtk_combo_box_set_model (_tmp26_, (GtkTreeModel*) _tmp27_);
	_tmp28_ = self->priv->combobox_idents;
	gtk_combo_box_set_active (_tmp28_, 0);
	_tmp29_ = length;
	if (_tmp29_ < 2) {
		GtkComboBox* _tmp30_ = NULL;
		GtkComboBox* _tmp31_ = NULL;
		_tmp30_ = self->priv->combobox_idents;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp30_, TRUE);
		_tmp31_ = self->priv->combobox_idents;
		gtk_widget_hide ((GtkWidget*) _tmp31_);
	}
	_g_object_unref0 (model);
	_g_object_unref0 (active_row);
}


static void budgie_agent_dialog_on_agent_authenticate (BudgieAgentDialog* self) {
	PolkitAgentSession* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	PolkitAgentSession* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ == NULL) {
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	_tmp1_ = self->priv->label_error;
	gtk_label_set_text (_tmp1_, "");
	_tmp2_ = self->pk_session;
	_tmp3_ = budgie_agent_dialog_get_auth_data (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	polkit_agent_session_response (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
}


static void _budgie_agent_dialog_on_agent_authenticate_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_agent_dialog_on_agent_authenticate ((BudgieAgentDialog*) self);
}


static void budgie_agent_dialog_on_agent_cancelled (BudgieAgentDialog* self) {
	PolkitAgentSession* _tmp0_ = NULL;
	GCancellable* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ != NULL) {
		PolkitAgentSession* _tmp1_ = NULL;
		_tmp1_ = self->pk_session;
		polkit_agent_session_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->_cancellable;
	_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
	if (!_tmp3_) {
		GCancellable* _tmp4_ = NULL;
		_tmp4_ = self->priv->_cancellable;
		g_cancellable_cancel (_tmp4_);
	}
	g_signal_emit_by_name (self, "done");
}


static void _budgie_agent_dialog_on_agent_cancelled_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_agent_dialog_on_agent_cancelled ((BudgieAgentDialog*) self);
}


const gchar* budgie_agent_dialog_get_action_id (BudgieAgentDialog* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_id;
	result = _tmp0_;
	return result;
}


void budgie_agent_dialog_set_action_id (BudgieAgentDialog* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_action_id);
	self->priv->_action_id = _tmp1_;
	g_object_notify ((GObject *) self, "action-id");
}


gchar* budgie_agent_dialog_get_message (BudgieAgentDialog* self) {
	gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_message;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void budgie_agent_dialog_set_message (BudgieAgentDialog* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_message;
	_tmp1_ = value;
	gtk_label_set_text (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "message");
}


gchar* budgie_agent_dialog_get_auth_data (BudgieAgentDialog* self) {
	gchar* result;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->entry_auth;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void budgie_agent_dialog_set_auth_data (BudgieAgentDialog* self, const gchar* value) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry_auth;
	_tmp1_ = value;
	gtk_entry_set_text (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "auth-data");
}


const gchar* budgie_agent_dialog_get_auth_icon_name (BudgieAgentDialog* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


void budgie_agent_dialog_set_auth_icon_name (BudgieAgentDialog* self, const gchar* value) {
	GtkImage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image_icon;
	_tmp1_ = value;
	gtk_image_set_from_icon_name (_tmp0_, _tmp1_, GTK_ICON_SIZE_DIALOG);
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp3_;
	g_object_notify ((GObject *) self, "auth-icon-name");
}


GCancellable* budgie_agent_dialog_get_cancellable (BudgieAgentDialog* self) {
	GCancellable* result;
	GCancellable* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


void budgie_agent_dialog_set_cancellable (BudgieAgentDialog* self, GCancellable* value) {
	GCancellable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_cancellable = _tmp0_;
	g_object_notify ((GObject *) self, "cancellable");
}


const gchar* budgie_agent_dialog_get_cookie (BudgieAgentDialog* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cookie;
	result = _tmp0_;
	return result;
}


void budgie_agent_dialog_set_cookie (BudgieAgentDialog* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_cookie);
	self->priv->_cookie = _tmp1_;
	g_object_notify ((GObject *) self, "cookie");
}


static void budgie_agent_dialog_class_init (BudgieAgentDialogClass * klass) {
	gint BudgieAgentDialog_private_offset;
	budgie_agent_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieAgentDialogPrivate));
	((GtkWidgetClass *) klass)->show = budgie_agent_dialog_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_agent_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_agent_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_agent_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_ACTION_ID, g_param_spec_string ("action-id", "action-id", "action-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_AUTH_DATA, g_param_spec_string ("auth-data", "auth-data", "auth-data", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME, g_param_spec_string ("auth-icon-name", "auth-icon-name", "auth-icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_COOKIE, g_param_spec_string ("cookie", "cookie", "cookie", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	BudgieAgentDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/polkit/dialog.ui");
	g_signal_new ("done", BUDGIE_TYPE_AGENT_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_auth", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, entry_auth));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_message", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_message));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combobox_idents", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, combobox_idents));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_prompt", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_prompt));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_error", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_error));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_entry_auth_activate", G_CALLBACK(_budgie_agent_dialog_on_entry_auth_activate_gtk_entry_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_agent_authenticate", G_CALLBACK(_budgie_agent_dialog_on_agent_authenticate_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_agent_cancelled", G_CALLBACK(_budgie_agent_dialog_on_agent_cancelled_gtk_button_clicked));
}


static void budgie_agent_dialog_instance_init (BudgieAgentDialog * self) {
	gchar* _tmp0_ = NULL;
	self->priv = BUDGIE_AGENT_DIALOG_GET_PRIVATE (self);
	self->pk_session = NULL;
	self->priv->pk_identity = NULL;
	_tmp0_ = g_strdup ("dialog-password-symbolic");
	self->priv->_icon = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void budgie_agent_dialog_finalize (GObject* obj) {
	BudgieAgentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog);
	_g_object_unref0 (self->priv->entry_auth);
	_g_object_unref0 (self->priv->label_message);
	_g_object_unref0 (self->priv->image_icon);
	_g_object_unref0 (self->priv->combobox_idents);
	_g_object_unref0 (self->priv->label_prompt);
	_g_object_unref0 (self->priv->label_error);
	_g_object_unref0 (self->pk_session);
	_g_object_unref0 (self->priv->pk_identity);
	_g_free0 (self->priv->_action_id);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_cookie);
	G_OBJECT_CLASS (budgie_agent_dialog_parent_class)->finalize (obj);
}


GType budgie_agent_dialog_get_type (void) {
	static volatile gsize budgie_agent_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_agent_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieAgentDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_agent_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAgentDialog), 0, (GInstanceInitFunc) budgie_agent_dialog_instance_init, NULL };
		GType budgie_agent_dialog_type_id;
		budgie_agent_dialog_type_id = g_type_register_static (gtk_window_get_type (), "BudgieAgentDialog", &g_define_type_info, 0);
		g_once_init_leave (&budgie_agent_dialog_type_id__volatile, budgie_agent_dialog_type_id);
	}
	return budgie_agent_dialog_type_id__volatile;
}


static void _vala_budgie_agent_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieAgentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog);
	switch (property_id) {
		case BUDGIE_AGENT_DIALOG_ACTION_ID:
		g_value_set_string (value, budgie_agent_dialog_get_action_id (self));
		break;
		case BUDGIE_AGENT_DIALOG_MESSAGE:
		g_value_take_string (value, budgie_agent_dialog_get_message (self));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_DATA:
		g_value_take_string (value, budgie_agent_dialog_get_auth_data (self));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME:
		g_value_set_string (value, budgie_agent_dialog_get_auth_icon_name (self));
		break;
		case BUDGIE_AGENT_DIALOG_CANCELLABLE:
		g_value_set_object (value, budgie_agent_dialog_get_cancellable (self));
		break;
		case BUDGIE_AGENT_DIALOG_COOKIE:
		g_value_set_string (value, budgie_agent_dialog_get_cookie (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_agent_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieAgentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog);
	switch (property_id) {
		case BUDGIE_AGENT_DIALOG_ACTION_ID:
		budgie_agent_dialog_set_action_id (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_MESSAGE:
		budgie_agent_dialog_set_message (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_DATA:
		budgie_agent_dialog_set_auth_data (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME:
		budgie_agent_dialog_set_auth_icon_name (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_CANCELLABLE:
		budgie_agent_dialog_set_cancellable (self, g_value_get_object (value));
		break;
		case BUDGIE_AGENT_DIALOG_COOKIE:
		budgie_agent_dialog_set_cookie (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void budgie_agent_real_initiate_authentication_data_free (gpointer _data) {
	BudgieAgentInitiateAuthenticationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->action_id);
	_g_free0 (_data_->message);
	_g_free0 (_data_->icon_name);
	_g_object_unref0 (_data_->details);
	_g_free0 (_data_->cookie);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieAgentInitiateAuthenticationData, _data_);
}


static void budgie_agent_real_initiate_authentication (PolkitAgentListener* base, const gchar* action_id, const gchar* message, const gchar* icon_name, PolkitDetails* details, const gchar* cookie, GList* identities, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieAgent * self;
	BudgieAgentInitiateAuthenticationData* _data_;
	BudgieAgent* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	PolkitDetails* _tmp7_ = NULL;
	PolkitDetails* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GCancellable* _tmp12_ = NULL;
	GCancellable* _tmp13_ = NULL;
	self = (BudgieAgent*) base;
	_data_ = g_slice_new0 (BudgieAgentInitiateAuthenticationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_agent_real_initiate_authentication);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_agent_real_initiate_authentication_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = action_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->action_id);
	_data_->action_id = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->message);
	_data_->message = _tmp4_;
	_tmp5_ = icon_name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->icon_name);
	_data_->icon_name = _tmp6_;
	_tmp7_ = details;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->details);
	_data_->details = _tmp8_;
	_tmp9_ = cookie;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_data_->cookie);
	_data_->cookie = _tmp10_;
	_tmp11_ = identities;
	_data_->identities = _tmp11_;
	_tmp12_ = cancellable;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp13_;
	budgie_agent_real_initiate_authentication_co (_data_);
}


static gboolean budgie_agent_real_initiate_authentication_finish (PolkitAgentListener* base, GAsyncResult* _res_) {
	gboolean result;
	BudgieAgentInitiateAuthenticationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieAgent* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_) {
	BudgieAgent* self;
	self = _data1_->self;
	budgie_agent_real_initiate_authentication_co (_data1_->_async_data_);
}


static void ___lambda4__budgie_agent_dialog_done (BudgieAgentDialog* _sender, gpointer self) {
	__lambda4_ (self);
}


static gboolean budgie_agent_real_initiate_authentication_co (BudgieAgentInitiateAuthenticationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->action_id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->message;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->cookie;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->cancellable;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = budgie_agent_dialog_new (_data_->_tmp0_, _data_->_tmp1_, "dialog-password-symbolic", _data_->_tmp2_, _data_->_tmp3_);
	g_object_ref_sink (_data_->_tmp4_);
	_data_->dialog = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->dialog;
	g_signal_connect_data (_data_->_tmp5_, "done", (GCallback) ___lambda4__budgie_agent_dialog_done, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->identities;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->dialog;
		gtk_widget_destroy ((GtkWidget*) _data_->_tmp7_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->dialog);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->dialog;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->identities;
	budgie_agent_dialog_set_from_idents (_data_->_tmp8_, _data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->dialog;
	gtk_widget_show ((GtkWidget*) _data_->_tmp10_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp11_);
	_data_->result = TRUE;
	_g_object_unref0 (_data_->dialog);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->dialog);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _budgie_agent_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	budgie_agent_on_settings_changed ((BudgieAgent*) self, key);
}


static void _budgie_agent_on_theme_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	budgie_agent_on_theme_changed ((BudgieAgent*) self);
}


static void __lambda8_ (BudgieAgent* self, GObject* o, GAsyncResult* res) {
	gboolean success = FALSE;
	GAsyncResult* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = budgie_agent_register_with_session_finish (self, _tmp0_);
	success = _tmp1_;
	_tmp2_ = success;
	if (!_tmp2_) {
		g_message ("polkitdialog.vala:332: Failed to register with Session manager");
	}
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda8_ ((BudgieAgent*) self, source_object, res);
	g_object_unref (self);
}


BudgieAgent* budgie_agent_construct (GType object_type) {
	BudgieAgent * self = NULL;
	gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GtkSettings* gtksettings = NULL;
	GtkSettings* _tmp2_ = NULL;
	GtkSettings* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	self = (BudgieAgent*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_form_theme_path ("theme.css");
	_g_free0 (self->priv->current_theme_uri);
	self->priv->current_theme_uri = _tmp0_;
	_tmp1_ = g_settings_new ("com.solus-project.budgie-panel");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = gtk_settings_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	gtksettings = _tmp3_;
	_tmp4_ = self->priv->settings;
	g_settings_bind (_tmp4_, "dark-theme", (GObject*) gtksettings, "gtk-application-prefer-dark-theme", G_SETTINGS_BIND_GET);
	_tmp5_ = self->priv->settings;
	g_signal_connect_object (_tmp5_, "changed", (GCallback) _budgie_agent_on_settings_changed_g_settings_changed, self, 0);
	g_signal_connect_object ((GObject*) gtksettings, "notify::gtk-theme-name", (GCallback) _budgie_agent_on_theme_changed_g_object_notify, self, 0);
	budgie_agent_on_settings_changed (self, "builtin-theme");
	budgie_agent_register_with_session (self, ___lambda8__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (gtksettings);
	return self;
}


BudgieAgent* budgie_agent_new (void) {
	return budgie_agent_construct (BUDGIE_TYPE_AGENT);
}


static void budgie_agent_register_with_session_data_free (gpointer _data) {
	BudgieAgentRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieAgentRegisterWithSessionData, _data_);
}


static void budgie_agent_register_with_session (BudgieAgent* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieAgentRegisterWithSessionData* _data_;
	BudgieAgent* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BudgieAgentRegisterWithSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_agent_register_with_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_agent_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_agent_register_with_session_co (_data_);
}


static gboolean budgie_agent_register_with_session_finish (BudgieAgent* self, GAsyncResult* _res_) {
	gboolean result;
	BudgieAgentRegisterWithSessionData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void budgie_agent_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgieAgentRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_agent_register_with_session_co (_data_);
}


static void __lambda5_ (BudgieAgent* self) {
	budgie_agent_end_session (self, FALSE);
}


static void ___lambda5__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self) {
	__lambda5_ ((BudgieAgent*) self);
}


static void __lambda6_ (BudgieAgent* self) {
	budgie_agent_end_session (self, FALSE);
}


static void ___lambda6__lib_session_session_client_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self) {
	__lambda6_ ((BudgieAgent*) self);
}


static void __lambda7_ (BudgieAgent* self) {
	budgie_agent_end_session (self, TRUE);
}


static void ___lambda7__lib_session_session_client_stop (LibSessionSessionClient* _sender, gpointer self) {
	__lambda7_ ((BudgieAgent*) self);
}


static gboolean budgie_agent_register_with_session_co (BudgieAgentRegisterWithSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		lib_session_register_with_session ("budgie-polkit", budgie_agent_register_with_session_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
		_g_object_unref0 (_data_->self->priv->sclient);
		_data_->self->priv->sclient = _data_->_tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp1_, "query-end-session", (GCallback) ___lambda5__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "end-session", (GCallback) ___lambda6__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "stop", (GCallback) ___lambda7__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void budgie_agent_end_session (BudgieAgent* self, gboolean quit) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = quit;
	if (_tmp0_) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp1_ = NULL;
		_tmp1_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp1_, TRUE, "", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("polkitdialog.vala:366: Unable to respond to session manager! %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void budgie_agent_on_theme_changed (BudgieAgent* self) {
	GtkSettings* gtksettings = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	GtkSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtksettings = _tmp1_;
	_tmp2_ = gtksettings;
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "HighContrast") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp8_ = self->priv->current_theme_uri;
		if (_tmp8_ == NULL) {
			_g_free0 (_tmp7_);
			_tmp7_ = NULL;
		} else {
			gchar* _tmp9_ = NULL;
			_tmp9_ = budgie_form_theme_path ("theme.css");
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp9_;
		}
		budgie_agent_set_css_from_uri (self, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = self->priv->current_theme_uri;
		budgie_agent_set_css_from_uri (self, _tmp10_);
	}
	_g_object_unref0 (gtksettings);
}


static void budgie_agent_set_css_from_uri (BudgieAgent* self, const gchar* uri) {
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GtkCssProvider* new_provider = NULL;
	const gchar* _tmp2_ = NULL;
	GtkCssProvider* _tmp13_ = NULL;
	GtkCssProvider* _tmp16_ = NULL;
	GtkCssProvider* _tmp17_ = NULL;
	GdkScreen* _tmp18_ = NULL;
	GtkCssProvider* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	new_provider = NULL;
	_tmp2_ = uri;
	if (_tmp2_ == NULL) {
		GtkCssProvider* _tmp3_ = NULL;
		_tmp3_ = self->priv->css_provider;
		if (_tmp3_ != NULL) {
			GdkScreen* _tmp4_ = NULL;
			GtkCssProvider* _tmp5_ = NULL;
			_tmp4_ = screen;
			_tmp5_ = self->priv->css_provider;
			gtk_style_context_remove_provider_for_screen (_tmp4_, (GtkStyleProvider*) _tmp5_);
			_g_object_unref0 (self->priv->css_provider);
			self->priv->css_provider = NULL;
		}
		_g_object_unref0 (new_provider);
		_g_object_unref0 (screen);
		return;
	}
	{
		GFile* f = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GtkCssProvider* _tmp8_ = NULL;
		GtkCssProvider* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		f = _tmp7_;
		_tmp8_ = gtk_css_provider_new ();
		_g_object_unref0 (new_provider);
		new_provider = _tmp8_;
		_tmp9_ = new_provider;
		_tmp10_ = f;
		gtk_css_provider_load_from_file (_tmp9_, _tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (f);
			goto __catch2_g_error;
		}
		_g_object_unref0 (f);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("polkitdialog.vala:400: Error loading theme: %s", _tmp12_);
		_g_object_unref0 (new_provider);
		new_provider = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (new_provider);
		_g_object_unref0 (screen);
		return;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (new_provider);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->css_provider;
	if (_tmp13_ != NULL) {
		GdkScreen* _tmp14_ = NULL;
		GtkCssProvider* _tmp15_ = NULL;
		_tmp14_ = screen;
		_tmp15_ = self->priv->css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp14_, (GtkStyleProvider*) _tmp15_);
		_g_object_unref0 (self->priv->css_provider);
		self->priv->css_provider = NULL;
	}
	_tmp16_ = new_provider;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp17_;
	_tmp18_ = screen;
	_tmp19_ = self->priv->css_provider;
	gtk_style_context_add_provider_for_screen (_tmp18_, (GtkStyleProvider*) _tmp19_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (new_provider);
	_g_object_unref0 (screen);
}


static void budgie_agent_on_settings_changed (BudgieAgent* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "builtin-theme") != 0) {
		return;
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = key;
	_tmp3_ = g_settings_get_boolean (_tmp1_, _tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = budgie_form_theme_path ("theme.css");
		_g_free0 (self->priv->current_theme_uri);
		self->priv->current_theme_uri = _tmp4_;
	} else {
		_g_free0 (self->priv->current_theme_uri);
		self->priv->current_theme_uri = NULL;
	}
	budgie_agent_on_theme_changed (self);
}


static void budgie_agent_class_init (BudgieAgentClass * klass) {
	budgie_agent_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieAgentPrivate));
	((PolkitAgentListenerClass *) klass)->initiate_authentication = budgie_agent_real_initiate_authentication;
	((PolkitAgentListenerClass *) klass)->initiate_authentication_finish = budgie_agent_real_initiate_authentication_finish;
	G_OBJECT_CLASS (klass)->finalize = budgie_agent_finalize;
}


static void budgie_agent_instance_init (BudgieAgent * self) {
	self->priv = BUDGIE_AGENT_GET_PRIVATE (self);
	self->priv->css_provider = NULL;
}


static void budgie_agent_finalize (GObject* obj) {
	BudgieAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AGENT, BudgieAgent);
	_g_object_unref0 (self->priv->sclient);
	_g_free0 (self->priv->current_theme_uri);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->css_provider);
	G_OBJECT_CLASS (budgie_agent_parent_class)->finalize (obj);
}


GType budgie_agent_get_type (void) {
	static volatile gsize budgie_agent_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_agent_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieAgentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_agent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAgent), 0, (GInstanceInitFunc) budgie_agent_instance_init, NULL };
		GType budgie_agent_type_id;
		budgie_agent_type_id = g_type_register_static (polkit_agent_listener_get_type (), "BudgieAgent", &g_define_type_info, 0);
		g_once_init_leave (&budgie_agent_type_id__volatile, budgie_agent_type_id);
	}
	return budgie_agent_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	BudgieAgent* agent = NULL;
	BudgieAgent* _tmp0_ = NULL;
	PolkitSubject* subject = NULL;
	gint pid = 0;
	pid_t _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	gtk_init (&args_length1, &args);
	_tmp0_ = budgie_agent_new ();
	agent = _tmp0_;
	subject = NULL;
	_tmp1_ = getpid ();
	pid = (gint) _tmp1_;
	{
		PolkitSubject* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		PolkitSubject* _tmp4_ = NULL;
		PolkitSubject* _tmp5_ = NULL;
		_tmp3_ = pid;
		_tmp4_ = polkit_unix_session_new_for_process_sync (_tmp3_, NULL, &_inner_error_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (subject);
		subject = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stdout;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "Unable to initiate PolKit: %s", _tmp8_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		BudgieAgent* _tmp9_ = NULL;
		PolkitSubject* _tmp10_ = NULL;
		_tmp9_ = agent;
		_tmp10_ = subject;
		polkit_agent_register_listener ((PolkitAgentListener*) _tmp9_, _tmp10_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "Unable to register listener: %s", _tmp13_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_main ();
	result = 0;
	_g_object_unref0 (subject);
	_g_object_unref0 (agent);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



