/* MprisGui.c generated by valac 0.32.1, the Vala compiler
 * generated from MprisGui.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pango/pango.h>


#define TYPE_CLIENT_IMAGE (client_image_get_type ())
#define CLIENT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLIENT_IMAGE, ClientImage))
#define CLIENT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLIENT_IMAGE, ClientImageClass))
#define IS_CLIENT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLIENT_IMAGE))
#define IS_CLIENT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLIENT_IMAGE))
#define CLIENT_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLIENT_IMAGE, ClientImageClass))

typedef struct _ClientImage ClientImage;
typedef struct _ClientImageClass ClientImageClass;
typedef struct _ClientImagePrivate ClientImagePrivate;

#define TYPE_CLIENT_WIDGET (client_widget_get_type ())
#define CLIENT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLIENT_WIDGET, ClientWidget))
#define CLIENT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLIENT_WIDGET, ClientWidgetClass))
#define IS_CLIENT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLIENT_WIDGET))
#define IS_CLIENT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLIENT_WIDGET))
#define CLIENT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLIENT_WIDGET, ClientWidgetClass))

typedef struct _ClientWidget ClientWidget;
typedef struct _ClientWidgetClass ClientWidgetClass;
typedef struct _ClientWidgetPrivate ClientWidgetPrivate;

#define BUDGIE_TYPE_RAVEN_EXPANDER (budgie_raven_expander_get_type ())
#define BUDGIE_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander))
#define BUDGIE_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))
#define BUDGIE_IS_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_IS_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_RAVEN_EXPANDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))

typedef struct _BudgieRavenExpander BudgieRavenExpander;
typedef struct _BudgieRavenExpanderClass BudgieRavenExpanderClass;

#define TYPE_MPRIS_CLIENT (mpris_client_get_type ())
#define MPRIS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_CLIENT, MprisClient))
#define MPRIS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS_CLIENT, MprisClientClass))
#define IS_MPRIS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_CLIENT))
#define IS_MPRIS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS_CLIENT))
#define MPRIS_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS_CLIENT, MprisClientClass))

typedef struct _MprisClient MprisClient;
typedef struct _MprisClientClass MprisClientClass;

#define BUDGIE_TYPE_HEADER_WIDGET (budgie_header_widget_get_type ())
#define BUDGIE_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget))
#define BUDGIE_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))
#define BUDGIE_IS_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_IS_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_HEADER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))

typedef struct _BudgieHeaderWidget BudgieHeaderWidget;
typedef struct _BudgieHeaderWidgetClass BudgieHeaderWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;

#define TYPE_MPRIS_IFACE (mpris_iface_get_type ())
#define MPRIS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_IFACE, MprisIface))
#define IS_MPRIS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_IFACE))
#define MPRIS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_IFACE, MprisIfaceIface))

typedef struct _MprisIface MprisIface;
typedef struct _MprisIfaceIface MprisIfaceIface;

#define TYPE_MPRIS_IFACE_PROXY (mpris_iface_proxy_get_type ())

#define TYPE_PLAYER_IFACE (player_iface_get_type ())
#define PLAYER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_IFACE, PlayerIface))
#define IS_PLAYER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_IFACE))
#define PLAYER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PLAYER_IFACE, PlayerIfaceIface))

typedef struct _PlayerIface PlayerIface;
typedef struct _PlayerIfaceIface PlayerIfaceIface;

#define TYPE_PLAYER_IFACE_PROXY (player_iface_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DBUS_PROP_IFACE (dbus_prop_iface_get_type ())
#define DBUS_PROP_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBUS_PROP_IFACE, DbusPropIface))
#define IS_DBUS_PROP_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBUS_PROP_IFACE))
#define DBUS_PROP_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DBUS_PROP_IFACE, DbusPropIfaceIface))

typedef struct _DbusPropIface DbusPropIface;
typedef struct _DbusPropIfaceIface DbusPropIfaceIface;

#define TYPE_DBUS_PROP_IFACE_PROXY (dbus_prop_iface_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ClientImage {
	GtkImage parent_instance;
	ClientImagePrivate * priv;
};

struct _ClientImageClass {
	GtkImageClass parent_class;
};

struct _ClientWidget {
	GtkBox parent_instance;
	ClientWidgetPrivate * priv;
};

struct _ClientWidgetClass {
	GtkBoxClass parent_class;
};

struct _ClientWidgetPrivate {
	BudgieRavenExpander* player_revealer;
	GtkImage* background;
	GtkEventBox* background_wrap;
	MprisClient* client;
	GtkLabel* title_label;
	GtkLabel* artist_label;
	GtkLabel* album_label;
	GtkButton* prev_btn;
	GtkButton* play_btn;
	GtkButton* next_btn;
	gchar* filename;
	gint our_width;
	BudgieHeaderWidget* header;
};

struct _Block5Data {
	int _ref_count_;
	ClientWidget* self;
	MprisClient* client;
};

struct _MprisIfaceIface {
	GTypeInterface parent_iface;
	void (*raise) (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*raise_finish) (MprisIface* self, GAsyncResult* _res_, GError** error);
	void (*quit) (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*quit_finish) (MprisIface* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_can_quit) (MprisIface* self);
	void (*set_can_quit) (MprisIface* self, gboolean value);
	gboolean (*get_fullscreen) (MprisIface* self);
	gboolean (*get_can_set_fullscreen) (MprisIface* self);
	gboolean (*get_can_raise) (MprisIface* self);
	gboolean (*get_has_track_list) (MprisIface* self);
	gchar* (*get_identity) (MprisIface* self);
	gchar* (*get_desktop_entry) (MprisIface* self);
	gchar** (*get_supported_uri_schemes) (MprisIface* self, int* result_length1);
	gchar** (*get_supported_mime_types) (MprisIface* self, int* result_length1);
};

struct _PlayerIfaceIface {
	GTypeInterface parent_iface;
	void (*next) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*next_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*previous) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*previous_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*pause) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*pause_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*play_pause) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*play_pause_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*stop) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*stop_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*play) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*play_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*seek) (PlayerIface* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*seek_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*open_uri) (PlayerIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*open_uri_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	gchar* (*get_playback_status) (PlayerIface* self);
	gchar* (*get_loop_status) (PlayerIface* self);
	void (*set_loop_status) (PlayerIface* self, const gchar* value);
	gdouble (*get_rate) (PlayerIface* self);
	void (*set_rate) (PlayerIface* self, gdouble value);
	gboolean (*get_shuffle) (PlayerIface* self);
	void (*set_shuffle) (PlayerIface* self, gboolean value);
	GHashTable* (*get_metadata) (PlayerIface* self);
	gdouble (*get_volume) (PlayerIface* self);
	void (*set_volume) (PlayerIface* self, gdouble value);
	gint64 (*get_position) (PlayerIface* self);
	gdouble (*get_minimum_rate) (PlayerIface* self);
	gdouble (*get_maximum_rate) (PlayerIface* self);
	gboolean (*get_can_go_next) (PlayerIface* self);
	gboolean (*get_can_go_previous) (PlayerIface* self);
	gboolean (*get_can_play) (PlayerIface* self);
	gboolean (*get_can_pause) (PlayerIface* self);
	gboolean (*get_can_seek) (PlayerIface* self);
	gboolean (*get_can_control) (PlayerIface* self);
};

struct _DbusPropIfaceIface {
	GTypeInterface parent_iface;
};


static gpointer client_image_parent_class = NULL;
static gpointer client_widget_parent_class = NULL;

#define BACKGROUND_SIZE 250
GType client_image_get_type (void) G_GNUC_CONST;
enum  {
	CLIENT_IMAGE_DUMMY_PROPERTY
};
ClientImage* client_image_new_from_pixbuf (GdkPixbuf* pbuf);
ClientImage* client_image_construct_from_pixbuf (GType object_type, GdkPixbuf* pbuf);
ClientImage* client_image_new_from_icon_name (const gchar* icon_name, GtkIconSize size);
ClientImage* client_image_construct_from_icon_name (GType object_type, const gchar* icon_name, GtkIconSize size);
ClientImage* client_image_new (void);
ClientImage* client_image_construct (GType object_type);
GType client_widget_get_type (void) G_GNUC_CONST;
GType budgie_raven_expander_get_type (void) G_GNUC_CONST;
GType mpris_client_get_type (void) G_GNUC_CONST;
GType budgie_header_widget_get_type (void) G_GNUC_CONST;
#define CLIENT_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLIENT_WIDGET, ClientWidgetPrivate))
enum  {
	CLIENT_WIDGET_DUMMY_PROPERTY
};
ClientWidget* client_widget_new (MprisClient* client, gint width);
ClientWidget* client_widget_construct (GType object_type, MprisClient* client, gint width);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
GType mpris_iface_proxy_get_type (void) G_GNUC_CONST;
guint mpris_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_iface_get_type (void) G_GNUC_CONST;
GType player_iface_proxy_get_type (void) G_GNUC_CONST;
guint player_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType player_iface_get_type (void) G_GNUC_CONST;
PlayerIface* mpris_client_get_player (MprisClient* self);
gchar* mpris_iface_get_identity (MprisIface* self);
BudgieHeaderWidget* budgie_header_widget_new (const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
BudgieHeaderWidget* budgie_header_widget_construct (GType object_type, const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
static void __lambda14_ (Block5Data* _data5_);
gboolean mpris_iface_get_can_quit (MprisIface* self);
void mpris_iface_quit (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_iface_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
static void ___lambda14__budgie_header_widget_closed (BudgieHeaderWidget* _sender, gpointer self);
BudgieRavenExpander* budgie_raven_expander_new (BudgieHeaderWidget* header);
BudgieRavenExpander* budgie_raven_expander_construct (GType object_type, BudgieHeaderWidget* header);
void budgie_raven_expander_set_expanded (BudgieRavenExpander* self, gboolean value);
void budgie_header_widget_set_can_close (BudgieHeaderWidget* self, gboolean value);
gboolean budgie_header_widget_get_can_close (BudgieHeaderWidget* self);
static gboolean client_widget_on_raise_player (ClientWidget* self);
static gboolean _client_widget_on_raise_player_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
GtkWidget* create_row (const gchar* name, const gchar* icon, GIcon* gicon);
static void __lambda15_ (Block5Data* _data5_);
gboolean player_iface_get_can_go_previous (PlayerIface* self);
void player_iface_previous (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_previous_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda16_ (Block5Data* _data5_);
void player_iface_play_pause (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_play_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda17_ (Block5Data* _data5_);
gboolean player_iface_get_can_go_next (PlayerIface* self);
void player_iface_next (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_next_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
void client_widget_update_from_meta (ClientWidget* self);
static void client_widget_update_play_status (ClientWidget* self);
static void client_widget_update_controls (ClientWidget* self);
GType dbus_prop_iface_get_type (void) G_GNUC_CONST;
GType dbus_prop_iface_proxy_get_type (void) G_GNUC_CONST;
guint dbus_prop_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
DbusPropIface* mpris_client_get_prop (MprisClient* self);
static void __lambda18_ (ClientWidget* self, const gchar* i, GHashTable* p, gchar** inv, int inv_length1);
static void ___lambda19_ (ClientWidget* self, const gchar* k, GVariant* v);
static gboolean ___lambda20_ (ClientWidget* self);
static gboolean ____lambda20__gsource_func (gpointer self);
static gboolean ____lambda21_ (ClientWidget* self);
static gboolean _____lambda21__gsource_func (gpointer self);
static gboolean _____lambda22_ (ClientWidget* self);
static gboolean ______lambda22__gsource_func (gpointer self);
static void ____lambda19__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void ___lambda18__dbus_prop_iface_properties_changed (DbusPropIface* _sender, const gchar* iface, GHashTable* changed, gchar** invalid, int invalid_length1, gpointer self);
gboolean mpris_iface_get_can_raise (MprisIface* self);
void mpris_iface_raise (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_iface_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
gchar* player_iface_get_playback_status (PlayerIface* self);
void budgie_header_widget_set_icon_name (BudgieHeaderWidget* self, const gchar* value);
void budgie_header_widget_set_text (BudgieHeaderWidget* self, const gchar* value);
static void client_widget_update_art (ClientWidget* self, const gchar* uri);
static gchar* client_widget_get_meta_string (ClientWidget* self, const gchar* key, const gchar* fallback);
GHashTable* player_iface_get_metadata (PlayerIface* self);
static void client_widget_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


ClientImage* client_image_construct_from_pixbuf (GType object_type, GdkPixbuf* pbuf) {
	ClientImage * self = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	g_return_val_if_fail (pbuf != NULL, NULL);
	_tmp0_ = pbuf;
	self = (ClientImage*) g_object_new (object_type, "pixbuf", _tmp0_, NULL);
	return self;
}


ClientImage* client_image_new_from_pixbuf (GdkPixbuf* pbuf) {
	return client_image_construct_from_pixbuf (TYPE_CLIENT_IMAGE, pbuf);
}


ClientImage* client_image_construct_from_icon_name (GType object_type, const gchar* icon_name, GtkIconSize size) {
	ClientImage * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkIconSize _tmp1_ = 0;
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = icon_name;
	_tmp1_ = size;
	self = (ClientImage*) g_object_new (object_type, "icon-name", _tmp0_, "icon-size", _tmp1_, NULL);
	return self;
}


ClientImage* client_image_new_from_icon_name (const gchar* icon_name, GtkIconSize size) {
	return client_image_construct_from_icon_name (TYPE_CLIENT_IMAGE, icon_name, size);
}


ClientImage* client_image_construct (GType object_type) {
	ClientImage * self = NULL;
	self = (ClientImage*) g_object_new (object_type, NULL);
	return self;
}


ClientImage* client_image_new (void) {
	return client_image_construct (TYPE_CLIENT_IMAGE);
}


static void client_image_class_init (ClientImageClass * klass) {
	client_image_parent_class = g_type_class_peek_parent (klass);
}


static void client_image_instance_init (ClientImage * self) {
}


/**
 * A fancier Gtk.Image, which forces a fade-effect across the bottom of the image
 * making it easier to use/see the overlayed playback controls within the ClientWidget
 */
GType client_image_get_type (void) {
	static volatile gsize client_image_type_id__volatile = 0;
	if (g_once_init_enter (&client_image_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClientImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClientImage), 0, (GInstanceInitFunc) client_image_instance_init, NULL };
		GType client_image_type_id;
		client_image_type_id = g_type_register_static (gtk_image_get_type (), "ClientImage", &g_define_type_info, 0);
		g_once_init_leave (&client_image_type_id__volatile, client_image_type_id);
	}
	return client_image_type_id__volatile;
}


/**
     * Create a new ClientWidget
     *
     * @param client The underlying MprisClient instance to use
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ClientWidget* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->client);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda14_ (Block5Data* _data5_) {
	ClientWidget* self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	{
		MprisClient* _tmp0_ = NULL;
		PlayerIface* _tmp1_ = NULL;
		PlayerIface* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = _data5_->client;
		_tmp1_ = mpris_client_get_player (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = mpris_iface_get_can_quit ((MprisIface*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			MprisClient* _tmp5_ = NULL;
			PlayerIface* _tmp6_ = NULL;
			PlayerIface* _tmp7_ = NULL;
			_tmp5_ = _data5_->client;
			_tmp6_ = mpris_client_get_player (_tmp5_);
			_tmp7_ = _tmp6_;
			mpris_iface_quit ((MprisIface*) _tmp7_, NULL, NULL);
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		MprisClient* _tmp8_ = NULL;
		PlayerIface* _tmp9_ = NULL;
		PlayerIface* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _data5_->client;
		_tmp9_ = mpris_client_get_player (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MprisGui.vala:77: Error closing %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda14__budgie_header_widget_closed (BudgieHeaderWidget* _sender, gpointer self) {
	__lambda14_ (self);
}


static gboolean _client_widget_on_raise_player_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = client_widget_on_raise_player ((ClientWidget*) self);
	return result;
}


static void __lambda15_ (Block5Data* _data5_) {
	ClientWidget* self;
	MprisClient* _tmp0_ = NULL;
	PlayerIface* _tmp1_ = NULL;
	PlayerIface* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_can_go_previous (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		{
			MprisClient* _tmp5_ = NULL;
			PlayerIface* _tmp6_ = NULL;
			PlayerIface* _tmp7_ = NULL;
			_tmp5_ = _data5_->client;
			_tmp6_ = mpris_client_get_player (_tmp5_);
			_tmp7_ = _tmp6_;
			player_iface_previous (_tmp7_, NULL, NULL);
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("MprisGui.vala:134: Could not go to previous track: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally16:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda15_ (self);
}


static void __lambda16_ (Block5Data* _data5_) {
	ClientWidget* self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	{
		MprisClient* _tmp0_ = NULL;
		PlayerIface* _tmp1_ = NULL;
		PlayerIface* _tmp2_ = NULL;
		_tmp0_ = _data5_->client;
		_tmp1_ = mpris_client_get_player (_tmp0_);
		_tmp2_ = _tmp1_;
		player_iface_play_pause (_tmp2_, NULL, NULL);
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("MprisGui.vala:148: Could not play/pause: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda16_ (self);
}


static void __lambda17_ (Block5Data* _data5_) {
	ClientWidget* self;
	MprisClient* _tmp0_ = NULL;
	PlayerIface* _tmp1_ = NULL;
	PlayerIface* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_can_go_next (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		{
			MprisClient* _tmp5_ = NULL;
			PlayerIface* _tmp6_ = NULL;
			PlayerIface* _tmp7_ = NULL;
			_tmp5_ = _data5_->client;
			_tmp6_ = mpris_client_get_player (_tmp5_);
			_tmp7_ = _tmp6_;
			player_iface_next (_tmp7_, NULL, NULL);
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("MprisGui.vala:163: Could not go to next track: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally18:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void ___lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda17_ (self);
}


static gboolean ___lambda20_ (ClientWidget* self) {
	gboolean result = FALSE;
	client_widget_update_from_meta (self);
	result = FALSE;
	return result;
}


static gboolean ____lambda20__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda20_ ((ClientWidget*) self);
	return result;
}


static gboolean ____lambda21_ (ClientWidget* self) {
	gboolean result = FALSE;
	client_widget_update_play_status (self);
	result = FALSE;
	return result;
}


static gboolean _____lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda21_ ((ClientWidget*) self);
	return result;
}


static gboolean _____lambda22_ (ClientWidget* self) {
	gboolean result = FALSE;
	client_widget_update_controls (self);
	result = FALSE;
	return result;
}


static gboolean ______lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = _____lambda22_ ((ClientWidget*) self);
	return result;
}


static void ___lambda19_ (ClientWidget* self, const gchar* k, GVariant* v) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = k;
	if (g_strcmp0 (_tmp0_, "Metadata") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda20__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = k;
		if (g_strcmp0 (_tmp1_, "PlaybackStatus") == 0) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda21__gsource_func, g_object_ref (self), g_object_unref);
		} else {
			gboolean _tmp2_ = FALSE;
			const gchar* _tmp3_ = NULL;
			_tmp3_ = k;
			if (g_strcmp0 (_tmp3_, "CanGoNext") == 0) {
				_tmp2_ = TRUE;
			} else {
				const gchar* _tmp4_ = NULL;
				_tmp4_ = k;
				_tmp2_ = g_strcmp0 (_tmp4_, "CanGoPrevious") == 0;
			}
			if (_tmp2_) {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ______lambda22__gsource_func, g_object_ref (self), g_object_unref);
			}
		}
	}
}


static void ____lambda19__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	___lambda19_ ((ClientWidget*) self, (const gchar*) key, (GVariant*) value);
}


static void __lambda18_ (ClientWidget* self, const gchar* i, GHashTable* p, gchar** inv, int inv_length1) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (i != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = i;
	if (g_strcmp0 (_tmp0_, "org.mpris.MediaPlayer2.Player") == 0) {
		GHashTable* _tmp1_ = NULL;
		_tmp1_ = p;
		g_hash_table_foreach (_tmp1_, ____lambda19__gh_func, self);
	}
}


static void ___lambda18__dbus_prop_iface_properties_changed (DbusPropIface* _sender, const gchar* iface, GHashTable* changed, gchar** invalid, int invalid_length1, gpointer self) {
	__lambda18_ ((ClientWidget*) self, iface, changed, invalid, invalid_length1);
}


ClientWidget* client_widget_construct (GType object_type, MprisClient* client, gint width) {
	ClientWidget * self = NULL;
	Block5Data* _data5_;
	MprisClient* _tmp0_ = NULL;
	MprisClient* _tmp1_ = NULL;
	GtkWidget* row = NULL;
	gint _tmp2_ = 0;
	MprisClient* _tmp3_ = NULL;
	MprisClient* _tmp4_ = NULL;
	MprisClient* _tmp5_ = NULL;
	PlayerIface* _tmp6_ = NULL;
	PlayerIface* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	BudgieHeaderWidget* _tmp11_ = NULL;
	BudgieHeaderWidget* _tmp12_ = NULL;
	BudgieHeaderWidget* _tmp13_ = NULL;
	BudgieRavenExpander* _tmp14_ = NULL;
	BudgieRavenExpander* _tmp15_ = NULL;
	GtkBox* player_box = NULL;
	GtkBox* _tmp16_ = NULL;
	BudgieHeaderWidget* _tmp17_ = NULL;
	MprisClient* _tmp18_ = NULL;
	PlayerIface* _tmp19_ = NULL;
	PlayerIface* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	BudgieRavenExpander* _tmp23_ = NULL;
	BudgieHeaderWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	ClientImage* _tmp27_ = NULL;
	GtkImage* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	GtkEventBox* _tmp30_ = NULL;
	GtkEventBox* _tmp31_ = NULL;
	GtkImage* _tmp32_ = NULL;
	GtkEventBox* _tmp33_ = NULL;
	GtkOverlay* layout = NULL;
	GtkOverlay* _tmp34_ = NULL;
	GtkEventBox* _tmp35_ = NULL;
	GtkBox* top_box = NULL;
	GtkBox* _tmp36_ = NULL;
	GtkStyleContext* _tmp37_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkBox* controls = NULL;
	GtkBox* _tmp39_ = NULL;
	GtkWidget* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	gconstpointer _tmp42_ = NULL;
	GtkLabel* _tmp43_ = NULL;
	GtkWidget* _tmp44_ = NULL;
	GtkWidget* _tmp45_ = NULL;
	GtkWidget* _tmp46_ = NULL;
	gconstpointer _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkWidget* _tmp49_ = NULL;
	GtkWidget* _tmp50_ = NULL;
	GtkWidget* _tmp51_ = NULL;
	gconstpointer _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	GtkWidget* _tmp54_ = NULL;
	GtkButton* btn = NULL;
	GtkButton* _tmp55_ = NULL;
	GtkButton* _tmp56_ = NULL;
	GtkButton* _tmp57_ = NULL;
	GtkButton* _tmp58_ = NULL;
	GtkButton* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkButton* _tmp61_ = NULL;
	GtkStyleContext* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkButton* _tmp65_ = NULL;
	GtkButton* _tmp66_ = NULL;
	GtkButton* _tmp67_ = NULL;
	GtkButton* _tmp68_ = NULL;
	GtkButton* _tmp69_ = NULL;
	GtkStyleContext* _tmp70_ = NULL;
	GtkButton* _tmp71_ = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkButton* _tmp73_ = NULL;
	GtkButton* _tmp74_ = NULL;
	GtkButton* _tmp75_ = NULL;
	GtkButton* _tmp76_ = NULL;
	GtkButton* _tmp77_ = NULL;
	GtkButton* _tmp78_ = NULL;
	GtkStyleContext* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	MprisClient* _tmp81_ = NULL;
	DbusPropIface* _tmp82_ = NULL;
	DbusPropIface* _tmp83_ = NULL;
	GtkStyleContext* _tmp84_ = NULL;
	BudgieRavenExpander* _tmp85_ = NULL;
	BudgieRavenExpander* _tmp86_ = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = client;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->client);
	_data5_->client = _tmp1_;
	self = (ClientWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_data5_->self = g_object_ref (self);
	row = NULL;
	_tmp2_ = width;
	self->priv->our_width = _tmp2_;
	_tmp3_ = _data5_->client;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp4_;
	_tmp5_ = _data5_->client;
	_tmp6_ = mpris_client_get_player (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = mpris_iface_get_identity ((MprisIface*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = budgie_header_widget_new (_tmp10_, "media-playback-pause-symbolic", FALSE, NULL, NULL);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = self->priv->header;
	g_signal_connect_data (_tmp12_, "closed", (GCallback) ___lambda14__budgie_header_widget_closed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp13_ = self->priv->header;
	_tmp14_ = budgie_raven_expander_new (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->player_revealer);
	self->priv->player_revealer = _tmp14_;
	_tmp15_ = self->priv->player_revealer;
	budgie_raven_expander_set_expanded (_tmp15_, TRUE);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp16_);
	player_box = _tmp16_;
	_tmp17_ = self->priv->header;
	_tmp18_ = _data5_->client;
	_tmp19_ = mpris_client_get_player (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = mpris_iface_get_can_quit ((MprisIface*) _tmp20_);
	_tmp22_ = _tmp21_;
	budgie_header_widget_set_can_close (_tmp17_, _tmp22_);
	_tmp23_ = self->priv->player_revealer;
	_tmp24_ = self->priv->header;
	_tmp25_ = budgie_header_widget_get_can_close (_tmp24_);
	_tmp26_ = _tmp25_;
	budgie_raven_expander_set_expanded (_tmp23_, _tmp26_);
	_tmp27_ = client_image_new_from_icon_name ("emblem-music-symbolic", GTK_ICON_SIZE_INVALID);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = (GtkImage*) _tmp27_;
	_tmp28_ = self->priv->background;
	_tmp29_ = self->priv->our_width;
	gtk_image_set_pixel_size (_tmp28_, _tmp29_);
	_tmp30_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->background_wrap);
	self->priv->background_wrap = _tmp30_;
	_tmp31_ = self->priv->background_wrap;
	_tmp32_ = self->priv->background;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->background_wrap;
	g_signal_connect_object ((GtkWidget*) _tmp33_, "button-release-event", (GCallback) _client_widget_on_raise_player_gtk_widget_button_release_event, self, 0);
	_tmp34_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp34_);
	layout = _tmp34_;
	gtk_box_pack_start (player_box, (GtkWidget*) layout, TRUE, TRUE, (guint) 0);
	_tmp35_ = self->priv->background_wrap;
	gtk_container_add ((GtkContainer*) layout, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp36_);
	top_box = _tmp36_;
	gtk_widget_set_valign ((GtkWidget*) top_box, GTK_ALIGN_END);
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) top_box);
	gtk_style_context_add_class (_tmp37_, "raven-mpris");
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp38_);
	box = _tmp38_;
	g_object_set ((GtkWidget*) box, "margin", 6, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) box, 12);
	gtk_box_pack_start (top_box, (GtkWidget*) box, TRUE, TRUE, (guint) 0);
	_tmp39_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp39_);
	controls = _tmp39_;
	_tmp40_ = create_row ("Unknown Artist", "user-info-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp40_;
	_tmp41_ = row;
	_tmp42_ = g_object_get_data ((GObject*) _tmp41_, "label_item");
	_tmp43_ = _g_object_ref0 ((GtkLabel*) _tmp42_);
	_g_object_unref0 (self->priv->artist_label);
	self->priv->artist_label = _tmp43_;
	_tmp44_ = row;
	gtk_box_pack_start (box, _tmp44_, FALSE, FALSE, (guint) 0);
	_tmp45_ = create_row ("Unknown Title", "emblem-music-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp45_;
	_tmp46_ = row;
	_tmp47_ = g_object_get_data ((GObject*) _tmp46_, "label_item");
	_tmp48_ = _g_object_ref0 ((GtkLabel*) _tmp47_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp48_;
	_tmp49_ = row;
	gtk_box_pack_start (box, _tmp49_, FALSE, FALSE, (guint) 0);
	_tmp50_ = create_row ("Unknown Album", "media-optical-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp50_;
	_tmp51_ = row;
	_tmp52_ = g_object_get_data ((GObject*) _tmp51_, "label_item");
	_tmp53_ = _g_object_ref0 ((GtkLabel*) _tmp52_);
	_g_object_unref0 (self->priv->album_label);
	self->priv->album_label = _tmp53_;
	_tmp54_ = row;
	gtk_box_pack_start (box, _tmp54_, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) controls, FALSE, FALSE, (guint) 0);
	_tmp55_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-backward-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp55_);
	btn = _tmp55_;
	_tmp56_ = btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, FALSE);
	_tmp57_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp57_, FALSE);
	_tmp58_ = btn;
	_tmp59_ = _g_object_ref0 (_tmp58_);
	_g_object_unref0 (self->priv->prev_btn);
	self->priv->prev_btn = _tmp59_;
	_tmp60_ = btn;
	g_signal_connect_data (_tmp60_, "clicked", (GCallback) ___lambda15__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp61_ = btn;
	_tmp62_ = gtk_widget_get_style_context ((GtkWidget*) _tmp61_);
	gtk_style_context_add_class (_tmp62_, "flat");
	_tmp63_ = btn;
	gtk_box_pack_start (controls, (GtkWidget*) _tmp63_, FALSE, FALSE, (guint) 0);
	_tmp64_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-start-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (btn);
	btn = _tmp64_;
	_tmp65_ = btn;
	_tmp66_ = _g_object_ref0 (_tmp65_);
	_g_object_unref0 (self->priv->play_btn);
	self->priv->play_btn = _tmp66_;
	_tmp67_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp67_, FALSE);
	_tmp68_ = btn;
	g_signal_connect_data (_tmp68_, "clicked", (GCallback) ___lambda16__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp69_ = btn;
	_tmp70_ = gtk_widget_get_style_context ((GtkWidget*) _tmp69_);
	gtk_style_context_add_class (_tmp70_, "flat");
	_tmp71_ = btn;
	gtk_box_pack_start (controls, (GtkWidget*) _tmp71_, FALSE, FALSE, (guint) 0);
	_tmp72_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-forward-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp72_);
	_g_object_unref0 (btn);
	btn = _tmp72_;
	_tmp73_ = btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp73_, FALSE);
	_tmp74_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp74_, FALSE);
	_tmp75_ = btn;
	_tmp76_ = _g_object_ref0 (_tmp75_);
	_g_object_unref0 (self->priv->next_btn);
	self->priv->next_btn = _tmp76_;
	_tmp77_ = btn;
	g_signal_connect_data (_tmp77_, "clicked", (GCallback) ___lambda17__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp78_ = btn;
	_tmp79_ = gtk_widget_get_style_context ((GtkWidget*) _tmp78_);
	gtk_style_context_add_class (_tmp79_, "flat");
	_tmp80_ = btn;
	gtk_box_pack_start (controls, (GtkWidget*) _tmp80_, FALSE, FALSE, (guint) 0);
	gtk_widget_set_halign ((GtkWidget*) controls, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) controls, GTK_ALIGN_END);
	gtk_overlay_add_overlay (layout, (GtkWidget*) top_box);
	client_widget_update_from_meta (self);
	client_widget_update_play_status (self);
	client_widget_update_controls (self);
	_tmp81_ = _data5_->client;
	_tmp82_ = mpris_client_get_prop (_tmp81_);
	_tmp83_ = _tmp82_;
	g_signal_connect_object (_tmp83_, "properties-changed", (GCallback) ___lambda18__dbus_prop_iface_properties_changed, self, 0);
	_tmp84_ = gtk_widget_get_style_context ((GtkWidget*) player_box);
	gtk_style_context_add_class (_tmp84_, "raven-background");
	_tmp85_ = self->priv->player_revealer;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) player_box);
	_tmp86_ = self->priv->player_revealer;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp86_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (btn);
	_g_object_unref0 (controls);
	_g_object_unref0 (box);
	_g_object_unref0 (top_box);
	_g_object_unref0 (layout);
	_g_object_unref0 (player_box);
	_g_object_unref0 (row);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}


ClientWidget* client_widget_new (MprisClient* client, gint width) {
	return client_widget_construct (TYPE_CLIENT_WIDGET, client, width);
}


/**
     * You raise me up ...
     */
static gboolean client_widget_on_raise_player (ClientWidget* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	MprisClient* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->client;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		MprisClient* _tmp2_ = NULL;
		PlayerIface* _tmp3_ = NULL;
		PlayerIface* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = self->priv->client;
		_tmp3_ = mpris_client_get_player (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = mpris_iface_get_can_raise ((MprisIface*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	{
		MprisClient* _tmp7_ = NULL;
		PlayerIface* _tmp8_ = NULL;
		PlayerIface* _tmp9_ = NULL;
		_tmp7_ = self->priv->client;
		_tmp8_ = mpris_client_get_player (_tmp7_);
		_tmp9_ = _tmp8_;
		mpris_iface_raise ((MprisIface*) _tmp9_, NULL, NULL);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_message ("MprisGui.vala:219: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = GDK_EVENT_STOP;
	return result;
}


/**
     * Update play status based on player requirements
     */
static void client_widget_update_play_status (ClientWidget* self) {
	MprisClient* _tmp0_ = NULL;
	PlayerIface* _tmp1_ = NULL;
	PlayerIface* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_playback_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	g_free (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Playing")))) {
		switch (0) {
			default:
			{
				BudgieHeaderWidget* _tmp8_ = NULL;
				BudgieHeaderWidget* _tmp9_ = NULL;
				MprisClient* _tmp10_ = NULL;
				PlayerIface* _tmp11_ = NULL;
				PlayerIface* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				GtkButton* _tmp18_ = NULL;
				GtkWidget* _tmp19_ = NULL;
				_tmp8_ = self->priv->header;
				budgie_header_widget_set_icon_name (_tmp8_, "media-playback-start-symbolic");
				_tmp9_ = self->priv->header;
				_tmp10_ = self->priv->client;
				_tmp11_ = mpris_client_get_player (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = mpris_iface_get_identity ((MprisIface*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%s - Playing", _tmp15_);
				_tmp17_ = _tmp16_;
				budgie_header_widget_set_text (_tmp9_, _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
				_tmp18_ = self->priv->play_btn;
				_tmp19_ = gtk_button_get_image (_tmp18_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_image_get_type ()) ? ((GtkImage*) _tmp19_) : NULL, "media-playback-pause-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Paused")))) {
		switch (0) {
			default:
			{
				BudgieHeaderWidget* _tmp20_ = NULL;
				BudgieHeaderWidget* _tmp21_ = NULL;
				MprisClient* _tmp22_ = NULL;
				PlayerIface* _tmp23_ = NULL;
				PlayerIface* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				GtkButton* _tmp30_ = NULL;
				GtkWidget* _tmp31_ = NULL;
				_tmp20_ = self->priv->header;
				budgie_header_widget_set_icon_name (_tmp20_, "media-playback-pause-symbolic");
				_tmp21_ = self->priv->header;
				_tmp22_ = self->priv->client;
				_tmp23_ = mpris_client_get_player (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = mpris_iface_get_identity ((MprisIface*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup_printf ("%s - Paused", _tmp27_);
				_tmp29_ = _tmp28_;
				budgie_header_widget_set_text (_tmp21_, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_tmp30_ = self->priv->play_btn;
				_tmp31_ = gtk_button_get_image (_tmp30_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_image_get_type ()) ? ((GtkImage*) _tmp31_) : NULL, "media-playback-start-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				BudgieHeaderWidget* _tmp32_ = NULL;
				MprisClient* _tmp33_ = NULL;
				PlayerIface* _tmp34_ = NULL;
				PlayerIface* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				BudgieHeaderWidget* _tmp39_ = NULL;
				GtkButton* _tmp40_ = NULL;
				GtkWidget* _tmp41_ = NULL;
				_tmp32_ = self->priv->header;
				_tmp33_ = self->priv->client;
				_tmp34_ = mpris_client_get_player (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = mpris_iface_get_identity ((MprisIface*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = _tmp37_;
				budgie_header_widget_set_text (_tmp32_, _tmp38_);
				_g_free0 (_tmp38_);
				_tmp39_ = self->priv->header;
				budgie_header_widget_set_icon_name (_tmp39_, "media-playback-stop-symbolic");
				_tmp40_ = self->priv->play_btn;
				_tmp41_ = gtk_button_get_image (_tmp40_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, gtk_image_get_type ()) ? ((GtkImage*) _tmp41_) : NULL, "media-playback-start-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	}
}


/**
     * Update prev/next sensitivity based on player requirements
     */
static void client_widget_update_controls (ClientWidget* self) {
	GtkButton* _tmp0_ = NULL;
	MprisClient* _tmp1_ = NULL;
	PlayerIface* _tmp2_ = NULL;
	PlayerIface* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkButton* _tmp6_ = NULL;
	MprisClient* _tmp7_ = NULL;
	PlayerIface* _tmp8_ = NULL;
	PlayerIface* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_btn;
	_tmp1_ = self->priv->client;
	_tmp2_ = mpris_client_get_player (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = player_iface_get_can_go_previous (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp5_);
	_tmp6_ = self->priv->next_btn;
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = player_iface_get_can_go_next (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp11_);
}


/**
     * Utility, handle updating the album art
     */
static void client_widget_update_art (ClientWidget* self, const gchar* uri) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* fname = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "file://");
	if (!_tmp1_) {
		GtkImage* _tmp2_ = NULL;
		GtkImage* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->background;
		gtk_image_set_from_icon_name (_tmp2_, "emblem-music-symbolic", GTK_ICON_SIZE_INVALID);
		_tmp3_ = self->priv->background;
		_tmp4_ = self->priv->our_width;
		gtk_image_set_pixel_size (_tmp3_, _tmp4_);
		return;
	}
	_tmp5_ = uri;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "file://", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_tmp9_ = _tmp8_[1];
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	fname = _tmp11_;
	{
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GdkPixbuf* pbuf = NULL;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GdkPixbuf* _tmp17_ = NULL;
		GtkImage* _tmp18_ = NULL;
		GdkPixbuf* _tmp19_ = NULL;
		_tmp12_ = fname;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (self->priv->filename);
		self->priv->filename = _tmp13_;
		_tmp14_ = fname;
		_tmp15_ = self->priv->our_width;
		_tmp16_ = self->priv->our_width;
		_tmp17_ = gdk_pixbuf_new_from_file_at_size (_tmp14_, _tmp15_, _tmp16_, &_inner_error_);
		pbuf = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp18_ = self->priv->background;
		_tmp19_ = pbuf;
		gtk_image_set_from_pixbuf (_tmp18_, _tmp19_);
		_g_object_unref0 (pbuf);
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GtkImage* _tmp20_ = NULL;
		GtkImage* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = self->priv->background;
		gtk_image_set_from_icon_name (_tmp20_, "emblem-music-symbolic", GTK_ICON_SIZE_INVALID);
		_tmp21_ = self->priv->background;
		gtk_image_set_pixel_size (_tmp21_, BACKGROUND_SIZE);
		_g_error_free0 (e);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (fname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (fname);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gchar* client_widget_get_meta_string (ClientWidget* self, const gchar* key, const gchar* fallback) {
	gchar* result = NULL;
	MprisClient* _tmp0_ = NULL;
	PlayerIface* _tmp1_ = NULL;
	PlayerIface* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (fallback != NULL, NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_metadata (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = key;
	_tmp7_ = g_hash_table_contains (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_hash_table_unref0 (_tmp5_);
	if (_tmp8_) {
		GVariant* label = NULL;
		MprisClient* _tmp9_ = NULL;
		PlayerIface* _tmp10_ = NULL;
		PlayerIface* _tmp11_ = NULL;
		GHashTable* _tmp12_ = NULL;
		GHashTable* _tmp13_ = NULL;
		GHashTable* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		GVariant* _tmp17_ = NULL;
		GVariant* _tmp18_ = NULL;
		gchar* lab = NULL;
		const GVariantType* type = NULL;
		GVariant* _tmp19_ = NULL;
		const GVariantType* _tmp20_ = NULL;
		const GVariantType* _tmp21_ = NULL;
		const GVariantType* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_ = NULL;
		_tmp9_ = self->priv->client;
		_tmp10_ = mpris_client_get_player (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = player_iface_get_metadata (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = key;
		_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
		_tmp17_ = _g_variant_ref0 ((GVariant*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_hash_table_unref0 (_tmp14_);
		label = _tmp18_;
		lab = NULL;
		_tmp19_ = label;
		_tmp20_ = g_variant_get_type (_tmp19_);
		type = _tmp20_;
		_tmp21_ = type;
		_tmp22_ = G_VARIANT_TYPE_STRING;
		_tmp23_ = g_variant_type_is_subtype_of (_tmp21_, _tmp22_);
		if (_tmp23_) {
			GVariant* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			_tmp24_ = label;
			_tmp25_ = g_variant_get_string (_tmp24_, NULL);
			_tmp26_ = g_strdup (_tmp25_);
			_g_free0 (lab);
			lab = _tmp26_;
		} else {
			const GVariantType* _tmp27_ = NULL;
			const GVariantType* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp27_ = type;
			_tmp28_ = G_VARIANT_TYPE_STRING_ARRAY;
			_tmp29_ = g_variant_type_is_subtype_of (_tmp27_, _tmp28_);
			if (_tmp29_) {
				gchar** vals = NULL;
				GVariant* _tmp30_ = NULL;
				size_t _tmp31_;
				gchar** _tmp32_ = NULL;
				gint vals_length1 = 0;
				gint _vals_size_ = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				gchar* _tmp34_ = NULL;
				_tmp30_ = label;
				_tmp32_ = g_variant_dup_strv (_tmp30_, &_tmp31_);
				vals = _tmp32_;
				vals_length1 = _tmp31_;
				_vals_size_ = vals_length1;
				_tmp33_ = vals;
				_tmp33__length1 = vals_length1;
				_tmp34_ = _vala_g_strjoinv (", ", _tmp33_, _tmp33__length1);
				_g_free0 (lab);
				lab = _tmp34_;
				vals = (_vala_array_free (vals, vals_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_tmp36_ = lab;
		if (_tmp36_ != NULL) {
			const gchar* _tmp37_ = NULL;
			_tmp37_ = lab;
			_tmp35_ = g_strcmp0 (_tmp37_, "") != 0;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			result = lab;
			_g_variant_unref0 (label);
			return result;
		}
		_g_free0 (lab);
		_g_variant_unref0 (label);
	}
	_tmp38_ = fallback;
	_tmp39_ = g_strdup (_tmp38_);
	result = _tmp39_;
	return result;
}


/**
     * Update display info such as artist, the background image, etc.
     */
void client_widget_update_from_meta (ClientWidget* self) {
	MprisClient* _tmp0_ = NULL;
	PlayerIface* _tmp1_ = NULL;
	PlayerIface* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkLabel* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_metadata (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_hash_table_contains (_tmp5_, "mpris:artUrl");
	_tmp7_ = _tmp6_;
	_g_hash_table_unref0 (_tmp5_);
	if (_tmp7_) {
		gchar* url = NULL;
		MprisClient* _tmp8_ = NULL;
		PlayerIface* _tmp9_ = NULL;
		PlayerIface* _tmp10_ = NULL;
		GHashTable* _tmp11_ = NULL;
		GHashTable* _tmp12_ = NULL;
		GHashTable* _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp8_ = self->priv->client;
		_tmp9_ = mpris_client_get_player (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = player_iface_get_metadata (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = g_hash_table_lookup (_tmp13_, "mpris:artUrl");
		_tmp15_ = g_variant_get_string ((GVariant*) _tmp14_, NULL);
		_tmp16_ = g_strdup (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_hash_table_unref0 (_tmp13_);
		url = _tmp17_;
		_tmp18_ = url;
		client_widget_update_art (self, _tmp18_);
		_g_free0 (url);
	} else {
		GtkImage* _tmp19_ = NULL;
		GtkImage* _tmp20_ = NULL;
		_tmp19_ = self->priv->background;
		gtk_image_set_pixel_size (_tmp19_, BACKGROUND_SIZE);
		_tmp20_ = self->priv->background;
		gtk_image_set_from_icon_name (_tmp20_, "emblem-music-symbolic", GTK_ICON_SIZE_INVALID);
	}
	_tmp21_ = self->priv->title_label;
	_tmp22_ = client_widget_get_meta_string (self, "xesam:title", "Unknown Title");
	_tmp23_ = _tmp22_;
	gtk_label_set_text (_tmp21_, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = self->priv->album_label;
	_tmp25_ = client_widget_get_meta_string (self, "xesam:album", "Unknown Album");
	_tmp26_ = _tmp25_;
	gtk_label_set_text (_tmp24_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = self->priv->artist_label;
	_tmp28_ = client_widget_get_meta_string (self, "xesam:artist", "Unknown Artist");
	_tmp29_ = _tmp28_;
	gtk_label_set_text (_tmp27_, _tmp29_);
	_g_free0 (_tmp29_);
}


static void client_widget_class_init (ClientWidgetClass * klass) {
	client_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClientWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = client_widget_finalize;
}


static void client_widget_instance_init (ClientWidget * self) {
	gchar* _tmp0_ = NULL;
	self->priv = CLIENT_WIDGET_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->filename = _tmp0_;
	self->priv->our_width = BACKGROUND_SIZE;
	self->priv->header = NULL;
}


static void client_widget_finalize (GObject* obj) {
	ClientWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLIENT_WIDGET, ClientWidget);
	_g_object_unref0 (self->priv->player_revealer);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->background_wrap);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->artist_label);
	_g_object_unref0 (self->priv->album_label);
	_g_object_unref0 (self->priv->prev_btn);
	_g_object_unref0 (self->priv->play_btn);
	_g_object_unref0 (self->priv->next_btn);
	_g_free0 (self->priv->filename);
	_g_object_unref0 (self->priv->header);
	G_OBJECT_CLASS (client_widget_parent_class)->finalize (obj);
}


/**
 * A ClientWidget is simply used to control and display information in a two-way
 * fashion with an underlying MPRIS provider (MediaPlayer2)
 * It is "designed" to be self contained and added to a large UI, enabling multiple
 * MPRIS clients to be controlled with multiple widgets
 */
GType client_widget_get_type (void) {
	static volatile gsize client_widget_type_id__volatile = 0;
	if (g_once_init_enter (&client_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClientWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClientWidget), 0, (GInstanceInitFunc) client_widget_instance_init, NULL };
		GType client_widget_type_id;
		client_widget_type_id = g_type_register_static (gtk_box_get_type (), "ClientWidget", &g_define_type_info, 0);
		g_once_init_leave (&client_widget_type_id__volatile, client_widget_type_id);
	}
	return client_widget_type_id__volatile;
}


/**
 * Boring utility function, create an image/label row
 *
 * @param name Label to appear on row
 * @param icon Icon name to use, or NULL if using gicon
 * @param gicon A gicon to use, if not using icon
 *
 * @return A Gtk.Box with the boilerplate cruft out of the way
 */
GtkWidget* create_row (const gchar* name, const gchar* icon, GIcon* gicon) {
	GtkWidget* result = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkImage* img = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkImage* _tmp11_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkImage* _tmp18_ = NULL;
	GtkImage* _tmp19_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp2_ = icon;
	if (_tmp2_ == NULL) {
		GIcon* _tmp3_ = NULL;
		_tmp3_ = gicon;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GIcon* _tmp4_ = NULL;
		GtkImage* _tmp5_ = NULL;
		_tmp4_ = gicon;
		_tmp5_ = (GtkImage*) gtk_image_new_from_gicon (_tmp4_, GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (img);
		img = _tmp5_;
	} else {
		const gchar* _tmp6_ = NULL;
		GtkImage* _tmp7_ = NULL;
		_tmp6_ = icon;
		_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp6_, GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (img);
		img = _tmp7_;
	}
	_tmp8_ = img;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 8);
	_tmp9_ = img;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 8);
	_tmp10_ = box;
	_tmp11_ = img;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = name;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	label = _tmp13_;
	gtk_label_set_line_wrap (label, TRUE);
	gtk_label_set_line_wrap_mode (label, PANGO_WRAP_WORD);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	_tmp14_ = box;
	gtk_box_pack_start (_tmp14_, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp15_ = box;
	_tmp16_ = _g_object_ref0 (label);
	g_object_set_data_full ((GObject*) _tmp15_, "label_item", _tmp16_, g_object_unref);
	_tmp17_ = box;
	_tmp18_ = img;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	g_object_set_data_full ((GObject*) _tmp17_, "image_item", _tmp19_, g_object_unref);
	result = (GtkWidget*) box;
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



