/* notifications_view.c generated by valac 0.32.1, the Vala compiler
 * generated from notifications_view.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * Copyright 2014 Josh Klar <j@iv597.com> (original Budgie work, prior to Budgie 10)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
/** Undefined/reserved reasons. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <cairo.h>
#include <budgie-config.h>


#define BUDGIE_TYPE_NOTIFICATION_CLOSE_REASON (budgie_notification_close_reason_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER (budgie_notification_placeholder_get_type ())
#define BUDGIE_NOTIFICATION_PLACEHOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER, BudgieNotificationPlaceholder))
#define BUDGIE_NOTIFICATION_PLACEHOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER, BudgieNotificationPlaceholderClass))
#define BUDGIE_IS_NOTIFICATION_PLACEHOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER))
#define BUDGIE_IS_NOTIFICATION_PLACEHOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER))
#define BUDGIE_NOTIFICATION_PLACEHOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER, BudgieNotificationPlaceholderClass))

typedef struct _BudgieNotificationPlaceholder BudgieNotificationPlaceholder;
typedef struct _BudgieNotificationPlaceholderClass BudgieNotificationPlaceholderClass;
typedef struct _BudgieNotificationPlaceholderPrivate BudgieNotificationPlaceholderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_NOTIFICATION_CLONE (budgie_notification_clone_get_type ())
#define BUDGIE_NOTIFICATION_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NOTIFICATION_CLONE, BudgieNotificationClone))
#define BUDGIE_NOTIFICATION_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NOTIFICATION_CLONE, BudgieNotificationCloneClass))
#define BUDGIE_IS_NOTIFICATION_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NOTIFICATION_CLONE))
#define BUDGIE_IS_NOTIFICATION_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NOTIFICATION_CLONE))
#define BUDGIE_NOTIFICATION_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NOTIFICATION_CLONE, BudgieNotificationCloneClass))

typedef struct _BudgieNotificationClone BudgieNotificationClone;
typedef struct _BudgieNotificationCloneClass BudgieNotificationCloneClass;
typedef struct _BudgieNotificationClonePrivate BudgieNotificationClonePrivate;

#define BUDGIE_TYPE_NOTIFICATION_WINDOW (budgie_notification_window_get_type ())
#define BUDGIE_NOTIFICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindow))
#define BUDGIE_NOTIFICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindowClass))
#define BUDGIE_IS_NOTIFICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NOTIFICATION_WINDOW))
#define BUDGIE_IS_NOTIFICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NOTIFICATION_WINDOW))
#define BUDGIE_NOTIFICATION_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindowClass))

typedef struct _BudgieNotificationWindow BudgieNotificationWindow;
typedef struct _BudgieNotificationWindowClass BudgieNotificationWindowClass;
typedef struct _BudgieNotificationWindowPrivate BudgieNotificationWindowPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define BUDGIE_TYPE_NOTIFICATIONS_VIEW (budgie_notifications_view_get_type ())
#define BUDGIE_NOTIFICATIONS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsView))
#define BUDGIE_NOTIFICATIONS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsViewClass))
#define BUDGIE_IS_NOTIFICATIONS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NOTIFICATIONS_VIEW))
#define BUDGIE_IS_NOTIFICATIONS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NOTIFICATIONS_VIEW))
#define BUDGIE_NOTIFICATIONS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsViewClass))

typedef struct _BudgieNotificationsView BudgieNotificationsView;
typedef struct _BudgieNotificationsViewClass BudgieNotificationsViewClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _BudgieNotificationWindowSetFromImagePathData BudgieNotificationWindowSetFromImagePathData;
typedef struct _BudgieNotificationWindowSetFromNotifyData BudgieNotificationWindowSetFromNotifyData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _BudgieNotificationsViewPrivate BudgieNotificationsViewPrivate;

#define BUDGIE_TYPE_HEADER_WIDGET (budgie_header_widget_get_type ())
#define BUDGIE_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget))
#define BUDGIE_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))
#define BUDGIE_IS_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_IS_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_HEADER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))

typedef struct _BudgieHeaderWidget BudgieHeaderWidget;
typedef struct _BudgieHeaderWidgetClass BudgieHeaderWidgetClass;
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
typedef struct _BudgieNotificationsViewGetCapabilitiesData BudgieNotificationsViewGetCapabilitiesData;

#define BUDGIE_TYPE_RAVEN (budgie_raven_get_type ())
#define BUDGIE_RAVEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN, BudgieRaven))
#define BUDGIE_RAVEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN, BudgieRavenClass))
#define BUDGIE_IS_RAVEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN))
#define BUDGIE_IS_RAVEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN))
#define BUDGIE_RAVEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN, BudgieRavenClass))

typedef struct _BudgieRaven BudgieRaven;
typedef struct _BudgieRavenClass BudgieRavenClass;
typedef struct _Block2Data Block2Data;

typedef enum  {
	BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED = 1,
	BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED = 2,
	BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED = 3,
	BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED = 4
} BudgieNotificationCloseReason;

struct _BudgieNotificationPlaceholder {
	GtkBox parent_instance;
	BudgieNotificationPlaceholderPrivate * priv;
};

struct _BudgieNotificationPlaceholderClass {
	GtkBoxClass parent_class;
};

struct _BudgieNotificationClone {
	GtkGrid parent_instance;
	BudgieNotificationClonePrivate * priv;
};

struct _BudgieNotificationCloneClass {
	GtkGridClass parent_class;
};

struct _BudgieNotificationClonePrivate {
	GtkImage* image_icon;
	GtkLabel* label_title;
	GtkLabel* label_body;
	GtkLabel* label_timestamp;
};

struct _BudgieNotificationWindow {
	GtkWindow parent_instance;
	BudgieNotificationWindowPrivate * priv;
	guint32 id;
	gchar* title;
	gchar* body;
	GdkPixbuf* pixbuf;
	gint64 timestamp;
	gchar* app_name;
	gchar* category;
	gboolean did_interact;
};

struct _BudgieNotificationWindowClass {
	GtkWindowClass parent_class;
};

struct _BudgieNotificationWindowPrivate {
	BudgieNotificationsView* _owner;
	GtkImage* image_icon;
	GtkLabel* label_title;
	GtkLabel* label_body;
	GtkButton* button_close;
	GtkButtonBox* box_actions;
	gchar** img_search;
	gint img_search_length1;
	gint _img_search_size_;
	gchar** actions;
	gint actions_length1;
	gint _actions_size_;
	GHashTable* hints;
	gchar* image_path;
	guint expire_id;
	guint32 timeout;
	GCancellable* cancel;
	gboolean has_default_action;
};

struct _Block1Data {
	int _ref_count_;
	BudgieNotificationWindow* self;
	BudgieNotificationsView* owner;
};

struct _BudgieNotificationWindowSetFromImagePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieNotificationWindow* self;
	gchar* app_icon;
	gboolean result;
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	gchar* img_path;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** img_collection;
	gint img_collection_length1;
	gint _img_collection_size_;
	gint img_it;
	gchar* _tmp3_;
	gchar* img;
	GVariant* vimg_path;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* file;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	GFileInputStream* ins;
	GFile* _tmp25_;
	GFileInputStream* _tmp26_;
	GdkPixbuf* pbuf;
	GFileInputStream* _tmp27_;
	GCancellable* _tmp28_;
	GdkPixbuf* _tmp29_;
	GdkPixbuf* _tmp30_;
	GdkPixbuf* _tmp31_;
	GtkImage* _tmp32_;
	GdkPixbuf* _tmp33_;
	GError* e;
	GError * _inner_error_;
};

struct _BudgieNotificationWindowSetFromNotifyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieNotificationWindow* self;
	guint32 id;
	gchar* app_name;
	gchar* app_icon;
	gchar* summary;
	gchar* body;
	GHashTable* hints;
	gint32 expire_timeout;
	guint32 _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GCancellable* _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GDateTime* datetime;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gint64 _tmp9_;
	gboolean is_img;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean has_desktop;
	GHashTable* _tmp12_;
	gboolean _tmp13_;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	GtkImage* _tmp22_;
	const gchar* _tmp23_;
	GtkImage* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	gchar* did;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GDesktopAppInfo* app_info;
	const gchar* _tmp33_;
	GDesktopAppInfo* _tmp34_;
	GtkImage* _tmp35_;
	GDesktopAppInfo* _tmp36_;
	GIcon* _tmp37_;
	GError* e;
	GtkImage* _tmp38_;
	GtkImage* _tmp39_;
	GtkImage* _tmp40_;
	GHashTable* _tmp41_;
	gboolean _tmp42_;
	GHashTable* _tmp43_;
	gconstpointer _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	GtkLabel* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	GtkLabel* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	GtkLabel* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gint32 _tmp66_;
	GError * _inner_error_;
};

struct _BudgieNotificationsView {
	GtkBox parent_instance;
	BudgieNotificationsViewPrivate * priv;
};

struct _BudgieNotificationsViewClass {
	GtkBoxClass parent_class;
};

struct _BudgieNotificationsViewPrivate {
	gchar** caps;
	gint caps_length1;
	gint _caps_size_;
	GSettings* settings;
	BudgieHeaderWidget* header;
	GtkListBox* listbox;
	GQueue* queue;
	GHashTable* notifications;
	guint32 notif_id;
};

struct _BudgieNotificationsViewGetCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieNotificationsView* self;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
};

struct _Block2Data {
	int _ref_count_;
	BudgieNotificationsView* self;
	BudgieNotificationWindow* pack;
	gboolean configure;
	gchar** actions_copy;
	gint actions_copy_length1;
	gint _actions_copy_size_;
};


static gpointer budgie_notification_placeholder_parent_class = NULL;
static gpointer budgie_notification_clone_parent_class = NULL;
static gpointer budgie_notification_window_parent_class = NULL;
static gpointer budgie_notifications_view_parent_class = NULL;

#define BUDGIE_ROOT_KEY_SPAM_APPS "spam-apps"
#define BUDGIE_ROOT_KEY_SPAM_CATEGORIES "spam-categories"
GType budgie_notification_close_reason_get_type (void) G_GNUC_CONST;
gchar* budgie_safe_markup_string (const gchar* inp);
GType budgie_notification_placeholder_get_type (void) G_GNUC_CONST;
enum  {
	BUDGIE_NOTIFICATION_PLACEHOLDER_DUMMY_PROPERTY
};
BudgieNotificationPlaceholder* budgie_notification_placeholder_new (void);
BudgieNotificationPlaceholder* budgie_notification_placeholder_construct (GType object_type);
GType budgie_notification_clone_get_type (void) G_GNUC_CONST;
#define BUDGIE_NOTIFICATION_CLONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_NOTIFICATION_CLONE, BudgieNotificationClonePrivate))
enum  {
	BUDGIE_NOTIFICATION_CLONE_DUMMY_PROPERTY
};
GType budgie_notification_window_get_type (void) G_GNUC_CONST;
BudgieNotificationClone* budgie_notification_clone_new (BudgieNotificationWindow* target);
BudgieNotificationClone* budgie_notification_clone_construct (GType object_type, BudgieNotificationWindow* target);
static void budgie_notification_clone_finalize (GObject* obj);
GType budgie_notifications_view_get_type (void) G_GNUC_CONST;
guint budgie_notifications_view_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define BUDGIE_NOTIFICATION_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindowPrivate))
enum  {
	BUDGIE_NOTIFICATION_WINDOW_DUMMY_PROPERTY,
	BUDGIE_NOTIFICATION_WINDOW_OWNER
};
BudgieNotificationWindow* budgie_notification_window_new (BudgieNotificationsView* owner);
BudgieNotificationWindow* budgie_notification_window_construct (GType object_type, BudgieNotificationsView* owner);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
#define BUDGIE_NOTIFICATION_SIZE 400
static gboolean __lambda28_ (Block1Data* _data1_);
static gboolean ___lambda28__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void budgie_notification_window_action_handler (BudgieNotificationWindow* self, GtkButton* button);
BudgieNotificationsView* budgie_notification_window_get_owner (BudgieNotificationWindow* self);
static void budgie_notification_window_close_clicked (BudgieNotificationWindow* self);
static void _budgie_notification_window_close_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void budgie_notification_window_set_from_image_path_data_free (gpointer _data);
static void budgie_notification_window_set_from_image_path (BudgieNotificationWindow* self, const gchar* app_icon, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean budgie_notification_window_set_from_image_path_finish (BudgieNotificationWindow* self, GAsyncResult* _res_);
static gboolean budgie_notification_window_set_from_image_path_co (BudgieNotificationWindowSetFromImagePathData* _data_);
static void budgie_notification_window_set_from_image_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean budgie_notification_window_do_expire (BudgieNotificationWindow* self);
static void budgie_notification_window_set_from_notify_data_free (gpointer _data);
void budgie_notification_window_set_from_notify (BudgieNotificationWindow* self, guint32 id, const gchar* app_name, const gchar* app_icon, const gchar* summary, const gchar* body, GHashTable* hints, gint32 expire_timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
void budgie_notification_window_set_from_notify_finish (BudgieNotificationWindow* self, GAsyncResult* _res_);
static gboolean budgie_notification_window_set_from_notify_co (BudgieNotificationWindowSetFromNotifyData* _data_);
void budgie_notification_window_stop_decay (BudgieNotificationWindow* self);
static void budgie_notification_window_set_from_notify_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void budgie_notification_window_set_actions (BudgieNotificationWindow* self, gchar** actions, int actions_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _budgie_notification_window_action_handler_gtk_button_clicked (GtkButton* _sender, gpointer self);
void budgie_notification_window_begin_decay (BudgieNotificationWindow* self);
static gboolean _budgie_notification_window_do_expire_gsource_func (gpointer self);
static void budgie_notification_window_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void budgie_notification_window_real_get_preferred_width_for_height (GtkWidget* base, gint h, gint* min, gint* nat);
void budgie_notification_window_set_owner (BudgieNotificationWindow* self, BudgieNotificationsView* value);
static void budgie_notification_window_finalize (GObject* obj);
static void _vala_budgie_notification_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_notification_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BUDGIE_BUFFER_ZONE 10
#define BUDGIE_INITIAL_BUFFER_ZONE 45
GType budgie_header_widget_get_type (void) G_GNUC_CONST;
#define BUDGIE_NOTIFICATIONS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsViewPrivate))
enum  {
	BUDGIE_NOTIFICATIONS_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
static void budgie_notifications_view_get_capabilities_data_free (gpointer _data);
void budgie_notifications_view_get_capabilities (BudgieNotificationsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** budgie_notifications_view_get_capabilities_finish (BudgieNotificationsView* self, GAsyncResult* _res_, int* result_length1);
static gboolean budgie_notifications_view_get_capabilities_co (BudgieNotificationsViewGetCapabilitiesData* _data_);
static gchar** _vala_array_dup2 (gchar** self, int length);
void budgie_notifications_view_CloseNotification (BudgieNotificationsView* self, guint32 id);
static gboolean budgie_notifications_view_remove_notification (BudgieNotificationsView* self, guint32 id);
static void budgie_notifications_view_on_notification_closed (BudgieNotificationsView* self, BudgieNotificationWindow* widget, BudgieNotificationCloseReason reason);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
GType budgie_raven_get_type (void) G_GNUC_CONST;
BudgieRaven* budgie_raven_get_instance (void);
void budgie_raven_UnreadNotifications (BudgieRaven* self);
static void budgie_notifications_view_update_child_count (BudgieNotificationsView* self);
void budgie_raven_set_notification_count (BudgieRaven* self, guint count);
void budgie_header_widget_set_text (BudgieHeaderWidget* self, const gchar* value);
guint32 budgie_notifications_view_Notify (BudgieNotificationsView* self, const gchar* app_name, guint32 replaces_id, const gchar* app_icon, const gchar* summary, const gchar* body, gchar** actions, int actions_length1, GHashTable* hints, gint32 expire_timeout);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _budgie_notifications_view_on_notification_closed_budgie_notification_window_closed (BudgieNotificationWindow* _sender, BudgieNotificationCloseReason reason, gpointer self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void __lambda29_ (Block2Data* _data2_);
static void budgie_notifications_view_configure_window (BudgieNotificationsView* self, BudgieNotificationWindow* window);
static void ___lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void budgie_notifications_view_GetServerInformation (BudgieNotificationsView* self, gchar** name, gchar** vendor, gchar** version, gchar** spec_version);
static void budgie_notifications_view_clear_all (BudgieNotificationsView* self);
void budgie_raven_ReadNotifications (BudgieRaven* self);
BudgieNotificationsView* budgie_notifications_view_new (void);
BudgieNotificationsView* budgie_notifications_view_construct (GType object_type);
BudgieHeaderWidget* budgie_header_widget_new (const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
BudgieHeaderWidget* budgie_header_widget_construct (GType object_type, const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
static void _budgie_notifications_view_clear_all_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void budgie_notifications_view_serve_dbus (BudgieNotificationsView* self);
static void budgie_notifications_view_on_bus_acquired (BudgieNotificationsView* self, GDBusConnection* conn);
static void _budgie_notifications_view_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void budgie_notifications_view_finalize (GObject* obj);
static void _dbus_budgie_notifications_view_get_capabilities (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_view_get_capabilities_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_budgie_notifications_view_CloseNotification (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_view_Notify (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_notifications_view_GetServerInformation (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_notifications_view_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_notifications_view_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_notifications_view_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_budgie_notifications_view_notification_closed (GObject* _sender, guint32 id, guint32 reason, gpointer* _data);
static void _dbus_budgie_notifications_view_action_invoked (GObject* _sender, guint32 id, const gchar* action_key, gpointer* _data);
static void _budgie_notifications_view_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_get_capabilities_result = {-1, "result", "as"};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_get_capabilities_in[] = {NULL};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_get_capabilities_out[] = {&_budgie_notifications_view_dbus_arg_info_get_capabilities_result, NULL};
static const GDBusMethodInfo _budgie_notifications_view_dbus_method_info_get_capabilities = {-1, "GetCapabilities", (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_get_capabilities_in), (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_get_capabilities_out)};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_CloseNotification_id = {-1, "id", "u"};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_CloseNotification_in[] = {&_budgie_notifications_view_dbus_arg_info_CloseNotification_id, NULL};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_CloseNotification_out[] = {NULL};
static const GDBusMethodInfo _budgie_notifications_view_dbus_method_info_CloseNotification = {-1, "CloseNotification", (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_CloseNotification_in), (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_CloseNotification_out)};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_app_name = {-1, "app_name", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_replaces_id = {-1, "replaces_id", "u"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_app_icon = {-1, "app_icon", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_summary = {-1, "summary", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_body = {-1, "body", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_actions = {-1, "actions", "as"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_expire_timeout = {-1, "expire_timeout", "i"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_Notify_result = {-1, "result", "u"};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_Notify_in[] = {&_budgie_notifications_view_dbus_arg_info_Notify_app_name, &_budgie_notifications_view_dbus_arg_info_Notify_replaces_id, &_budgie_notifications_view_dbus_arg_info_Notify_app_icon, &_budgie_notifications_view_dbus_arg_info_Notify_summary, &_budgie_notifications_view_dbus_arg_info_Notify_body, &_budgie_notifications_view_dbus_arg_info_Notify_actions, &_budgie_notifications_view_dbus_arg_info_Notify_hints, &_budgie_notifications_view_dbus_arg_info_Notify_expire_timeout, NULL};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_Notify_out[] = {&_budgie_notifications_view_dbus_arg_info_Notify_result, NULL};
static const GDBusMethodInfo _budgie_notifications_view_dbus_method_info_Notify = {-1, "Notify", (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_Notify_in), (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_Notify_out)};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_GetServerInformation_name = {-1, "name", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_GetServerInformation_vendor = {-1, "vendor", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_GetServerInformation_version = {-1, "version", "s"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_GetServerInformation_spec_version = {-1, "spec_version", "s"};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_GetServerInformation_in[] = {NULL};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_GetServerInformation_out[] = {&_budgie_notifications_view_dbus_arg_info_GetServerInformation_name, &_budgie_notifications_view_dbus_arg_info_GetServerInformation_vendor, &_budgie_notifications_view_dbus_arg_info_GetServerInformation_version, &_budgie_notifications_view_dbus_arg_info_GetServerInformation_spec_version, NULL};
static const GDBusMethodInfo _budgie_notifications_view_dbus_method_info_GetServerInformation = {-1, "GetServerInformation", (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_GetServerInformation_in), (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_GetServerInformation_out)};
static const GDBusMethodInfo * const _budgie_notifications_view_dbus_method_info[] = {&_budgie_notifications_view_dbus_method_info_get_capabilities, &_budgie_notifications_view_dbus_method_info_CloseNotification, &_budgie_notifications_view_dbus_method_info_Notify, &_budgie_notifications_view_dbus_method_info_GetServerInformation, NULL};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_notification_closed_id = {-1, "id", "u"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_notification_closed_reason = {-1, "reason", "u"};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_notification_closed[] = {&_budgie_notifications_view_dbus_arg_info_notification_closed_id, &_budgie_notifications_view_dbus_arg_info_notification_closed_reason, NULL};
static const GDBusSignalInfo _budgie_notifications_view_dbus_signal_info_notification_closed = {-1, "NotificationClosed", (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_notification_closed)};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_action_invoked_id = {-1, "id", "u"};
static const GDBusArgInfo _budgie_notifications_view_dbus_arg_info_action_invoked_action_key = {-1, "action_key", "s"};
static const GDBusArgInfo * const _budgie_notifications_view_dbus_arg_info_action_invoked[] = {&_budgie_notifications_view_dbus_arg_info_action_invoked_id, &_budgie_notifications_view_dbus_arg_info_action_invoked_action_key, NULL};
static const GDBusSignalInfo _budgie_notifications_view_dbus_signal_info_action_invoked = {-1, "ActionInvoked", (GDBusArgInfo **) (&_budgie_notifications_view_dbus_arg_info_action_invoked)};
static const GDBusSignalInfo * const _budgie_notifications_view_dbus_signal_info[] = {&_budgie_notifications_view_dbus_signal_info_notification_closed, &_budgie_notifications_view_dbus_signal_info_action_invoked, NULL};
static const GDBusPropertyInfo * const _budgie_notifications_view_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_notifications_view_dbus_interface_info = {-1, "org.freedesktop.Notifications", (GDBusMethodInfo **) (&_budgie_notifications_view_dbus_method_info), (GDBusSignalInfo **) (&_budgie_notifications_view_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_notifications_view_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_notifications_view_dbus_interface_vtable = {budgie_notifications_view_dbus_interface_method_call, budgie_notifications_view_dbus_interface_get_property, budgie_notifications_view_dbus_interface_set_property};

GType budgie_notification_close_reason_get_type (void) {
	static volatile gsize budgie_notification_close_reason_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_notification_close_reason_type_id__volatile)) {
		static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED, "BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED", "expired"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED, "BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED", "dismissed"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED, "BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED", "closed"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED, "BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED", "undefined"}, {0, NULL, NULL}};
		GType budgie_notification_close_reason_type_id;
		budgie_notification_close_reason_type_id = g_enum_register_static ("BudgieNotificationCloseReason", values);
		g_once_init_leave (&budgie_notification_close_reason_type_id__volatile, budgie_notification_close_reason_type_id);
	}
	return budgie_notification_close_reason_type_id__volatile;
}


/**
 * We only want to make the input safe, we still need actual markup
 * support, so markup_escape won't be useful here.
 */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* budgie_safe_markup_string (const gchar* inp) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (inp != NULL, NULL);
	_tmp0_ = inp;
	_tmp1_ = string_replace (_tmp0_, "&", "&amp;");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "'", "&apos;");
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "\"", "&quot;");
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}


BudgieNotificationPlaceholder* budgie_notification_placeholder_construct (GType object_type) {
	BudgieNotificationPlaceholder * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	self = (BudgieNotificationPlaceholder*) g_object_new (object_type, "spacing", 6, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "dim-label");
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("notification-alert-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	gtk_image_set_pixel_size (image, 64);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) image, FALSE, FALSE, (guint) 6);
	_tmp2_ = _ ("Nothing to see here");
	_tmp3_ = g_strdup_printf ("<big>%s</big>", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	label = _tmp6_;
	gtk_label_set_use_markup (label, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	return self;
}


BudgieNotificationPlaceholder* budgie_notification_placeholder_new (void) {
	return budgie_notification_placeholder_construct (BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER);
}


static void budgie_notification_placeholder_class_init (BudgieNotificationPlaceholderClass * klass) {
	budgie_notification_placeholder_parent_class = g_type_class_peek_parent (klass);
}


static void budgie_notification_placeholder_instance_init (BudgieNotificationPlaceholder * self) {
}


/**
 * Simple placeholder to use when there are no notifications
 */
GType budgie_notification_placeholder_get_type (void) {
	static volatile gsize budgie_notification_placeholder_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_notification_placeholder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationPlaceholderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_placeholder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationPlaceholder), 0, (GInstanceInitFunc) budgie_notification_placeholder_instance_init, NULL };
		GType budgie_notification_placeholder_type_id;
		budgie_notification_placeholder_type_id = g_type_register_static (gtk_box_get_type (), "BudgieNotificationPlaceholder", &g_define_type_info, 0);
		g_once_init_leave (&budgie_notification_placeholder_type_id__volatile, budgie_notification_placeholder_type_id);
	}
	return budgie_notification_placeholder_type_id__volatile;
}


BudgieNotificationClone* budgie_notification_clone_construct (GType object_type, BudgieNotificationWindow* target) {
	BudgieNotificationClone * self = NULL;
	BudgieNotificationWindow* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	BudgieNotificationWindow* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	BudgieNotificationWindow* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GDateTime* date = NULL;
	BudgieNotificationWindow* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	GDateTime* _tmp24_ = NULL;
	GSettings* gnome_settings = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* clock_format = NULL;
	GSettings* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	self = (BudgieNotificationClone*) g_object_new (object_type, NULL);
	_tmp0_ = target;
	_tmp1_ = _tmp0_->pixbuf;
	if (_tmp1_ != NULL) {
		GdkPixbuf* scaled_pixbuf = NULL;
		BudgieNotificationWindow* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GtkImage* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		_tmp2_ = target;
		_tmp3_ = _tmp2_->pixbuf;
		_tmp4_ = gdk_pixbuf_scale_simple (_tmp3_, 32, 32, GDK_INTERP_NEAREST);
		scaled_pixbuf = _tmp4_;
		_tmp5_ = self->priv->image_icon;
		_tmp6_ = scaled_pixbuf;
		gtk_image_set_from_pixbuf (_tmp5_, _tmp6_);
		_g_object_unref0 (scaled_pixbuf);
	} else {
		GtkImage* _tmp7_ = NULL;
		BudgieNotificationWindow* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GtkImage* _tmp11_ = NULL;
		_tmp7_ = self->priv->image_icon;
		_tmp8_ = target;
		_tmp9_ = gtk_window_get_icon_name ((GtkWindow*) _tmp8_);
		_tmp10_ = _tmp9_;
		gtk_image_set_from_icon_name (_tmp7_, _tmp10_, GTK_ICON_SIZE_INVALID);
		_tmp11_ = self->priv->image_icon;
		gtk_image_set_pixel_size (_tmp11_, 32);
	}
	_tmp12_ = self->priv->label_title;
	_tmp13_ = target;
	_tmp14_ = _tmp13_->title;
	_tmp15_ = budgie_safe_markup_string (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (_tmp12_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = self->priv->label_body;
	_tmp18_ = target;
	_tmp19_ = _tmp18_->body;
	_tmp20_ = budgie_safe_markup_string (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp17_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = target;
	_tmp23_ = _tmp22_->timestamp;
	_tmp24_ = g_date_time_new_from_unix_local (_tmp23_);
	date = _tmp24_;
	_tmp25_ = g_settings_new ("org.gnome.desktop.interface");
	gnome_settings = _tmp25_;
	_tmp26_ = gnome_settings;
	_tmp27_ = g_settings_get_string (_tmp26_, "clock-format");
	clock_format = _tmp27_;
	_tmp29_ = clock_format;
	if (g_strcmp0 (_tmp29_, "12h") == 0) {
		GDateTime* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		_tmp30_ = date;
		_tmp31_ = g_date_time_format (_tmp30_, "%l:%M %p");
		_g_free0 (_tmp28_);
		_tmp28_ = _tmp31_;
	} else {
		GDateTime* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp32_ = date;
		_tmp33_ = g_date_time_format (_tmp32_, "%H:%M");
		_g_free0 (_tmp28_);
		_tmp28_ = _tmp33_;
	}
	_tmp34_ = g_strdup (_tmp28_);
	_g_free0 (clock_format);
	clock_format = _tmp34_;
	_tmp35_ = self->priv->label_timestamp;
	_tmp36_ = clock_format;
	gtk_label_set_text (_tmp35_, _tmp36_);
	_g_free0 (_tmp28_);
	_g_free0 (clock_format);
	_g_object_unref0 (gnome_settings);
	_g_date_time_unref0 (date);
	return self;
}


BudgieNotificationClone* budgie_notification_clone_new (BudgieNotificationWindow* target) {
	return budgie_notification_clone_construct (BUDGIE_TYPE_NOTIFICATION_CLONE, target);
}


static void budgie_notification_clone_class_init (BudgieNotificationCloneClass * klass) {
	gint BudgieNotificationClone_private_offset;
	budgie_notification_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieNotificationClonePrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_notification_clone_finalize;
	BudgieNotificationClone_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/raven/notification_clone.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, BudgieNotificationClone_private_offset + G_STRUCT_OFFSET (BudgieNotificationClonePrivate, image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_title", FALSE, BudgieNotificationClone_private_offset + G_STRUCT_OFFSET (BudgieNotificationClonePrivate, label_title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_body", FALSE, BudgieNotificationClone_private_offset + G_STRUCT_OFFSET (BudgieNotificationClonePrivate, label_body));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_timestamp", FALSE, BudgieNotificationClone_private_offset + G_STRUCT_OFFSET (BudgieNotificationClonePrivate, label_timestamp));
}


static void budgie_notification_clone_instance_init (BudgieNotificationClone * self) {
	self->priv = BUDGIE_NOTIFICATION_CLONE_GET_PRIVATE (self);
	self->priv->image_icon = NULL;
	self->priv->label_title = NULL;
	self->priv->label_body = NULL;
	self->priv->label_timestamp = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void budgie_notification_clone_finalize (GObject* obj) {
	BudgieNotificationClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION_CLONE, BudgieNotificationClone);
	_g_object_unref0 (self->priv->image_icon);
	_g_object_unref0 (self->priv->label_title);
	_g_object_unref0 (self->priv->label_body);
	_g_object_unref0 (self->priv->label_timestamp);
	G_OBJECT_CLASS (budgie_notification_clone_parent_class)->finalize (obj);
}


GType budgie_notification_clone_get_type (void) {
	static volatile gsize budgie_notification_clone_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_notification_clone_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationClone), 0, (GInstanceInitFunc) budgie_notification_clone_instance_init, NULL };
		GType budgie_notification_clone_type_id;
		budgie_notification_clone_type_id = g_type_register_static (gtk_grid_get_type (), "BudgieNotificationClone", &g_define_type_info, 0);
		g_once_init_leave (&budgie_notification_clone_type_id__volatile, budgie_notification_clone_type_id);
	}
	return budgie_notification_clone_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieNotificationWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->owner);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda28_ (Block1Data* _data1_) {
	BudgieNotificationWindow* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	BudgieNotificationsView* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
	self = _data1_->self;
	_tmp0_ = self->priv->has_default_action;
	if (!_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	self->did_interact = TRUE;
	_tmp1_ = _data1_->owner;
	_tmp2_ = self->id;
	g_signal_emit_by_name (_tmp1_, "action-invoked", _tmp2_, "default");
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda28__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda28_ (self);
	return result;
}


BudgieNotificationWindow* budgie_notification_window_construct (GType object_type, BudgieNotificationsView* owner) {
	BudgieNotificationWindow * self = NULL;
	Block1Data* _data1_;
	BudgieNotificationsView* _tmp0_ = NULL;
	BudgieNotificationsView* _tmp1_ = NULL;
	BudgieNotificationsView* _tmp2_ = NULL;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp3_ = NULL;
	GdkScreen* _tmp4_ = NULL;
	GdkVisual* _tmp5_ = NULL;
	GdkVisual* _tmp6_ = NULL;
	GdkVisual* _tmp7_ = NULL;
	GCancellable* _tmp9_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = owner;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->owner);
	_data1_->owner = _tmp1_;
	_tmp2_ = _data1_->owner;
	self = (BudgieNotificationWindow*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION, "owner", _tmp2_, NULL);
	_data1_->self = g_object_ref (self);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_screen_get_rgba_visual (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	vis = _tmp6_;
	_tmp7_ = vis;
	if (_tmp7_ != NULL) {
		GdkVisual* _tmp8_ = NULL;
		_tmp8_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp8_);
	}
	_tmp9_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = _tmp9_;
	gtk_window_set_default_size ((GtkWindow*) self, BUDGIE_NOTIFICATION_SIZE, -1);
	g_signal_connect_data ((GtkWidget*) self, "button-release-event", (GCallback) ___lambda28__gtk_widget_button_release_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (vis);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


BudgieNotificationWindow* budgie_notification_window_new (BudgieNotificationsView* owner) {
	return budgie_notification_window_construct (BUDGIE_TYPE_NOTIFICATION_WINDOW, owner);
}


static void budgie_notification_window_action_handler (BudgieNotificationWindow* self, GtkButton* button) {
	gchar* action_id = NULL;
	GtkButton* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	BudgieNotificationsView* _tmp4_ = NULL;
	guint32 _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = button;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "action_id");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	action_id = _tmp2_;
	_tmp3_ = action_id;
	if (_tmp3_ == NULL) {
		_g_free0 (action_id);
		return;
	}
	self->did_interact = TRUE;
	_tmp4_ = self->priv->_owner;
	_tmp5_ = self->id;
	_tmp6_ = action_id;
	g_signal_emit_by_name (_tmp4_, "action-invoked", _tmp5_, _tmp6_);
	_g_free0 (action_id);
}


static void budgie_notification_window_close_clicked (BudgieNotificationWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "closed", BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED);
}


static void _budgie_notification_window_close_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_notification_window_close_clicked ((BudgieNotificationWindow*) self);
}


static void budgie_notification_window_set_from_image_path_data_free (gpointer _data) {
	BudgieNotificationWindowSetFromImagePathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->app_icon);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieNotificationWindowSetFromImagePathData, _data_);
}


static void budgie_notification_window_set_from_image_path (BudgieNotificationWindow* self, const gchar* app_icon, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieNotificationWindowSetFromImagePathData* _data_;
	BudgieNotificationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (BudgieNotificationWindowSetFromImagePathData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_notification_window_set_from_image_path);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_notification_window_set_from_image_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = app_icon;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->app_icon);
	_data_->app_icon = _tmp2_;
	budgie_notification_window_set_from_image_path_co (_data_);
}


static gboolean budgie_notification_window_set_from_image_path_finish (BudgieNotificationWindow* self, GAsyncResult* _res_) {
	gboolean result;
	BudgieNotificationWindowSetFromImagePathData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void budgie_notification_window_set_from_image_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgieNotificationWindowSetFromImagePathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_notification_window_set_from_image_path_co (_data_);
}


static gboolean budgie_notification_window_set_from_image_path_co (BudgieNotificationWindowSetFromImagePathData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->cancel;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = g_cancellable_is_cancelled (_data_->_tmp0_);
	if (_data_->_tmp1_) {
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->img_path = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2__length1 = 0;
	_data_->_tmp2_ = _data_->self->priv->img_search;
	_data_->_tmp2__length1 = _data_->self->priv->img_search_length1;
	{
		_data_->img_collection_length1 = 0;
		_data_->_img_collection_size_ = 0;
		_data_->img_collection = _data_->_tmp2_;
		_data_->img_collection_length1 = _data_->_tmp2__length1;
		for (_data_->img_it = 0; _data_->img_it < _data_->_tmp2__length1; _data_->img_it = _data_->img_it + 1) {
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = g_strdup (_data_->img_collection[_data_->img_it]);
			_data_->img = _data_->_tmp3_;
			{
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->self->priv->hints;
				_data_->_tmp5_ = NULL;
				_data_->_tmp5_ = _data_->img;
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = g_hash_table_lookup (_data_->_tmp4_, _data_->_tmp5_);
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = _g_variant_ref0 ((GVariant*) _data_->_tmp6_);
				_data_->vimg_path = _data_->_tmp7_;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->vimg_path;
				if (_data_->_tmp8_ != NULL) {
					_data_->_tmp9_ = NULL;
					_data_->_tmp9_ = _data_->vimg_path;
					_data_->_tmp10_ = NULL;
					_data_->_tmp10_ = g_variant_get_string (_data_->_tmp9_, NULL);
					_data_->_tmp11_ = NULL;
					_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
					_g_free0 (_data_->img_path);
					_data_->img_path = _data_->_tmp11_;
					_g_variant_unref0 (_data_->vimg_path);
					_g_free0 (_data_->img);
					break;
				}
				_g_variant_unref0 (_data_->vimg_path);
				_g_free0 (_data_->img);
			}
		}
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->app_icon;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->app_icon;
		_data_->_tmp15_ = FALSE;
		_data_->_tmp15_ = string_contains (_data_->_tmp14_, "/");
		_data_->_tmp12_ = _data_->_tmp15_;
	} else {
		_data_->_tmp12_ = FALSE;
	}
	if (_data_->_tmp12_) {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->app_icon;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
		_g_free0 (_data_->img_path);
		_data_->img_path = _data_->_tmp17_;
	}
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->img_path;
	if (_data_->_tmp18_ == NULL) {
		_data_->result = FALSE;
		_g_free0 (_data_->img_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->img_path;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->self->priv->image_path;
	if (g_strcmp0 (_data_->_tmp19_, _data_->_tmp20_) == 0) {
		_data_->result = TRUE;
		_g_free0 (_data_->img_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->img_path;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
	_g_free0 (_data_->self->priv->image_path);
	_data_->self->priv->image_path = _data_->_tmp22_;
	{
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->self->priv->image_path;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = g_file_new_for_path (_data_->_tmp23_);
		_data_->file = _data_->_tmp24_;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->file;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp25_, G_PRIORITY_DEFAULT, NULL, budgie_notification_window_set_from_image_path_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = g_file_read_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error_);
		_data_->ins = _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->file);
			goto __catch2_g_error;
		}
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->ins;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->self->priv->cancel;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_at_scale_async ((GInputStream*) _data_->_tmp27_, 48, 48, TRUE, _data_->_tmp28_, budgie_notification_window_set_from_image_path_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->pbuf = _data_->_tmp29_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->ins);
			_g_object_unref0 (_data_->file);
			goto __catch2_g_error;
		}
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->pbuf;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
		_g_object_unref0 (_data_->self->pixbuf);
		_data_->self->pixbuf = _data_->_tmp31_;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->self->priv->image_icon;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->pbuf;
		gtk_image_set_from_pixbuf (_data_->_tmp32_, _data_->_tmp33_);
		_g_object_unref0 (_data_->pbuf);
		_g_object_unref0 (_data_->ins);
		_g_object_unref0 (_data_->file);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		_g_free0 (_data_->img_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->img_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = TRUE;
	_g_free0 (_data_->img_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->img_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean budgie_notification_window_do_expire (BudgieNotificationWindow* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "closed", BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED);
	result = FALSE;
	return result;
}


static void budgie_notification_window_set_from_notify_data_free (gpointer _data) {
	BudgieNotificationWindowSetFromNotifyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->app_name);
	_g_free0 (_data_->app_icon);
	_g_free0 (_data_->summary);
	_g_free0 (_data_->body);
	_g_hash_table_unref0 (_data_->hints);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieNotificationWindowSetFromNotifyData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void budgie_notification_window_set_from_notify (BudgieNotificationWindow* self, guint32 id, const gchar* app_name, const gchar* app_icon, const gchar* summary, const gchar* body, GHashTable* hints, gint32 expire_timeout, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieNotificationWindowSetFromNotifyData* _data_;
	BudgieNotificationWindow* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GHashTable* _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	gint32 _tmp12_ = 0;
	_data_ = g_slice_new0 (BudgieNotificationWindowSetFromNotifyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_notification_window_set_from_notify);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_notification_window_set_from_notify_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	_tmp2_ = app_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->app_name);
	_data_->app_name = _tmp3_;
	_tmp4_ = app_icon;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->app_icon);
	_data_->app_icon = _tmp5_;
	_tmp6_ = summary;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (_data_->summary);
	_data_->summary = _tmp7_;
	_tmp8_ = body;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_data_->body);
	_data_->body = _tmp9_;
	_tmp10_ = hints;
	_tmp11_ = _g_hash_table_ref0 (_tmp10_);
	_g_hash_table_unref0 (_data_->hints);
	_data_->hints = _tmp11_;
	_tmp12_ = expire_timeout;
	_data_->expire_timeout = _tmp12_;
	budgie_notification_window_set_from_notify_co (_data_);
}


void budgie_notification_window_set_from_notify_finish (BudgieNotificationWindow* self, GAsyncResult* _res_) {
	BudgieNotificationWindowSetFromNotifyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void budgie_notification_window_set_from_notify_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgieNotificationWindowSetFromNotifyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_notification_window_set_from_notify_co (_data_);
}


static gboolean budgie_notification_window_set_from_notify_co (BudgieNotificationWindowSetFromNotifyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0U;
	_data_->_tmp0_ = _data_->id;
	_data_->self->id = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->hints;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_hash_table_ref0 (_data_->_tmp1_);
	_g_hash_table_unref0 (_data_->self->priv->hints);
	_data_->self->priv->hints = _data_->_tmp2_;
	budgie_notification_window_stop_decay (_data_->self);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->cancel;
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = g_cancellable_is_cancelled (_data_->_tmp3_);
	if (!_data_->_tmp4_) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->cancel;
		g_cancellable_cancel (_data_->_tmp5_);
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->cancel;
	g_cancellable_reset (_data_->_tmp6_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_date_time_new_now_local ();
	_data_->datetime = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->datetime;
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = g_date_time_to_unix (_data_->_tmp8_);
	_data_->self->timestamp = _data_->_tmp9_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->app_icon;
	_data_->_state_ = 1;
	budgie_notification_window_set_from_image_path (_data_->self, _data_->_tmp10_, budgie_notification_window_set_from_notify_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = FALSE;
	_data_->_tmp11_ = budgie_notification_window_set_from_image_path_finish (_data_->self, _data_->_res_);
	_data_->is_img = _data_->_tmp11_;
	_data_->has_desktop = FALSE;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->hints;
	_data_->_tmp13_ = FALSE;
	_data_->_tmp13_ = g_hash_table_contains (_data_->_tmp12_, "desktop-entry");
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->hints;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_hash_table_lookup (_data_->_tmp14_, "desktop-entry");
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_variant_get_string ((GVariant*) _data_->_tmp15_, NULL);
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
		_g_free0 (_data_->self->app_name);
		_data_->self->app_name = _data_->_tmp17_;
		_data_->has_desktop = TRUE;
	} else {
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->app_name;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
		_g_free0 (_data_->self->app_name);
		_data_->self->app_name = _data_->_tmp19_;
	}
	_data_->_tmp20_ = FALSE;
	_data_->_tmp20_ = _data_->is_img;
	if (!_data_->_tmp20_) {
		_g_free0 (_data_->self->priv->image_path);
		_data_->self->priv->image_path = NULL;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->app_icon;
		if (g_strcmp0 (_data_->_tmp21_, "") != 0) {
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->self->priv->image_icon;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->app_icon;
			gtk_image_set_from_icon_name (_data_->_tmp22_, _data_->_tmp23_, GTK_ICON_SIZE_INVALID);
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->self->priv->image_icon;
			gtk_image_set_pixel_size (_data_->_tmp24_, 48);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->app_icon;
			gtk_window_set_icon_name ((GtkWindow*) _data_->self, _data_->_tmp25_);
		} else {
			_data_->_tmp26_ = FALSE;
			_data_->_tmp26_ = _data_->has_desktop;
			if (_data_->_tmp26_) {
				{
					_data_->_tmp27_ = NULL;
					_data_->_tmp27_ = _data_->self->app_name;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
					_data_->did = _data_->_tmp28_;
					_data_->_tmp29_ = NULL;
					_data_->_tmp29_ = _data_->did;
					_data_->_tmp30_ = FALSE;
					_data_->_tmp30_ = g_str_has_suffix (_data_->_tmp29_, ".desktop");
					if (!_data_->_tmp30_) {
						_data_->_tmp31_ = NULL;
						_data_->_tmp31_ = _data_->did;
						_data_->_tmp32_ = NULL;
						_data_->_tmp32_ = g_strdup_printf ("%s.desktop", _data_->_tmp31_);
						_g_free0 (_data_->did);
						_data_->did = _data_->_tmp32_;
					}
					_data_->_tmp33_ = NULL;
					_data_->_tmp33_ = _data_->did;
					_data_->_tmp34_ = NULL;
					_data_->_tmp34_ = g_desktop_app_info_new (_data_->_tmp33_);
					_data_->app_info = _data_->_tmp34_;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = _data_->self->priv->image_icon;
					_data_->_tmp36_ = NULL;
					_data_->_tmp36_ = _data_->app_info;
					_data_->_tmp37_ = NULL;
					_data_->_tmp37_ = g_app_info_get_icon ((GAppInfo*) _data_->_tmp36_);
					gtk_image_set_from_gicon (_data_->_tmp35_, _data_->_tmp37_, GTK_ICON_SIZE_INVALID);
					_g_object_unref0 (_data_->app_info);
					_g_free0 (_data_->did);
				}
				goto __finally3;
				__catch3_g_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = _data_->self->priv->image_icon;
					gtk_image_set_from_icon_name (_data_->_tmp38_, "mail-unread-symbolic", GTK_ICON_SIZE_INVALID);
					gtk_window_set_icon_name ((GtkWindow*) _data_->self, "mail-unread-symbolic");
					_g_error_free0 (_data_->e);
				}
				__finally3:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_date_time_unref0 (_data_->datetime);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			} else {
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->self->priv->image_icon;
				gtk_image_set_from_icon_name (_data_->_tmp39_, "mail-unread-symbolic", GTK_ICON_SIZE_INVALID);
				gtk_window_set_icon_name ((GtkWindow*) _data_->self, "mail-unread-symbolic");
			}
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->self->priv->image_icon;
			gtk_image_set_pixel_size (_data_->_tmp40_, 48);
		}
	}
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->hints;
	_data_->_tmp42_ = FALSE;
	_data_->_tmp42_ = g_hash_table_contains (_data_->_tmp41_, "category");
	if (_data_->_tmp42_) {
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = _data_->hints;
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = g_hash_table_lookup (_data_->_tmp43_, "category");
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = g_variant_get_string ((GVariant*) _data_->_tmp44_, NULL);
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = g_strdup (_data_->_tmp45_);
		_g_free0 (_data_->self->category);
		_data_->self->category = _data_->_tmp46_;
	}
	_data_->_tmp47_ = NULL;
	_data_->_tmp47_ = _data_->summary;
	if (g_strcmp0 (_data_->_tmp47_, "") == 0) {
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = _data_->self->priv->label_title;
		_data_->_tmp49_ = NULL;
		_data_->_tmp49_ = _data_->app_name;
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = budgie_safe_markup_string (_data_->_tmp49_);
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = _data_->_tmp50_;
		gtk_label_set_markup (_data_->_tmp48_, _data_->_tmp51_);
		_g_free0 (_data_->_tmp51_);
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _data_->app_name;
		_data_->_tmp53_ = NULL;
		_data_->_tmp53_ = g_strdup (_data_->_tmp52_);
		_g_free0 (_data_->self->title);
		_data_->self->title = _data_->_tmp53_;
	} else {
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->self->priv->label_title;
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->summary;
		_data_->_tmp56_ = NULL;
		_data_->_tmp56_ = budgie_safe_markup_string (_data_->_tmp55_);
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = _data_->_tmp56_;
		gtk_label_set_markup (_data_->_tmp54_, _data_->_tmp57_);
		_g_free0 (_data_->_tmp57_);
		_data_->_tmp58_ = NULL;
		_data_->_tmp58_ = _data_->summary;
		_data_->_tmp59_ = NULL;
		_data_->_tmp59_ = g_strdup (_data_->_tmp58_);
		_g_free0 (_data_->self->title);
		_data_->self->title = _data_->_tmp59_;
	}
	_data_->_tmp60_ = NULL;
	_data_->_tmp60_ = _data_->self->priv->label_body;
	_data_->_tmp61_ = NULL;
	_data_->_tmp61_ = _data_->body;
	_data_->_tmp62_ = NULL;
	_data_->_tmp62_ = budgie_safe_markup_string (_data_->_tmp61_);
	_data_->_tmp63_ = NULL;
	_data_->_tmp63_ = _data_->_tmp62_;
	gtk_label_set_markup (_data_->_tmp60_, _data_->_tmp63_);
	_g_free0 (_data_->_tmp63_);
	_data_->_tmp64_ = NULL;
	_data_->_tmp64_ = _data_->body;
	_data_->_tmp65_ = NULL;
	_data_->_tmp65_ = g_strdup (_data_->_tmp64_);
	_g_free0 (_data_->self->body);
	_data_->self->body = _data_->_tmp65_;
	_data_->_tmp66_ = 0;
	_data_->_tmp66_ = _data_->expire_timeout;
	_data_->self->priv->timeout = (guint32) _data_->_tmp66_;
	_g_date_time_unref0 (_data_->datetime);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _budgie_notification_window_action_handler_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_notification_window_action_handler ((BudgieNotificationWindow*) self, _sender);
}


void budgie_notification_window_set_actions (BudgieNotificationWindow* self, gchar** actions, int actions_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gboolean icons = FALSE;
	GHashTable* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	GtkButtonBox* _tmp23_ = NULL;
	GList* _tmp24_ = NULL;
	GtkButtonBox* _tmp68_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->actions;
	_tmp0__length1 = self->priv->actions_length1;
	_tmp1_ = actions;
	_tmp1__length1 = actions_length1;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = actions;
	_tmp2__length1 = actions_length1;
	_tmp3_ = self->priv->actions;
	_tmp3__length1 = self->priv->actions_length1;
	if (_tmp2__length1 == _tmp3__length1) {
		gboolean same = FALSE;
		gboolean _tmp14_ = FALSE;
		same = TRUE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gint _tmp6_ = 0;
					gchar** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					gchar** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					const gchar* _tmp10_ = NULL;
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					const gchar* _tmp13_ = NULL;
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = i;
					_tmp7_ = actions;
					_tmp7__length1 = actions_length1;
					if (!(_tmp6_ < _tmp7__length1)) {
						break;
					}
					_tmp8_ = actions;
					_tmp8__length1 = actions_length1;
					_tmp9_ = i;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp11_ = self->priv->actions;
					_tmp11__length1 = self->priv->actions_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					if (g_strcmp0 (_tmp10_, _tmp13_) != 0) {
						same = FALSE;
						break;
					}
				}
			}
		}
		_tmp14_ = same;
		if (_tmp14_) {
			return;
		}
	}
	_tmp15_ = actions;
	_tmp15__length1 = actions_length1;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup1 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp15__length1;
	self->priv->actions = (_vala_array_free (self->priv->actions, self->priv->actions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->actions = _tmp16_;
	self->priv->actions_length1 = _tmp16__length1;
	self->priv->_actions_size_ = self->priv->actions_length1;
	_tmp17_ = self->priv->hints;
	_tmp18_ = g_hash_table_contains (_tmp17_, "action-icons");
	icons = _tmp18_;
	_tmp20_ = actions;
	_tmp20__length1 = actions_length1;
	if (_tmp20_ == NULL) {
		_tmp19_ = TRUE;
	} else {
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		_tmp21_ = actions;
		_tmp21__length1 = actions_length1;
		_tmp19_ = _tmp21__length1 == 0;
	}
	if (_tmp19_) {
		return;
	}
	_tmp22_ = actions;
	_tmp22__length1 = actions_length1;
	if ((_tmp22__length1 % 2) != 0) {
		return;
	}
	_tmp23_ = self->priv->box_actions;
	_tmp24_ = gtk_container_get_children ((GtkContainer*) _tmp23_);
	{
		GList* kid_collection = NULL;
		GList* kid_it = NULL;
		kid_collection = _tmp24_;
		for (kid_it = kid_collection; kid_it != NULL; kid_it = kid_it->next) {
			GtkWidget* kid = NULL;
			kid = (GtkWidget*) kid_it->data;
			{
				gulong con_id = 0UL;
				GtkWidget* _tmp25_ = NULL;
				gconstpointer _tmp26_ = NULL;
				GtkWidget* _tmp27_ = NULL;
				gulong _tmp28_ = 0UL;
				GtkWidget* _tmp29_ = NULL;
				_tmp25_ = kid;
				_tmp26_ = g_object_get_data ((GObject*) _tmp25_, "action_con");
				con_id = (gulong) ((guintptr) _tmp26_);
				_tmp27_ = kid;
				_tmp28_ = con_id;
				g_signal_handler_disconnect (_tmp27_, _tmp28_);
				_tmp29_ = kid;
				gtk_widget_destroy (_tmp29_);
			}
		}
		_g_list_free0 (kid_collection);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_ = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				GtkButton* button = NULL;
				gchar* action = NULL;
				gchar** _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				gint _tmp35_ = 0;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* local = NULL;
				gchar** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gboolean _tmp43_ = FALSE;
				const gchar* _tmp44_ = NULL;
				gboolean _tmp46_ = FALSE;
				gulong con_id = 0UL;
				GtkButton* _tmp59_ = NULL;
				gulong _tmp60_ = 0UL;
				GtkButton* _tmp61_ = NULL;
				gulong _tmp62_ = 0UL;
				GtkButton* _tmp63_ = NULL;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				GtkButtonBox* _tmp66_ = NULL;
				GtkButton* _tmp67_ = NULL;
				if (!_tmp30_) {
					gint _tmp31_ = 0;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = actions;
				_tmp33__length1 = actions_length1;
				if (!(_tmp32_ < _tmp33__length1)) {
					break;
				}
				button = NULL;
				_tmp34_ = actions;
				_tmp34__length1 = actions_length1;
				_tmp35_ = i;
				_tmp36_ = _tmp34_[_tmp35_];
				_tmp37_ = g_strdup (_tmp36_);
				action = _tmp37_;
				_tmp38_ = actions;
				_tmp38__length1 = actions_length1;
				_tmp39_ = i;
				i = _tmp39_ + 1;
				_tmp40_ = i;
				_tmp41_ = _tmp38_[_tmp40_];
				_tmp42_ = g_strdup (_tmp41_);
				local = _tmp42_;
				_tmp44_ = action;
				if (g_strcmp0 (_tmp44_, "default") == 0) {
					const gchar* _tmp45_ = NULL;
					_tmp45_ = local;
					_tmp43_ = g_strcmp0 (_tmp45_, "") == 0;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					self->priv->has_default_action = TRUE;
					_g_free0 (local);
					_g_free0 (action);
					_g_object_unref0 (button);
					continue;
				}
				_tmp46_ = icons;
				if (_tmp46_) {
					const gchar* _tmp47_ = NULL;
					gboolean _tmp48_ = FALSE;
					_tmp47_ = action;
					_tmp48_ = g_str_has_suffix (_tmp47_, "-symbolic");
					if (!_tmp48_) {
						const gchar* _tmp49_ = NULL;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						GtkButton* _tmp52_ = NULL;
						_tmp49_ = action;
						_tmp50_ = g_strdup_printf ("%s-symbolic", _tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = (GtkButton*) gtk_button_new_from_icon_name (_tmp51_, GTK_ICON_SIZE_MENU);
						g_object_ref_sink (_tmp52_);
						_g_object_unref0 (button);
						button = _tmp52_;
						_g_free0 (_tmp51_);
					} else {
						const gchar* _tmp53_ = NULL;
						GtkButton* _tmp54_ = NULL;
						_tmp53_ = action;
						_tmp54_ = (GtkButton*) gtk_button_new_from_icon_name (_tmp53_, GTK_ICON_SIZE_MENU);
						g_object_ref_sink (_tmp54_);
						_g_object_unref0 (button);
						button = _tmp54_;
					}
				} else {
					const gchar* _tmp55_ = NULL;
					GtkButton* _tmp56_ = NULL;
					GtkButton* _tmp57_ = NULL;
					GtkButton* _tmp58_ = NULL;
					_tmp55_ = local;
					_tmp56_ = (GtkButton*) gtk_button_new_with_label (_tmp55_);
					g_object_ref_sink (_tmp56_);
					_g_object_unref0 (button);
					button = _tmp56_;
					_tmp57_ = button;
					gtk_widget_set_can_focus ((GtkWidget*) _tmp57_, FALSE);
					_tmp58_ = button;
					gtk_widget_set_can_default ((GtkWidget*) _tmp58_, FALSE);
				}
				_tmp59_ = button;
				_tmp60_ = g_signal_connect_object (_tmp59_, "clicked", (GCallback) _budgie_notification_window_action_handler_gtk_button_clicked, self, 0);
				con_id = _tmp60_;
				_tmp61_ = button;
				_tmp62_ = con_id;
				g_object_set_data_full ((GObject*) _tmp61_, "action_con", (gpointer) ((guintptr) _tmp62_), NULL);
				_tmp63_ = button;
				_tmp64_ = action;
				_tmp65_ = g_strdup (_tmp64_);
				g_object_set_data_full ((GObject*) _tmp63_, "action_id", _tmp65_, g_free);
				_tmp66_ = self->priv->box_actions;
				_tmp67_ = button;
				gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
				_g_free0 (local);
				_g_free0 (action);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp68_ = self->priv->box_actions;
	gtk_widget_show_all ((GtkWidget*) _tmp68_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean _budgie_notification_window_do_expire_gsource_func (gpointer self) {
	gboolean result;
	result = budgie_notification_window_do_expire ((BudgieNotificationWindow*) self);
	return result;
}


void budgie_notification_window_begin_decay (BudgieNotificationWindow* self) {
	guint32 _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timeout;
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp0_, _budgie_notification_window_do_expire_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->expire_id = _tmp1_;
}


void budgie_notification_window_stop_decay (BudgieNotificationWindow* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->expire_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->expire_id;
		g_source_remove (_tmp1_);
		self->priv->expire_id = (guint) 0;
	}
}


static void budgie_notification_window_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	BudgieNotificationWindow * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieNotificationWindow*) base;
	_vala_nat = BUDGIE_NOTIFICATION_SIZE;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void budgie_notification_window_real_get_preferred_width_for_height (GtkWidget* base, gint h, gint* min, gint* nat) {
	BudgieNotificationWindow * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieNotificationWindow*) base;
	_vala_nat = BUDGIE_NOTIFICATION_SIZE;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


BudgieNotificationsView* budgie_notification_window_get_owner (BudgieNotificationWindow* self) {
	BudgieNotificationsView* result;
	BudgieNotificationsView* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}


void budgie_notification_window_set_owner (BudgieNotificationWindow* self, BudgieNotificationsView* value) {
	BudgieNotificationsView* _tmp0_ = NULL;
	BudgieNotificationsView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_owner);
	self->priv->_owner = _tmp1_;
	g_object_notify ((GObject *) self, "owner");
}


static void budgie_notification_window_class_init (BudgieNotificationWindowClass * klass) {
	gint BudgieNotificationWindow_private_offset;
	budgie_notification_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieNotificationWindowPrivate));
	((GtkWidgetClass *) klass)->get_preferred_width = budgie_notification_window_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = budgie_notification_window_real_get_preferred_width_for_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notification_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notification_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_notification_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_WINDOW_OWNER, g_param_spec_object ("owner", "owner", "owner", BUDGIE_TYPE_NOTIFICATIONS_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	BudgieNotificationWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/raven/notification.ui");
	g_signal_new ("closed", BUDGIE_TYPE_NOTIFICATION_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, BUDGIE_TYPE_NOTIFICATION_CLOSE_REASON);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, BudgieNotificationWindow_private_offset + G_STRUCT_OFFSET (BudgieNotificationWindowPrivate, image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_title", FALSE, BudgieNotificationWindow_private_offset + G_STRUCT_OFFSET (BudgieNotificationWindowPrivate, label_title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_body", FALSE, BudgieNotificationWindow_private_offset + G_STRUCT_OFFSET (BudgieNotificationWindowPrivate, label_body));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_close", FALSE, BudgieNotificationWindow_private_offset + G_STRUCT_OFFSET (BudgieNotificationWindowPrivate, button_close));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "box_actions", FALSE, BudgieNotificationWindow_private_offset + G_STRUCT_OFFSET (BudgieNotificationWindowPrivate, box_actions));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "close_clicked", G_CALLBACK(_budgie_notification_window_close_clicked_gtk_button_clicked));
}


static void budgie_notification_window_instance_init (BudgieNotificationWindow * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	self->priv = BUDGIE_NOTIFICATION_WINDOW_GET_PRIVATE (self);
	self->priv->image_icon = NULL;
	self->priv->label_title = NULL;
	self->priv->label_body = NULL;
	self->priv->button_close = NULL;
	self->priv->box_actions = NULL;
	self->pixbuf = NULL;
	_tmp0_ = g_strdup ("image-path");
	_tmp1_ = g_strdup ("image_path");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->img_search = _tmp2_;
	self->priv->img_search_length1 = 2;
	self->priv->_img_search_size_ = self->priv->img_search_length1;
	self->priv->actions = NULL;
	self->priv->actions_length1 = 0;
	self->priv->_actions_size_ = self->priv->actions_length1;
	self->priv->hints = NULL;
	self->priv->image_path = NULL;
	self->priv->expire_id = (guint) 0;
	self->priv->timeout = (guint32) 0;
	self->category = NULL;
	self->did_interact = FALSE;
	self->priv->has_default_action = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void budgie_notification_window_finalize (GObject* obj) {
	BudgieNotificationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindow);
	_g_object_unref0 (self->priv->_owner);
	_g_object_unref0 (self->priv->image_icon);
	_g_object_unref0 (self->priv->label_title);
	_g_object_unref0 (self->priv->label_body);
	_g_object_unref0 (self->priv->button_close);
	_g_object_unref0 (self->priv->box_actions);
	_g_free0 (self->title);
	_g_free0 (self->body);
	_g_object_unref0 (self->pixbuf);
	_g_free0 (self->app_name);
	self->priv->img_search = (_vala_array_free (self->priv->img_search, self->priv->img_search_length1, (GDestroyNotify) g_free), NULL);
	self->priv->actions = (_vala_array_free (self->priv->actions, self->priv->actions_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (self->priv->hints);
	_g_free0 (self->priv->image_path);
	_g_object_unref0 (self->priv->cancel);
	_g_free0 (self->category);
	G_OBJECT_CLASS (budgie_notification_window_parent_class)->finalize (obj);
}


GType budgie_notification_window_get_type (void) {
	static volatile gsize budgie_notification_window_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_notification_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationWindow), 0, (GInstanceInitFunc) budgie_notification_window_instance_init, NULL };
		GType budgie_notification_window_type_id;
		budgie_notification_window_type_id = g_type_register_static (gtk_window_get_type (), "BudgieNotificationWindow", &g_define_type_info, 0);
		g_once_init_leave (&budgie_notification_window_type_id__volatile, budgie_notification_window_type_id);
	}
	return budgie_notification_window_type_id__volatile;
}


static void _vala_budgie_notification_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieNotificationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindow);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_WINDOW_OWNER:
		g_value_set_object (value, budgie_notification_window_get_owner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_notification_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieNotificationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION_WINDOW, BudgieNotificationWindow);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_WINDOW_OWNER:
		budgie_notification_window_set_owner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


static void budgie_notifications_view_get_capabilities_data_free (gpointer _data) {
	BudgieNotificationsViewGetCapabilitiesData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieNotificationsViewGetCapabilitiesData, _data_);
}


void budgie_notifications_view_get_capabilities (BudgieNotificationsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieNotificationsViewGetCapabilitiesData* _data_;
	BudgieNotificationsView* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BudgieNotificationsViewGetCapabilitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_notifications_view_get_capabilities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_notifications_view_get_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_notifications_view_get_capabilities_co (_data_);
}


gchar** budgie_notifications_view_get_capabilities_finish (BudgieNotificationsView* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	BudgieNotificationsViewGetCapabilitiesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean budgie_notifications_view_get_capabilities_co (BudgieNotificationsViewGetCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__length1 = 0;
	_data_->_tmp0_ = _data_->self->priv->caps;
	_data_->_tmp0__length1 = _data_->self->priv->caps_length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1__length1 = 0;
	_data_->_tmp1_ = (_data_->_tmp0_ != NULL) ? _vala_array_dup2 (_data_->_tmp0_, _data_->_tmp0__length1) : ((gpointer) _data_->_tmp0_);
	_data_->_tmp1__length1 = _data_->_tmp0__length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2__length1 = 0;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp2__length1 = _data_->_tmp1__length1;
	_data_->result_length1 = _data_->_tmp2__length1;
	_data_->result = _data_->_tmp2_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void budgie_notifications_view_CloseNotification (BudgieNotificationsView* self, guint32 id) {
	guint32 _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = id;
	_tmp1_ = budgie_notifications_view_remove_notification (self, _tmp0_);
	if (_tmp1_) {
		guint32 _tmp2_ = 0U;
		_tmp2_ = id;
		g_signal_emit_by_name (self, "notification-closed", _tmp2_, (guint32) BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED);
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void budgie_notifications_view_on_notification_closed (BudgieNotificationsView* self, BudgieNotificationWindow* widget, BudgieNotificationCloseReason reason) {
	gulong nid = 0UL;
	BudgieNotificationWindow* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	BudgieNotificationWindow* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	BudgieNotificationWindow* _tmp4_ = NULL;
	guint32 _tmp5_ = 0U;
	BudgieNotificationCloseReason _tmp6_ = 0;
	gchar** spam_apps = NULL;
	GSettings* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint spam_apps_length1 = 0;
	gint _spam_apps_size_ = 0;
	gchar** spam_categories = NULL;
	GSettings* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint spam_categories_length1 = 0;
	gint _spam_categories_size_ = 0;
	BudgieNotificationCloseReason _tmp13_ = 0;
	BudgieNotificationWindow* _tmp37_ = NULL;
	guint32 _tmp38_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "npack_id");
	nid = (gulong) ((guintptr) _tmp1_);
	_tmp2_ = widget;
	_tmp3_ = nid;
	g_signal_handler_disconnect (_tmp2_, _tmp3_);
	_tmp4_ = widget;
	_tmp5_ = _tmp4_->id;
	_tmp6_ = reason;
	g_signal_emit_by_name (self, "notification-closed", _tmp5_, (guint32) _tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp9_ = _tmp8_ = g_settings_get_strv (_tmp7_, BUDGIE_ROOT_KEY_SPAM_APPS);
	spam_apps = _tmp9_;
	spam_apps_length1 = _vala_array_length (_tmp8_);
	_spam_apps_size_ = spam_apps_length1;
	_tmp10_ = self->priv->settings;
	_tmp12_ = _tmp11_ = g_settings_get_strv (_tmp10_, BUDGIE_ROOT_KEY_SPAM_CATEGORIES);
	spam_categories = _tmp12_;
	spam_categories_length1 = _vala_array_length (_tmp11_);
	_spam_categories_size_ = spam_categories_length1;
	_tmp13_ = reason;
	if (_tmp13_ == BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		BudgieNotificationWindow* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = widget;
		_tmp18_ = _tmp17_->category;
		if (_tmp18_ != NULL) {
			BudgieNotificationWindow* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			_tmp19_ = widget;
			_tmp20_ = _tmp19_->category;
			_tmp21_ = spam_categories;
			_tmp21__length1 = spam_categories_length1;
			_tmp16_ = _vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_);
		} else {
			_tmp16_ = FALSE;
		}
		if (!_tmp16_) {
			gboolean _tmp22_ = FALSE;
			BudgieNotificationWindow* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = widget;
			_tmp24_ = _tmp23_->app_name;
			if (_tmp24_ != NULL) {
				BudgieNotificationWindow* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				_tmp25_ = widget;
				_tmp26_ = _tmp25_->app_name;
				_tmp27_ = spam_apps;
				_tmp27__length1 = spam_apps_length1;
				_tmp22_ = _vala_string_array_contains (_tmp27_, _tmp27__length1, _tmp26_);
			} else {
				_tmp22_ = FALSE;
			}
			_tmp15_ = !_tmp22_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			BudgieNotificationWindow* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp28_ = widget;
			_tmp29_ = _tmp28_->did_interact;
			_tmp14_ = !_tmp29_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			BudgieNotificationClone* clone = NULL;
			BudgieNotificationWindow* _tmp30_ = NULL;
			BudgieNotificationClone* _tmp31_ = NULL;
			BudgieNotificationClone* _tmp32_ = NULL;
			GtkListBox* _tmp33_ = NULL;
			BudgieNotificationClone* _tmp34_ = NULL;
			BudgieNotificationClone* _tmp35_ = NULL;
			BudgieRaven* _tmp36_ = NULL;
			_tmp30_ = widget;
			_tmp31_ = budgie_notification_clone_new (_tmp30_);
			g_object_ref_sink (_tmp31_);
			clone = _tmp31_;
			_tmp32_ = clone;
			gtk_widget_show_all ((GtkWidget*) _tmp32_);
			_tmp33_ = self->priv->listbox;
			_tmp34_ = clone;
			gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
			_tmp35_ = clone;
			gtk_widget_show_all ((GtkWidget*) _tmp35_);
			_tmp36_ = budgie_raven_get_instance ();
			budgie_raven_UnreadNotifications (_tmp36_);
			_g_object_unref0 (clone);
		}
	}
	budgie_notifications_view_update_child_count (self);
	_tmp37_ = widget;
	_tmp38_ = _tmp37_->id;
	budgie_notifications_view_remove_notification (self, _tmp38_);
	spam_categories = (_vala_array_free (spam_categories, spam_categories_length1, (GDestroyNotify) g_free), NULL);
	spam_apps = (_vala_array_free (spam_apps, spam_apps_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean budgie_notifications_view_remove_notification (BudgieNotificationsView* self, guint32 id) {
	gboolean result = FALSE;
	BudgieNotificationWindow* widget = NULL;
	GHashTable* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
	BudgieNotificationWindow* _tmp3_ = NULL;
	BudgieNotificationWindow* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	BudgieNotificationWindow* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	GQueue* _tmp8_ = NULL;
	BudgieNotificationWindow* _tmp9_ = NULL;
	BudgieNotificationWindow* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	widget = (BudgieNotificationWindow*) _tmp2_;
	_tmp3_ = widget;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp4_ = widget;
	budgie_notification_window_stop_decay (_tmp4_);
	_tmp5_ = self->priv->notifications;
	_tmp6_ = widget;
	_tmp7_ = _tmp6_->id;
	g_hash_table_remove (_tmp5_, (gpointer) ((guintptr) _tmp7_));
	_tmp8_ = self->priv->queue;
	_tmp9_ = widget;
	g_queue_remove (_tmp8_, _tmp9_);
	_tmp10_ = widget;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	result = TRUE;
	return result;
}


static void budgie_notifications_view_update_child_count (BudgieNotificationsView* self) {
	guint len = 0U;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gchar* text = NULL;
	guint _tmp5_ = 0U;
	BudgieRaven* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	BudgieHeaderWidget* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_list_free0 (_tmp2_);
	len = _tmp4_;
	text = NULL;
	_tmp5_ = len;
	if (_tmp5_ > ((guint) 1)) {
		const gchar* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("%u unread notifications");
		_tmp7_ = len;
		_tmp8_ = g_strdup_printf (_tmp6_, _tmp7_);
		_g_free0 (text);
		text = _tmp8_;
	} else {
		guint _tmp9_ = 0U;
		_tmp9_ = len;
		if (_tmp9_ == ((guint) 1)) {
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp10_ = _ ("1 unread notification");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (text);
			text = _tmp11_;
		} else {
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp12_ = _ ("No unread notifications");
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (text);
			text = _tmp13_;
		}
	}
	_tmp14_ = budgie_raven_get_instance ();
	_tmp15_ = len;
	budgie_raven_set_notification_count (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->header;
	_tmp17_ = text;
	budgie_header_widget_set_text (_tmp16_, _tmp17_);
	_g_free0 (text);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieNotificationsView* self;
		self = _data2_->self;
		_data2_->actions_copy = (_vala_array_free (_data2_->actions_copy, _data2_->actions_copy_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _budgie_notifications_view_on_notification_closed_budgie_notification_window_closed (BudgieNotificationWindow* _sender, BudgieNotificationCloseReason reason, gpointer self) {
	budgie_notifications_view_on_notification_closed ((BudgieNotificationsView*) self, _sender, reason);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda29_ (Block2Data* _data2_) {
	BudgieNotificationsView* self;
	BudgieNotificationWindow* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp2_ = FALSE;
	self = _data2_->self;
	_tmp0_ = _data2_->pack;
	_tmp1_ = _data2_->actions_copy;
	_tmp1__length1 = _data2_->actions_copy_length1;
	budgie_notification_window_set_actions (_tmp0_, _tmp1_, _tmp1__length1);
	_tmp2_ = _data2_->configure;
	if (_tmp2_) {
		BudgieNotificationWindow* _tmp3_ = NULL;
		_tmp3_ = _data2_->pack;
		budgie_notifications_view_configure_window (self, _tmp3_);
	} else {
		BudgieNotificationWindow* _tmp4_ = NULL;
		_tmp4_ = _data2_->pack;
		budgie_notification_window_begin_decay (_tmp4_);
	}
}


static void ___lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda29_ (self);
	block2_data_unref (self);
}


guint32 budgie_notifications_view_Notify (BudgieNotificationsView* self, const gchar* app_name, guint32 replaces_id, const gchar* app_icon, const gchar* summary, const gchar* body, gchar** actions, int actions_length1, GHashTable* hints, gint32 expire_timeout) {
	guint32 result = 0U;
	Block2Data* _data2_;
	guint32 _tmp0_ = 0U;
	guint32 _tmp1_ = 0U;
	gint32 expire = 0;
	gint32 _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gint32 _tmp7_ = 0;
	BudgieNotificationWindow* _tmp9_ = NULL;
	gchar** _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	BudgieNotificationWindow* _tmp32_ = NULL;
	guint32 _tmp33_ = 0U;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GHashTable* _tmp38_ = NULL;
	gint32 _tmp39_ = 0;
	guint32 _tmp40_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (app_name != NULL, 0U);
	g_return_val_if_fail (app_icon != NULL, 0U);
	g_return_val_if_fail (summary != NULL, 0U);
	g_return_val_if_fail (body != NULL, 0U);
	g_return_val_if_fail (hints != NULL, 0U);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->notif_id;
	self->priv->notif_id = _tmp0_ + 1;
	_data2_->pack = NULL;
	_data2_->configure = FALSE;
	_tmp1_ = replaces_id;
	if (_tmp1_ > ((guint32) 0)) {
		GHashTable* _tmp2_ = NULL;
		guint32 _tmp3_ = 0U;
		gconstpointer _tmp4_ = NULL;
		_tmp2_ = self->priv->notifications;
		_tmp3_ = replaces_id;
		_tmp4_ = g_hash_table_lookup (_tmp2_, (gpointer) ((guintptr) _tmp3_));
		_data2_->pack = (BudgieNotificationWindow*) _tmp4_;
	}
	_tmp5_ = expire_timeout;
	expire = _tmp5_;
	_tmp7_ = expire_timeout;
	if (_tmp7_ < ((gint32) 4000)) {
		_tmp6_ = TRUE;
	} else {
		gint32 _tmp8_ = 0;
		_tmp8_ = expire_timeout;
		_tmp6_ = _tmp8_ > ((gint32) 20000);
	}
	if (_tmp6_) {
		expire = (gint32) 4000;
	}
	_tmp9_ = _data2_->pack;
	if (_tmp9_ == NULL) {
		BudgieNotificationWindow* npack = NULL;
		BudgieNotificationWindow* _tmp10_ = NULL;
		gulong nid = 0UL;
		BudgieNotificationWindow* _tmp11_ = NULL;
		gulong _tmp12_ = 0UL;
		BudgieNotificationWindow* _tmp13_ = NULL;
		gulong _tmp14_ = 0UL;
		GHashTable* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
		BudgieNotificationWindow* _tmp17_ = NULL;
		BudgieNotificationWindow* _tmp18_ = NULL;
		BudgieNotificationWindow* _tmp19_ = NULL;
		_tmp10_ = budgie_notification_window_new (self);
		g_object_ref_sink (_tmp10_);
		npack = _tmp10_;
		_tmp11_ = npack;
		_tmp12_ = g_signal_connect_object (_tmp11_, "closed", (GCallback) _budgie_notifications_view_on_notification_closed_budgie_notification_window_closed, self, 0);
		nid = _tmp12_;
		_tmp13_ = npack;
		_tmp14_ = nid;
		g_object_set_data_full ((GObject*) _tmp13_, "npack_id", (gpointer) ((guintptr) _tmp14_), NULL);
		_tmp15_ = self->priv->notifications;
		_tmp16_ = self->priv->notif_id;
		_tmp17_ = npack;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		g_hash_table_insert (_tmp15_, (gpointer) ((guintptr) _tmp16_), _tmp18_);
		_tmp19_ = npack;
		_data2_->pack = _tmp19_;
		_data2_->configure = TRUE;
		_g_object_unref0 (npack);
	} else {
		GHashTable* _tmp20_ = NULL;
		guint32 _tmp21_ = 0U;
		GHashTable* _tmp22_ = NULL;
		guint32 _tmp23_ = 0U;
		BudgieNotificationWindow* _tmp24_ = NULL;
		BudgieNotificationWindow* _tmp25_ = NULL;
		_tmp20_ = self->priv->notifications;
		_tmp21_ = self->priv->notif_id;
		g_hash_table_steal (_tmp20_, (gpointer) ((guintptr) _tmp21_));
		_tmp22_ = self->priv->notifications;
		_tmp23_ = self->priv->notif_id;
		_tmp24_ = _data2_->pack;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		g_hash_table_insert (_tmp22_, (gpointer) ((guintptr) _tmp23_), _tmp25_);
	}
	_tmp26_ = g_new0 (gchar*, 0 + 1);
	_data2_->actions_copy = _tmp26_;
	_data2_->actions_copy_length1 = 0;
	_data2_->_actions_copy_size_ = _data2_->actions_copy_length1;
	_tmp27_ = actions;
	_tmp27__length1 = actions_length1;
	{
		gchar** action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = _tmp27_;
		action_collection_length1 = _tmp27__length1;
		for (action_it = 0; action_it < _tmp27__length1; action_it = action_it + 1) {
			gchar* _tmp28_ = NULL;
			gchar* action = NULL;
			_tmp28_ = g_strdup (action_collection[action_it]);
			action = _tmp28_;
			{
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				_tmp29_ = _data2_->actions_copy;
				_tmp29__length1 = _data2_->actions_copy_length1;
				_tmp30_ = action;
				_tmp31_ = g_strdup_printf ("%s", _tmp30_);
				_vala_array_add1 (&_data2_->actions_copy, &_data2_->actions_copy_length1, &_data2_->_actions_copy_size_, _tmp31_);
				_g_free0 (action);
			}
		}
	}
	_tmp32_ = _data2_->pack;
	_tmp33_ = self->priv->notif_id;
	_tmp34_ = app_name;
	_tmp35_ = app_icon;
	_tmp36_ = summary;
	_tmp37_ = body;
	_tmp38_ = hints;
	_tmp39_ = expire;
	budgie_notification_window_set_from_notify (_tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp38_, _tmp39_, ___lambda29__gasync_ready_callback, block2_data_ref (_data2_));
	_tmp40_ = self->priv->notif_id;
	result = _tmp40_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static void budgie_notifications_view_configure_window (BudgieNotificationsView* self, BudgieNotificationWindow* window) {
	gint x = 0;
	gint y = 0;
	GdkRectangle rect = {0};
	BudgieNotificationWindow* tail = NULL;
	GQueue* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	gint mon = 0;
	GdkScreen* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GdkScreen* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	BudgieNotificationWindow* _tmp9_ = NULL;
	GQueue* _tmp25_ = NULL;
	BudgieNotificationWindow* _tmp26_ = NULL;
	BudgieNotificationWindow* _tmp27_ = NULL;
	BudgieNotificationWindow* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	BudgieNotificationWindow* _tmp31_ = NULL;
	BudgieNotificationWindow* _tmp32_ = NULL;
	g_return_if_fail (self != NULL);
	x = 0;
	y = 0;
	_tmp0_ = self->priv->queue;
	_tmp1_ = g_queue_peek_tail (_tmp0_);
	tail = (BudgieNotificationWindow*) _tmp1_;
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	screen = _tmp3_;
	_tmp4_ = screen;
	_tmp5_ = gdk_screen_get_primary_monitor (_tmp4_);
	mon = _tmp5_;
	_tmp6_ = screen;
	_tmp7_ = mon;
	gdk_screen_get_monitor_geometry (_tmp6_, _tmp7_, &_tmp8_);
	rect = _tmp8_;
	_tmp9_ = tail;
	if (_tmp9_ != NULL) {
		gint nx = 0;
		gint ny = 0;
		BudgieNotificationWindow* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		BudgieNotificationWindow* _tmp15_ = NULL;
		GtkWidget* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp10_ = tail;
		gtk_window_get_position ((GtkWindow*) _tmp10_, &_tmp11_, &_tmp12_);
		nx = _tmp11_;
		ny = _tmp12_;
		_tmp13_ = nx;
		x = _tmp13_;
		_tmp14_ = ny;
		_tmp15_ = tail;
		_tmp16_ = gtk_bin_get_child ((GtkBin*) _tmp15_);
		_tmp17_ = gtk_widget_get_allocated_height (_tmp16_);
		y = (_tmp14_ + _tmp17_) + BUDGIE_BUFFER_ZONE;
	} else {
		GdkRectangle _tmp18_ = {0};
		gint _tmp19_ = 0;
		GdkRectangle _tmp20_ = {0};
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		GdkRectangle _tmp23_ = {0};
		gint _tmp24_ = 0;
		_tmp18_ = rect;
		_tmp19_ = _tmp18_.x;
		_tmp20_ = rect;
		_tmp21_ = _tmp20_.width;
		x = (_tmp19_ + _tmp21_) - BUDGIE_NOTIFICATION_SIZE;
		_tmp22_ = x;
		x = _tmp22_ - BUDGIE_BUFFER_ZONE;
		_tmp23_ = rect;
		_tmp24_ = _tmp23_.y;
		y = _tmp24_ + BUDGIE_INITIAL_BUFFER_ZONE;
	}
	_tmp25_ = self->priv->queue;
	_tmp26_ = window;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	g_queue_push_tail (_tmp25_, _tmp27_);
	_tmp28_ = window;
	_tmp29_ = x;
	_tmp30_ = y;
	gtk_window_move ((GtkWindow*) _tmp28_, _tmp29_, _tmp30_);
	_tmp31_ = window;
	gtk_widget_show_all ((GtkWidget*) _tmp31_);
	_tmp32_ = window;
	budgie_notification_window_begin_decay (_tmp32_);
	_g_object_unref0 (screen);
}


void budgie_notifications_view_GetServerInformation (BudgieNotificationsView* self, gchar** name, gchar** vendor, gchar** version, gchar** spec_version) {
	gchar* _vala_name = NULL;
	gchar* _vala_vendor = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_spec_version = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Raven");
	_g_free0 (_vala_name);
	_vala_name = _tmp0_;
	_tmp1_ = g_strdup ("Solus Project");
	_g_free0 (_vala_vendor);
	_vala_vendor = _tmp1_;
	_tmp2_ = g_strdup (BUDGIE_VERSION);
	_g_free0 (_vala_version);
	_vala_version = _tmp2_;
	_tmp3_ = g_strdup ("1.2");
	_g_free0 (_vala_spec_version);
	_vala_spec_version = _tmp3_;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	if (vendor) {
		*vendor = _vala_vendor;
	} else {
		_g_free0 (_vala_vendor);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (spec_version) {
		*spec_version = _vala_spec_version;
	} else {
		_g_free0 (_vala_spec_version);
	}
}


static void budgie_notifications_view_clear_all (BudgieNotificationsView* self) {
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	BudgieRaven* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_ = NULL;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		_g_list_free0 (child_collection);
	}
	budgie_notifications_view_update_child_count (self);
	_tmp3_ = budgie_raven_get_instance ();
	budgie_raven_ReadNotifications (_tmp3_);
}


static void _budgie_notifications_view_clear_all_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_notifications_view_clear_all ((BudgieNotificationsView*) self);
}


BudgieNotificationsView* budgie_notifications_view_construct (GType object_type) {
	BudgieNotificationsView * self = NULL;
	GtkImage* img = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkButton* btn = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	BudgieHeaderWidget* _tmp3_ = NULL;
	BudgieHeaderWidget* _tmp4_ = NULL;
	BudgieHeaderWidget* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	GQueue* _tmp9_ = NULL;
	GtkScrolledWindow* scrolledwindow = NULL;
	GtkScrolledWindow* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	GtkListBox* _tmp12_ = NULL;
	BudgieNotificationPlaceholder* placeholder = NULL;
	BudgieNotificationPlaceholder* _tmp13_ = NULL;
	GtkListBox* _tmp14_ = NULL;
	GtkListBox* _tmp15_ = NULL;
	self = (BudgieNotificationsView*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("list-remove-all-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	img = _tmp0_;
	gtk_widget_set_margin_top ((GtkWidget*) img, 4);
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-all-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	btn = _tmp1_;
	gtk_button_set_relief (btn, GTK_RELIEF_NONE);
	_tmp2_ = _ ("No new notifications");
	_tmp3_ = budgie_header_widget_new (_tmp2_, "notification-alert-symbolic", FALSE, NULL, (GtkWidget*) btn);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp3_;
	_tmp4_ = self->priv->header;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp4_, 6);
	g_signal_connect_object (btn, "clicked", (GCallback) _budgie_notifications_view_clear_all_gtk_button_clicked, self, 0);
	_tmp5_ = self->priv->header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = g_direct_hash;
	_tmp7_ = g_direct_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp8_;
	_tmp9_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->queue);
	self->priv->queue = _tmp9_;
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp10_);
	scrolledwindow = _tmp10_;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) scrolledwindow);
	gtk_style_context_add_class (_tmp11_, "raven-background");
	gtk_scrolled_window_set_policy (scrolledwindow, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) scrolledwindow, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp12_;
	_tmp13_ = budgie_notification_placeholder_new ();
	g_object_ref_sink (_tmp13_);
	placeholder = _tmp13_;
	_tmp14_ = self->priv->listbox;
	gtk_list_box_set_placeholder (_tmp14_, (GtkWidget*) placeholder);
	_tmp15_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) scrolledwindow, (GtkWidget*) _tmp15_);
	gtk_widget_show_all ((GtkWidget*) self);
	budgie_notifications_view_update_child_count (self);
	budgie_notifications_view_serve_dbus (self);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (scrolledwindow);
	_g_object_unref0 (btn);
	_g_object_unref0 (img);
	return self;
}


BudgieNotificationsView* budgie_notifications_view_new (void) {
	return budgie_notifications_view_construct (BUDGIE_TYPE_NOTIFICATIONS_VIEW);
}


static void budgie_notifications_view_on_bus_acquired (BudgieNotificationsView* self, GDBusConnection* conn) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		_tmp0_ = conn;
		budgie_notifications_view_register_object (self, _tmp0_, "/org/freedesktop/Notifications", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("notifications_view.vala:657: Unable to register notification dbus: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _budgie_notifications_view_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_notifications_view_on_bus_acquired ((BudgieNotificationsView*) self, connection);
}


static void budgie_notifications_view_serve_dbus (BudgieNotificationsView* self) {
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.freedesktop.Notifications", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_budgie_notifications_view_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_notifications_view_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_STRING) (gpointer data1, guint32 arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void budgie_notifications_view_class_init (BudgieNotificationsViewClass * klass) {
	budgie_notifications_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieNotificationsViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_view_finalize;
	g_signal_new ("notification_closed", BUDGIE_TYPE_NOTIFICATIONS_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("action_invoked", BUDGIE_TYPE_NOTIFICATIONS_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_STRING);
}


static void budgie_notifications_view_instance_init (BudgieNotificationsView * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	self->priv = BUDGIE_NOTIFICATIONS_VIEW_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("body");
	_tmp1_ = g_strdup ("body-markup");
	_tmp2_ = g_strdup ("actions");
	_tmp3_ = g_strdup ("action-icons");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	self->priv->caps = _tmp4_;
	self->priv->caps_length1 = 4;
	self->priv->_caps_size_ = self->priv->caps_length1;
	_tmp5_ = g_settings_new ("com.solus-project.budgie-panel");
	self->priv->settings = _tmp5_;
	self->priv->header = NULL;
	self->priv->queue = NULL;
	self->priv->notif_id = (guint32) 0;
}


static void budgie_notifications_view_finalize (GObject* obj) {
	BudgieNotificationsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsView);
	self->priv->caps = (_vala_array_free (self->priv->caps, self->priv->caps_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->listbox);
	__g_queue_free__g_object_unref0_0 (self->priv->queue);
	_g_hash_table_unref0 (self->priv->notifications);
	G_OBJECT_CLASS (budgie_notifications_view_parent_class)->finalize (obj);
}


GType budgie_notifications_view_get_type (void) {
	static volatile gsize budgie_notifications_view_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_notifications_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsView), 0, (GInstanceInitFunc) budgie_notifications_view_instance_init, NULL };
		GType budgie_notifications_view_type_id;
		budgie_notifications_view_type_id = g_type_register_static (gtk_box_get_type (), "BudgieNotificationsView", &g_define_type_info, 0);
		g_type_set_qdata (budgie_notifications_view_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_notifications_view_register_object);
		g_once_init_leave (&budgie_notifications_view_type_id__volatile, budgie_notifications_view_type_id);
	}
	return budgie_notifications_view_type_id__volatile;
}


static void _dbus_budgie_notifications_view_get_capabilities (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_notifications_view_get_capabilities (self, (GAsyncReadyCallback) _dbus_budgie_notifications_view_get_capabilities_ready, invocation);
}


static void _dbus_budgie_notifications_view_get_capabilities_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
	invocation = _user_data_;
	result = budgie_notifications_view_get_capabilities_finish ((BudgieNotificationsView*) source_object, _res_, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp1_ = result;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("as"));
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_string (*_tmp1_));
		_tmp1_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp2_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_notifications_view_CloseNotification (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 id = 0U;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	budgie_notifications_view_CloseNotification (self, id);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_notifications_view_Notify (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_name = NULL;
	GVariant* _tmp5_;
	guint32 replaces_id = 0U;
	GVariant* _tmp6_;
	gchar* app_icon = NULL;
	GVariant* _tmp7_;
	gchar* summary = NULL;
	GVariant* _tmp8_;
	gchar* body = NULL;
	GVariant* _tmp9_;
	gchar** actions = NULL;
	int actions_length1 = 0;
	GVariant* _tmp10_;
	gchar** _tmp11_;
	int _tmp11__length;
	int _tmp11__size;
	int _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	GHashTable* hints = NULL;
	GVariant* _tmp14_;
	GHashTable* _tmp15_;
	GVariantIter _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	gint32 expire_timeout = 0;
	GVariant* _tmp19_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	app_name = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	replaces_id = g_variant_get_uint32 (_tmp6_);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	app_icon = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	summary = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	body = g_variant_dup_string (_tmp9_, NULL);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_new (gchar*, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
	g_variant_iter_init (&_tmp12_, _tmp10_);
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
		if (_tmp11__size == _tmp11__length) {
			_tmp11__size = 2 * _tmp11__size;
			_tmp11_ = g_renew (gchar*, _tmp11_, _tmp11__size + 1);
		}
		_tmp11_[_tmp11__length++] = g_variant_dup_string (_tmp13_, NULL);
		g_variant_unref (_tmp13_);
	}
	actions_length1 = _tmp11__length1;
	_tmp11_[_tmp11__length] = NULL;
	actions = _tmp11_;
	g_variant_unref (_tmp10_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp15_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp16_, _tmp14_);
	while (g_variant_iter_loop (&_tmp16_, "{?*}", &_tmp17_, &_tmp18_)) {
		g_hash_table_insert (_tmp15_, g_variant_dup_string (_tmp17_, NULL), g_variant_get_variant (_tmp18_));
	}
	hints = _tmp15_;
	g_variant_unref (_tmp14_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	expire_timeout = g_variant_get_int32 (_tmp19_);
	g_variant_unref (_tmp19_);
	result = budgie_notifications_view_Notify (self, app_name, replaces_id, app_icon, summary, body, actions, actions_length1, hints, expire_timeout);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (app_name);
	_g_free0 (app_icon);
	_g_free0 (summary);
	_g_free0 (body);
	actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (hints);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_notifications_view_GetServerInformation (BudgieNotificationsView* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gchar* vendor = NULL;
	gchar* version = NULL;
	gchar* spec_version = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_notifications_view_GetServerInformation (self, &name, &vendor, &version, &spec_version);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (vendor));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (version));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (spec_version));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	_g_free0 (vendor);
	_g_free0 (version);
	_g_free0 (spec_version);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_notifications_view_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetCapabilities") == 0) {
		_dbus_budgie_notifications_view_get_capabilities (object, parameters, invocation);
	} else if (strcmp (method_name, "CloseNotification") == 0) {
		_dbus_budgie_notifications_view_CloseNotification (object, parameters, invocation);
	} else if (strcmp (method_name, "Notify") == 0) {
		_dbus_budgie_notifications_view_Notify (object, parameters, invocation);
	} else if (strcmp (method_name, "GetServerInformation") == 0) {
		_dbus_budgie_notifications_view_GetServerInformation (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_notifications_view_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_notifications_view_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_budgie_notifications_view_notification_closed (GObject* _sender, guint32 id, guint32 reason, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "NotificationClosed", _arguments, NULL);
}


static void _dbus_budgie_notifications_view_action_invoked (GObject* _sender, guint32 id, const gchar* action_key, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action_key));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "ActionInvoked", _arguments, NULL);
}


guint budgie_notifications_view_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_notifications_view_dbus_interface_info), &_budgie_notifications_view_dbus_interface_vtable, data, _budgie_notifications_view_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "notification-closed", (GCallback) _dbus_budgie_notifications_view_notification_closed, data);
	g_signal_connect (object, "action-invoked", (GCallback) _dbus_budgie_notifications_view_action_invoked, data);
	return result;
}


static void _budgie_notifications_view_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_view_notification_closed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_notifications_view_action_invoked, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



