/*
 * $Id: oodate.c,v 1.4 2003/09/25 15:33:46 jmmv Exp $
 *
 * buildtool
 * Copyright (c) 2003 Julio M. Merino Vidal
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the author nor the names of contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <config.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

static char *ProgName;

static void
usage(void)
{
	(void)fprintf(stderr, "usage: %s dest_file src_file1 ... src_fileN\n",
	              ProgName);
	exit(2);
}

int
main(int argc, char **argv)
{
	char *destfile, *srcfile;
	int i, oodate;
	struct stat dfstat, sfstat;

	if ((ProgName = strrchr(argv[0], '/')) != NULL)
		ProgName++;
	else
		ProgName = argv[0];

	if (argc < 3) {
		usage();
		/* NOTREACHED */
	}

	destfile = argv[1];
	if (stat(destfile, &dfstat) != 0) {
		return 0;
		/*fprintf(stderr, "%s: cannot stat %s: %s\n", ProgName, destfile,
		        strerror(errno));
		exit(2);*/
	}

	oodate = 1; /* Shell false */
	for (i = 2; i < argc && oodate; i++) {
		srcfile = argv[i];
		if (stat(srcfile, &sfstat) != 0) {
			oodate = 0;
			break;
			/*fprintf(stderr, "%s: cannot stat %s: %s\n", ProgName,
		                srcfile, strerror(errno));
			exit(2);*/
		}

		if (dfstat.st_mtime < sfstat.st_mtime) {
			oodate = 0; /* Shell true */
		}
	}

	return oodate;
}
