# $Id: buildtool.spec,v 1.15 2004/05/14 21:58:22 jmmv Exp $
#

#
# Package version information:
#
%define _name		buildtool
%define _version	0.16
%define _rel		1
%define _majorversion 	0

#
# Detect distribution:
#
%define _suse		%([ -f /etc/SuSE-release ]; echo $?)
%define _redhat		%([ -f /etc/redhat-release ]; echo $?)
%define _mandrake	%([ -f /etc/mandrake-release ]; echo $?)

#
# Default settings:
#
%define _prefix		/usr
%define _sysconfdir	/etc/%{_name}
%define _release	%_rel
%define _has_distro	0
%define _group		Development/Tools

#
# Distribution-specific overrides:
#
%if %_suse
%define _suse_version	%(grep VERSION /etc/SuSE-release|cut -f3 -d" ")
%define _suse_vernum	%(echo "%_suse_version"|tr -d '.')
%define _release	%{_rel}suse%{_suse_vernum}
%define _has_distro	1
%define _distribution	SuSE Linux %_suse_version
%define _group		Development/Tools/Building
%endif
%if %_redhat
%define _redhat_version	%(grep release /etc/redhat-release|cut -f5 -d" ")
%define _redhat_vernum	%(echo "%_redhat_version"|tr -d '.')
%define _release	%{_rel}rh%{_redhat_vernum}
%define _has_distro	1
%define _distribution	Redhat Linux %_redhat_version
%define _group		Development/Tools/Building
%endif
%if %_mandrake
%define _mdk_version	%(grep release /etc/mandrake-release|cut -f5 -d" ")
%define _mdk_vernum	%(echo "%_mdk_version"|tr -d '.')
%define _release	%{_rel}mdk%{_mdk_vernum}
%define _has_distro	1
%define _distribution	Mandrake Linux %_mdk_version
%define _group		Development/Tools/Building
%endif

Summary:		Build Infrastructure for Source Packages
Summary(fr):		Infrastructure de construction de paquetages sources
Summary(de):		Build-Infrastruktur fr Quell-Pakete
Summary(es):		Infraestructura de compilacin para paquetes de fuentes
Summary(ca):		Infrastructura de compilaci per paquets de codi font
Name:			%{_name}
Version:		%{_version}
Release:		%{_release}
Source:			%{_name}-%{_version}.tar.gz
URL:			http://buildtool.sourceforge.net/
Group:			%{_group}
Packager:		Pascal Bleser <guru@unixtech.be>
Copyright:		BSD-style
BuildRoot:		%{_tmppath}/build-%{_name}-%{_version}
Prefix:			%{_prefix}
Provides:		%{_name}-%{_majorversion}
%if %_has_distro
Distribution:		%_distribution
%endif

%description
Buildtool is an integrated set of utilities designed to simplify the
build system used in source code packages. The build system is a
process formed by these three steps: configure the sources, build them
and install the results. Buildtool provides the necessary tools to
accomplish all of these. Even more, it also contains convenience tools
to make your package more user-friendly.

If you have ever used some of the GNU build system utilities such as
Autoconf, Automake and/or Libtool, you will see that Buildtool
provides most of their functionality. In fact, it is an implementation
of the same concepts, although the way to accomplish them is quite
different.

Detailed documentation is available either by typing the following command:
  man %{_name}
or by pointing your favourite web browser to:
  http://buildtool.sourceforge.net/docs.html

%description -l fr
Buildtool est un ensemble intgr d'outils ayant pour but de simplifier
le systme de construction (compilation) utilis dans les paquetages de
code source. Le systme de construction est un processus compos de ces
trois tapes: configuration des sources, compilation et installation des
fichiers rsultants. Buildtool apporte les outils ncessaires  accomplir
ces trois tapes, et contient mme des outils facilitant la cration de
paquetages orients utilisateurs.

Si vous avez dj utilis certains outils du systme de construction GNU
comme Autoconf, Automake et/ou Libtool, vous vous rendrez compte que
Buildtool fournit la plupart de leurs fonctionnalits. En fait, c'est une
implmentation des mmes concepts, avec pour diffrence que la faon de
les accomplir est fort diffrente.

Une documentation dtaille est disponible soit en tapant la commande suivante:
  man %{_name}
ou en pointant votre navigateur web prfr  l'adresse suivante:
  http://buildtool.sourceforge.net/docs.html

%description -l de
Buildtool ist eine integrierte Sammlung von Werkzeugen zur Vereinfachung
des Build-Systems das in Quellcode-Paketen verwendet wird. Dieses Build-
System is ein Prozess der aus den folgenden drei Schritten besteht:
Konfiguration der Quellen, Bauen dieser Quellen und Installation der
daraus resultierenden Dateien. Buildtool bietet die notwendigen Werkzeuge
um alle diese Schritte zu vollziehen. Es liefert sogar Hilfswerkzeuge zum
Erstellen von benutzerfreundlicheren Paketen.

Wenn Sie jemals einige der Werkzeuge des GNU-Build-Systems verwendet haben
wie etwa Autoconf, Automake und/oder Libtool, dann werden Sie sehen dass
Buildtool das meiste ihrer Funktionalitten abdeckt. Eigentlich ist es eine
Implementierung der selben Konzepte, obwohl die Art und Weise diese zu
vollziehen ziemlich verschieden ist.

Eine detaillierte Dokumentation ist verfgbar wenn Sie den folgenden Befehl
eingeben:
  man %{_name}
oder wenn Sie Ihren bevorzugten Web-Browser auf die folgende Adresse schicken:
  http://buildtool.sourceforge.net/docs.html

%description -l es
Buildtool es un conjunto de utilidades diseado con la finalidad de simplificar
el sistema de compilacin usado el paquetes de cdigo fuente. El sistema de
compilacin es un proceso formado por los siguientes tres pasos: configurar los
fuentes, compilarlos e instalar los resultados. Buildtool proporciona las
herramientas necesarias para conseguir estos pasos. Adems proporciona otras
utilidades para hacer el desarrollo del proyecto ms amigable.

Si alguna vez ha usado alguna de las herramientas del sistema de compilacin
GNU, tales como Autoconf, Automake y/o Libtool, ver que Buildtool proporciona
gran parte de su funcionalidad. De hecho, se trata de una implementacin de los
mismos conceptos, aunque el modo de llevarlos a cabo es algo diferente.

Puede encontrar documentacin detallada ya sea ejecutando el siguiente comando:
  man %{_name}
o bien dirigiendo su navegador a la siguiente direccin:
  http://buildtool.sourceforge.net/docs.html

%description -l ca
Buildtool es un conjunt d'utilitats dissenyat amb la finalitat de simplificar
el sistema de compilaci usat en paquets de codi font. El sistema de compilaci
es un procs format pels segents tres passos: configurar els arxius de codi
font, compilarlos i instalar el resultat. Buildtool proporciona les eines
necessries per aconseguir aquests passos. A ms inclou altres utilitats que
fan el procs de desenvolupament d'un projecte ms amigable.

Si alguna vegada ha usat alguna de les eines del sistema de compilaci GNU,
tals com Autoconf, Automake i/o Libtool, veur que Buildtool proporciona la
major part de la seva funcionalitat. De fet, es tracta d'una implementaci dels
mateixos conceptes, tot i que la manera de portarlos a cap es substancialment
diferent.

Pot trobar documentaci detallada ja sigui executant la segent comanda:
  man %{_name}
o b dirigint el seu navegador a la segent adrea:
  http://buildtool.sourceforge.net/docs.html

%prep
%setup -q
CFLAGS="${RPM_OPT_FLAGS}" \
CXXFLAGS="${RPM_OPT_FLAGS}" \
./configure \
    -p "%{_prefix}" \
    -c "%{_sysconfdir}/%{_name}" \
    -d "%{_docdir}/%{_name}" \
    -M "%{_mandir}"

%build
%{__make}

%install
%{__rm} -rf "${RPM_BUILD_ROOT}"

%{__make} \
    DESTDIR="${RPM_BUILD_ROOT}" \
    install

%{__mkdir_p} "${RPM_BUILD_ROOT}%{_sysconfdir}/%{_name}"

%clean
%{__rm} -rf "${RPM_BUILD_ROOT}"

%files
%defattr(-,root,root)
%doc %{_docdir}/%{_name}
%{_bindir}/*
%attr(0755,root,root) %{_sysconfdir}/%{_name}
%{_libexecdir}/%{_name}-%{_majorversion}
%{_datadir}/%{_name}-%{_majorversion}
%doc %{_mandir}/man*/*

%changelog
* Fri May 14 2004 Julio M. Merino Vidal <jmmv@users.sourceforge.net> 0.16-1
- Update to Buildtool 0.16.

* Wed Feb  4 2004 Julio M. Merino Vidal <jmmv@users.sourceforge.net> 0.15-1
- Update to Buildtool 0.15.

* Sat Sep  6 2003 Pascal Bleser <guru@unixtech.be> 0.14-2
- Added support for Mandrake (not tested yet).

* Mon Sep  5 2003 Julio M. Merino Vidal <jmmv@users.sourceforge.net> 0.14-1
- Update to Buildtool 0.14.

* Mon Sep  1 2003 Julio M. Merino Vidal <jmmv@users.sourceforge.net> 0.13-3
- Added spanish and catalan translation of package information.

* Mon Sep  1 2003 Pascal Bleser <guru@unixtech.be> 0.13-2
- Added french and german translation of package information.
- Added small fix for %_docdir: must not be defined by spec file, is already
  defined by distribution's RPM macros.

* Fri Aug 29 2003 Julio M. Merino Vidal <jmmv@users.sourceforge.net> 0.13-1
- Update to Buildtool 0.13.

* Wed Jun 4 2003 Doug Henry <doug_henry@xontech.com> 0.12-1
- RedHat autodetection.
- Update to Buildtool 0.12.

* Sun Apr 13 2003 Pascal Bleser <guru@unixtech.be> 0.11-1
- SuSE autodetection.
- First RPM.

# Local Variables:
# mode: rpm-spec
# End:
