#!/usr/bin/env python
# Copyright (C) 2007-2008 James Henstridge
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from distutils.core import setup
import os

# Get version number from this copy of bzr-avahi:
globals = {}
execfile(os.path.join(os.path.dirname(__file__), '__init__.py'), globals)
version = globals['__version__']
del globals

setup(
    name='bzr-avahi',
    version=version,
    maintainer='James Henstridge',
    maintainer_email='james@jamesh.id.au',
    description='Bazaar plugin to advertise and browse branches via mDNS',
    license='GNU GPL',
    url='https://launchpad.net/bzr-avahi',
    packages=['bzrlib.plugins.avahi', 'bzrlib.plugins.avahi.tests'],
    package_dir={'bzrlib.plugins.avahi': '.',
                 'bzrlib.plugins.avahi.tests': 'tests'},
)
