#ifndef __LIST_H__
#define __LIST_H__

typedef struct
{
  char jid[1024];
  char name[1024];
  char group[1024];
  char resource[1024];
  int connected;
}
element;

typedef struct Node
{
  element *elemento;
  struct Node *next;
}
node;

typedef element *elementT;
typedef node *Ptrnode;
typedef node *List;

List NewList (void);
void DeleteList (List l);
Ptrnode NextInList (Ptrnode p);
Ptrnode FirstInList (List l);
Ptrnode HeaderList (List l);
void InsertInList (elementT t, Ptrnode p, List l);
elementT RetrieveFromList (Ptrnode p);
char *FindJidInList (char *jid, List l);
char *FindSelectedJidInList (int selected, List l);
char *FindJidNameInList (char *jid, List l);
char *FindSelectedJidResourceInList (int selected, List roster);
char *FindSelectedJidJidInList (int selected, List l);
void SortListByName (List l);
void DeleteOfList (Ptrnode p, List l);

#endif
