#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <unistd.h>
#include "utils.h"

#include "socket.h"
#include <signal.h>

/* Desc: create socket connection
 * 
 * In  : servername, port
 * Out : socket (or -1 on error)
 *
 * Note: -
 */
int sk_conn(struct sockaddr *name)
{
  int sock;

  if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
    perror("socket (socket.c:23)");
    return -1;
  }

  if (connect(sock, (struct sockaddr *) name, sizeof(struct sockaddr)) < 0) {
    perror("connect (socket.c:29)");
    return -1;
  }

  return sock;
}


/* Desc: send data through socket
 * 
 * In  : socket, buffer to send
 * Out : 0 = fail, 1 = pass
 *
 * Note: -
 */
int sk_send(int sock, char *buffer)
{
  if ((send(sock, buffer, strlen(buffer), 0)) == -1)
    return 0;
  else
    return 1;
}

/* Desc: receive data through socket
 * 
 * In  : socket
 * Out : received buffer
 *
 * Note: it is up to the caller to free the returned string
 */


char *sk_recv(int sock)
{
  int i = 1;
  int end = 0;
  int tambuffer = 128;
  char *aux;

  char *buffer = malloc(tambuffer);
  char *retval = malloc(tambuffer + 1);

  memset(retval, 0, tambuffer);
  memset(buffer, 0, tambuffer + 1);

  while (!end) {
    recv(sock, buffer, tambuffer, 0);

    if (i == 1)
      strcpy(retval, buffer);
    else {
      retval = realloc(retval, (tambuffer * i) + 1);
      strncat(retval, buffer, tambuffer + 1);
    }
    i++;
    aux = retval + strlen(retval) - 1;
    if (*aux != '>')
      end = 0;
    else
      end = 1;
    memset(buffer, 0, tambuffer);
  }
  free(buffer);
  return retval;
}
