public class test_return_subtype_ok {

    public static void main(String[] args) {
        TestController ct = new TestController();

        TestLoader ld1 = new TestLoader(ClassLoader.getSystemClassLoader(), "ld1", ct);
        TestLoader ld2 = new TestLoader(ClassLoader.getSystemClassLoader(), "ld2", ct);

        ld1.addClassfile("Foo", "classes1/Foo.class");
        ld1.addClassfile("DerivedFoo", "classes2/DerivedFoo.class");
        ld1.addParentDelegation("java.lang.Object");
        ld1.addParentDelegation("java.lang.String");

        ld2.addClassfile("BarPassFoo", "classes2/BarPassFoo.class");
        ld2.addDelegation("Foo", ld1);
        ld2.addDelegation("DerivedFoo", ld1);
        ld2.addParentDelegation("java.lang.Object");
        ld2.addParentDelegation("java.lang.String");

        // loading & linking BarPassFoo
        ct.expect("requested", ld2, "BarPassFoo");
        ct.expectLoadFromSystem(ld2, "java.lang.Object");
        ct.expect("defined", ld2, "<BarPassFoo>");
        ct.expect("loaded", ld2, "<BarPassFoo>");

        Class cls = ct.loadClass(ld2, "BarPassFoo");

        // executing createDerivedFoo
        ct.expectDelegation(ld2, ld1, "DerivedFoo");
        // ...linking (ld2, DerivedFoo)
        ct.expect("requested", ld1, "Foo");
        ct.expectLoadFromSystem(ld1, "java.lang.Object");
        ct.expect("defined", ld1, "<Foo>");
        ct.expectDelegationDefinition(ld2, ld1, "DerivedFoo");

        ct.checkStringGetter(cls, "getDerivedFoo", "no exception");
        ct.expectEnd();

        // subtype check (DerivedFoo subtypeof Foo)
        ct.expectDelegationAndFound(ld2, ld1, "Foo");

        ct.checkStringGetter(cls, "getDerivedFooAsFoo", "no exception");

        ct.exit();
    }

}

// vim: et sw=4
