/*
 * Calcurse - text-based organizer
 * Copyright (c) 2004-2005 Frederic Culot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Send your feedback or comments to : calcurse@culot.org
 * Calcurse home page : http://culot.org/calcurse
 *
 */

#include <ncurses.h>		/* ncurses.h includes stdio.h */
#include <panel.h>
#include <time.h>		/* to get the date */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <math.h>

#include "utils.h"
#include "vars.h"


/* print fatal error mesg and exit */

void cal_error(char *mesg)
{
	erase_status_bar();
	attron(COLOR_PAIR(1));
	mvprintw(row - 2, 0, mesg);
	mvprintw(row - 1, 0, "[press ENTER]");
	attroff(COLOR_PAIR(1));
	getch();
}

/* Erase the status bar */
void erase_status_bar()
{
	int i;

	for (i = 0; i <= col; i++) {
		mvprintw(row - 2, i, " ");
		mvprintw(row - 1, i, " ");
	}
	refresh();
}

/* Erases a panel : must specify the y and x coorinates, the line and column */
void erase_panel(int y, int x, int l, int c)
{
	int i, j;

	for (i = y + 3; i <= (y + l - 2); i++) {
		for (j = x + 1; j <= (x + c - 2); j++) {
			mvprintw(i, j, " ");
		}
	}
	refresh();
}

/* draws a popup window */
WINDOW
    * popup(int pop_row, int pop_col,
	    int pop_y, int pop_x, char *pop_lab, int pop_colr)
{
	char txt_pop[] = "Press any key to continue...";
	char label[80];
	WINDOW *popup_win;

	popup_win = newwin(pop_row, pop_col, pop_y, pop_x);
	wattrset(popup_win, COLOR_PAIR(pop_colr) | WA_BOLD);
	box(popup_win, 0, 0);
	sprintf(label, "%s", pop_lab);
	win_show(popup_win, label, pop_colr);
	wrefresh(popup_win);
	attron(COLOR_PAIR(pop_colr));
	mvprintw(pop_row - 1, pop_col - (strlen(txt_pop) + 1), "%s",
		 txt_pop);
	attroff(COLOR_PAIR(pop_colr));
	doupdate();
	return popup_win;
}

/* prints in middle of a panel */
void
print_in_middle(WINDOW * win, int starty, int startx, int width,
		char *string, chtype color)
{
	int length, x, y;
	float temp;

	if (win == NULL)
		win = stdscr;
	getyx(win, y, x);
	if (startx != 0)
		x = startx;
	if (starty != 0)
		y = starty;
	if (width == 0)
		width = 80;

	length = strlen(string);
	temp = (width - length) / 2;
	x = startx + (int) temp;
	wattron(win, color);
	mvwprintw(win, y, x, "%s", string);
	wattroff(win, color);
	refresh();
}

/* getstring */
void getstring(string, start_x, start_y)	// To see the user input even with noecho()
char *string;
int start_x, start_y;
{
	int ch;
	int charcount = 0;

	if (start_x != -1)
		move(start_y, start_x);

	while ((ch = getch()) != '\n') {
		if (ch == 263) {	//backspace was hit
			if (charcount > 0) {
				string--;
				charcount--;
				move(start_y, start_x + charcount);
				addch(' ');
				move(start_y, start_x + charcount);
			}
		} else {
			*string++ = ch;
			charcount++;
			addch(ch);
		}
		refresh();
	}
	*string = 0;
	return;
}

/* checks if a string is only made of digits */
int is_all_digit(char *string)
{
	int digit, i;
	int all_digit;

	digit = 0;
	all_digit = 0;

	for (i = 0; i <= strlen(string); i++)
		if (isdigit(string[i]) != 0)
			digit++;
	if (digit == strlen(string))
		all_digit = 1;
	return all_digit;
}

/* draw panel border in color */
void border_color(WINDOW * window, int bcolr)
{
	wattrset(window, COLOR_PAIR(bcolr) | WA_BOLD);
	box(window, 0, 0);
	update_panels();
	doupdate();
}

 /* prints and scroll text in a window */
void scroller(char *mesg, int x, int y, int nb_row, int nb_col, int colr)
{
	int x_offset = 3;
	int y_offset = 3;
	int text_len = nb_col - 2 * x_offset;
	int text_max_row = nb_row - 3;
	int nlin, i, j, k;
	int last_blank_i, last_blank_j;
	char buf[] = " ";
	char *dst;
	char next_mesg[] = "-- Press 'N' for next page --";
	char prev_mesg[] = "-- Press 'P' for previous page --";
	int ch;
	int which_page;		//first page : 0, second page : 1

	i = 0;			//position in the message
	j = 0;			//x position on the current line
	nlin = 1;		//line number 
	last_blank_j = 0;
	last_blank_i = 0;
	which_page = 0;

	while (i <= strlen(mesg)) {
		if ((i == strlen(mesg)) & (which_page == 1)) {
			// we have finished writing text and we are on second page
			attron(COLOR_PAIR(colr));
			mvprintw(nb_row - 2,
				 nb_col - (strlen(prev_mesg) + 2), "%s",
				 prev_mesg);
			attroff(COLOR_PAIR(colr));
			refresh();
			ch = getch();
			if (ch == 'P' | ch == 'p') {
				erase_panel(y, x, nb_row, nb_col);
				nlin = 1;
				j = 0;
				i = 0;
				which_page = 0;
			} else {	//erase last line and exit next-prev page mode
				for (k = 1; k < nb_col - 2; k++)
					mvprintw(nb_row - 2, k, " ");
				break;
			}
		}
		if (nlin == text_max_row - 2) {	// we reach the last line
			attron(COLOR_PAIR(colr));
			mvprintw(nb_row - 2,
				 nb_col - (strlen(next_mesg) + 2), "%s",
				 next_mesg);
			attroff(COLOR_PAIR(colr));
			refresh();
			ch = getch();
			if (ch == 'N' | ch == 'n') {
				erase_panel(y, x, nb_row, nb_col);
				nlin = 1;
				j = 0;
				which_page = 1;
			} else {
				for (k = 1; k < nb_col - 2; k++)
					mvprintw(nb_row - 2, k, " ");
				break;
			}
		}
		//write text
		strncpy(buf, mesg + i, 1);
		i++;
		j++;
		if ((strncmp(buf, "", 1) == 0)) {	// is the character for a new line
			buf[0] = '\0';
			mvprintw(x + x_offset + nlin, y + y_offset + j,
				 "%s", buf);
			nlin++;
			j = 0;
		} else {
			if (j == text_len - 1) {	// if we reach the terminal border
				for (k = last_blank_j; k <= text_len - 1;
				     k++)
					mvprintw(x + x_offset + nlin,
						 y + y_offset + k, " ");
				nlin++;
				i = last_blank_i;
				j = 0;
			} else {
				if ((strncmp(buf, " ", 1) == 0))	//space between words
				{
					last_blank_j = j;	//save position
					last_blank_i = i;
				}
				mvprintw(x + x_offset + nlin,
					 y + y_offset + j, "%s", buf);
			}
		}
	}
	refresh();
}

/* Draws the status bar */
void status_bar(int which_pan, int colr)
{
	int nb_item_cal, nb_item_oth;
	int len_let, len_des, spc_lad;
	int spc_bet_cal_itm, spc_bet_oth_itm;
	int len_cal_itm, len_oth_itm;

	nb_item_cal = 10;	//put here the max item number to display in status bar
	nb_item_cal = ceil(nb_item_cal / 2);	//we have two lines to display items on status bar
	nb_item_oth = 12;
	nb_item_oth = ceil(nb_item_oth / 2);
	len_let = 3;
	len_des = 8;
	spc_lad = 1;

	spc_bet_cal_itm =
	    floor((col -
		   nb_item_cal * (len_let + len_des +
				  spc_lad)) / nb_item_cal);
	spc_bet_oth_itm =
	    floor((col -
		   nb_item_oth * (len_let + len_des +
				  spc_lad)) / nb_item_oth);
	len_cal_itm = len_let + spc_lad + len_des + spc_bet_cal_itm;
	len_oth_itm = len_let + spc_lad + len_des + spc_bet_oth_itm;

	erase_status_bar();
	if (which_pan == 0) {
		attron(COLOR_PAIR(colr));
		mvprintw(row - 2, 0, "  ?");
		mvprintw(row - 1, 0, "  Q");
		mvprintw(row - 2, len_cal_itm, "  R");
		mvprintw(row - 1, len_cal_itm, "  S");
		mvprintw(row - 2, 2 * len_cal_itm, "H/L");
		mvprintw(row - 1, 2 * len_cal_itm, "J/K");
		mvprintw(row - 2, 3 * len_cal_itm, "  G");
		mvprintw(row - 1, 3 * len_cal_itm, "Tab");
		mvprintw(row - 2, 4 * len_cal_itm, "  C");
		attroff(COLOR_PAIR(colr));
		refresh();

		mvprintw(row - 2, len_let + spc_lad, "Help");
		mvprintw(row - 1, len_let + spc_lad, "Quit");
		mvprintw(row - 2, len_cal_itm + len_let + spc_lad,
			 "Redraw");
		mvprintw(row - 1, len_cal_itm + len_let + spc_lad, "Save");
		mvprintw(row - 2, 2 * len_cal_itm + len_let + spc_lad,
			 "-/+1 Day");
		mvprintw(row - 1, 2 * len_cal_itm + len_let + spc_lad,
			 "-/+1 Week");
		mvprintw(row - 2, 3 * len_cal_itm + len_let + spc_lad,
			 "GoTo");
		mvprintw(row - 1, 3 * len_cal_itm + len_let + spc_lad,
			 "Chg View");
		mvprintw(row - 2, 4 * len_cal_itm + len_let + spc_lad,
			 "Config");
	} else {
		attron(COLOR_PAIR(colr));
		mvprintw(row - 2, 0, "  ?");
		mvprintw(row - 1, 0, "  Q");
		mvprintw(row - 2, len_oth_itm, "  R");
		mvprintw(row - 1, len_oth_itm, "  S");
		mvprintw(row - 2, 2 * len_oth_itm, "J/K");
		mvprintw(row - 1, 2 * len_oth_itm, "Tab");
		mvprintw(row - 2, 3 * len_oth_itm, "  A");
		mvprintw(row - 1, 3 * len_oth_itm, "  D");
		mvprintw(row - 2, 4 * len_oth_itm, "  G");
		mvprintw(row - 1, 4 * len_oth_itm, "  V");
		mvprintw(row - 2, 5 * len_oth_itm, "  C");
		attroff(COLOR_PAIR(colr));
		refresh();

		mvprintw(row - 2, len_let + spc_lad, "Help");
		mvprintw(row - 1, len_let + spc_lad, "Quit");
		mvprintw(row - 2, len_oth_itm + len_let + spc_lad,
			 "Redraw");
		mvprintw(row - 1, len_oth_itm + len_let + spc_lad, "Save");
		mvprintw(row - 2, 2 * len_oth_itm + len_let + spc_lad,
			 "Up/Down");
		mvprintw(row - 1, 2 * len_oth_itm + len_let + spc_lad,
			 "Chg View");
		mvprintw(row - 2, 3 * len_oth_itm + len_let + spc_lad,
			 "Add Item");
		mvprintw(row - 1, 3 * len_oth_itm + len_let + spc_lad,
			 "Del Item");
		mvprintw(row - 2, 4 * len_oth_itm + len_let + spc_lad,
			 "GoTo");
		mvprintw(row - 1, 4 * len_oth_itm + len_let + spc_lad,
			 "View");
		mvprintw(row - 2, 5 * len_oth_itm + len_let + spc_lad,
			 "Config");
	}

	refresh();
	doupdate();
}

